/*
 * Decompiled with CFR 0.152.
 */
package com.easypost.service;

import com.easypost.exception.EasyPostException;
import com.easypost.http.Requestor;
import com.easypost.model.Event;
import com.easypost.model.EventCollection;
import com.easypost.model.Payload;
import com.easypost.model.PayloadCollection;
import com.easypost.service.EasyPostClient;
import java.util.List;
import java.util.Map;

public class EventService {
    private final EasyPostClient client;

    EventService(EasyPostClient client) {
        this.client = client;
    }

    public Event retrieve(String id) throws EasyPostException {
        String endpoint = "events/" + id;
        return Requestor.request(Requestor.RequestMethod.GET, endpoint, null, Event.class, this.client);
    }

    public EventCollection all(Map<String, Object> params) throws EasyPostException {
        String endpoint = "events";
        return Requestor.request(Requestor.RequestMethod.GET, endpoint, params, EventCollection.class, this.client);
    }

    public List<Payload> retrieveAllPayloads(String eventId) throws EasyPostException {
        String endpoint = "events/" + eventId + "/payloads";
        PayloadCollection payloads = Requestor.request(Requestor.RequestMethod.GET, endpoint, null, PayloadCollection.class, this.client);
        return payloads.getPayloads();
    }

    public Payload retrievePayload(String eventId, String payloadId) throws EasyPostException {
        String endpoint = "events/" + eventId + "/payloads/" + payloadId;
        return Requestor.request(Requestor.RequestMethod.GET, endpoint, null, Payload.class, this.client);
    }
}

