/*
 * Decompiled with CFR 0.152.
 */
package com.easypost.service;

import com.easypost.exception.EasyPostException;
import com.easypost.http.Requestor;
import com.easypost.model.Order;
import com.easypost.model.Rate;
import com.easypost.service.EasyPostClient;
import java.util.HashMap;
import java.util.Map;

public class OrderService {
    private final EasyPostClient client;

    OrderService(EasyPostClient client) {
        this.client = client;
    }

    public Order create(Map<String, Object> params) throws EasyPostException {
        HashMap<String, Object> wrappedParams = new HashMap<String, Object>();
        wrappedParams.put("order", params);
        String endpoint = "orders";
        return Requestor.request(Requestor.RequestMethod.POST, endpoint, wrappedParams, Order.class, this.client);
    }

    public Order retrieve(String id) throws EasyPostException {
        String endpoint = "orders/" + id;
        return Requestor.request(Requestor.RequestMethod.GET, endpoint, null, Order.class, this.client);
    }

    public Order newRates(String id) throws EasyPostException {
        return this.newRates(id, null);
    }

    public Order newRates(String id, Map<String, Object> params) throws EasyPostException {
        String endpoint = "orders/" + id + "/rates";
        return Requestor.request(Requestor.RequestMethod.GET, endpoint, params, Order.class, this.client);
    }

    public Order buy(String id, Map<String, Object> params) throws EasyPostException {
        String endpoint = "orders/" + id + "/buy";
        return Requestor.request(Requestor.RequestMethod.POST, endpoint, params, Order.class, this.client);
    }

    public Order buy(String id, Rate rate) throws EasyPostException {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("carrier", rate.getCarrier());
        params.put("service", rate.getService());
        return this.buy(id, params);
    }
}

