/*
 * Decompiled with CFR 0.152.
 */
package com.easypost.service;

import com.easypost.exception.APIException;
import com.easypost.exception.EasyPostException;
import com.easypost.exception.General.EndOfPaginationError;
import com.easypost.http.Requestor;
import com.easypost.model.Address;
import com.easypost.model.AddressCollection;
import com.easypost.model.AddressVerifyResponse;
import com.easypost.service.EasyPostClient;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;

public class AddressService {
    private final EasyPostClient client;

    AddressService(EasyPostClient client) {
        this.client = client;
    }

    public Address create(Map<String, Object> params) throws EasyPostException {
        HashMap<String, Object> wrappedParams = new HashMap<String, Object>();
        if (params.containsKey("verify")) {
            wrappedParams.put("verify", params.remove("verify"));
        }
        if (params.containsKey("verify_strict")) {
            wrappedParams.put("verify_strict", params.remove("verify_strict"));
        }
        wrappedParams.put("address", params);
        String endpoint = "addresses";
        return Requestor.request(Requestor.RequestMethod.POST, endpoint, wrappedParams, Address.class, this.client);
    }

    public Address retrieve(String id) throws EasyPostException {
        String endpoint = "addresses/" + id;
        return Requestor.request(Requestor.RequestMethod.GET, endpoint, null, Address.class, this.client);
    }

    public AddressCollection all(Map<String, Object> params) throws APIException {
        String endpoint = "addresses";
        return Requestor.request(Requestor.RequestMethod.GET, endpoint, params, AddressCollection.class, this.client);
    }

    public AddressCollection getNextPage(AddressCollection collection) throws EndOfPaginationError {
        return this.getNextPage(collection, null);
    }

    public AddressCollection getNextPage(AddressCollection collection, Integer pageSize) throws EndOfPaginationError {
        return collection.getNextPage(new Function<Map<String, Object>, AddressCollection>(){

            @Override
            public AddressCollection apply(Map<String, Object> parameters) {
                return AddressService.this.all(parameters);
            }
        }, collection.getAddresses(), pageSize);
    }

    public Address createAndVerify(Map<String, Object> params) throws EasyPostException {
        HashMap<String, Object> wrappedParams = new HashMap<String, Object>();
        wrappedParams.put("address", params);
        String endpoint = "addresses/create_and_verify";
        AddressVerifyResponse response = Requestor.request(Requestor.RequestMethod.POST, endpoint, wrappedParams, AddressVerifyResponse.class, this.client);
        return response.getAddress();
    }

    public Address verify(String id) throws EasyPostException {
        String endpoint = "addresses/" + id + "/verify";
        AddressVerifyResponse response = Requestor.request(Requestor.RequestMethod.GET, endpoint, null, AddressVerifyResponse.class, this.client);
        return response.getAddress();
    }
}

