/*
 * Decompiled with CFR 0.152.
 */
package com.easypost.service;

import com.easypost.exception.EasyPostException;
import com.easypost.exception.General.EndOfPaginationError;
import com.easypost.exception.General.FilteringError;
import com.easypost.http.Requestor;
import com.easypost.model.Rate;
import com.easypost.model.Shipment;
import com.easypost.model.ShipmentCollection;
import com.easypost.model.SmartRate;
import com.easypost.model.SmartrateAccuracy;
import com.easypost.model.SmartrateCollection;
import com.easypost.service.EasyPostClient;
import com.easypost.utils.InternalUtilities;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;

public class ShipmentService {
    private final EasyPostClient client;

    ShipmentService(EasyPostClient client) {
        this.client = client;
    }

    public Shipment create(Map<String, Object> params) throws EasyPostException {
        return this.create(params, false);
    }

    public Shipment create(Map<String, Object> params, boolean withCarbonOffset) throws EasyPostException {
        HashMap<String, Object> wrappedParams = new HashMap<String, Object>();
        wrappedParams.put("shipment", params);
        wrappedParams.put("carbon_offset", withCarbonOffset);
        String endpoint = "shipments";
        return Requestor.request(Requestor.RequestMethod.POST, endpoint, wrappedParams, Shipment.class, this.client);
    }

    public Shipment retrieve(String id) throws EasyPostException {
        String endpoint = "shipments/" + id;
        return Requestor.request(Requestor.RequestMethod.GET, endpoint, null, Shipment.class, this.client);
    }

    public ShipmentCollection all(Map<String, Object> params) throws EasyPostException {
        String endpoint = "shipments";
        ShipmentCollection shipmentCollection = Requestor.request(Requestor.RequestMethod.GET, endpoint, params, ShipmentCollection.class, this.client);
        shipmentCollection.setPurchased(InternalUtilities.getOrDefault(params, "purchased", null));
        shipmentCollection.setIncludeChildren(InternalUtilities.getOrDefault(params, "include_children", null));
        return shipmentCollection;
    }

    public ShipmentCollection getNextPage(ShipmentCollection collection) throws EndOfPaginationError {
        return this.getNextPage(collection, null);
    }

    public ShipmentCollection getNextPage(ShipmentCollection collection, Integer pageSize) throws EndOfPaginationError {
        return collection.getNextPage(new Function<Map<String, Object>, ShipmentCollection>(){

            @Override
            public ShipmentCollection apply(Map<String, Object> parameters) {
                return ShipmentService.this.all(parameters);
            }
        }, collection.getShipments(), pageSize);
    }

    public Shipment newRates(String id) throws EasyPostException {
        return this.newRates(id, new HashMap<String, Object>());
    }

    public Shipment newRates(String id, boolean withCarbonOffset) throws EasyPostException {
        return this.newRates(id, (Map<String, Object>)new HashMap<String, Object>(){}, withCarbonOffset);
    }

    public Shipment newRates(String id, Map<String, Object> params) throws EasyPostException {
        return this.newRates(id, params, false);
    }

    public Shipment newRates(String id, Map<String, Object> params, boolean withCarbonOffset) throws EasyPostException {
        params.put("carbon_offset", withCarbonOffset);
        String endpoint = "shipments/" + id + "/rerate";
        return Requestor.request(Requestor.RequestMethod.POST, endpoint, params, Shipment.class, this.client);
    }

    @Deprecated
    public List<SmartRate> getSmartrates(String id, Map<String, Object> params) throws EasyPostException {
        return this.smartrates(id, params);
    }

    public List<SmartRate> smartrates(String id) throws EasyPostException {
        return this.smartrates(id, null);
    }

    public List<SmartRate> smartrates(String id, Map<String, Object> params) throws EasyPostException {
        String endpoint = "shipments/" + id + "/smartrate";
        SmartrateCollection smartrateCollection = Requestor.request(Requestor.RequestMethod.GET, endpoint, params, SmartrateCollection.class, this.client);
        return smartrateCollection.getSmartrates();
    }

    public Shipment buy(String id, Map<String, Object> params) throws EasyPostException {
        return this.buy(id, params, false);
    }

    public Shipment buy(String id, Rate rate) throws EasyPostException {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("rate", rate);
        return this.buy(id, params, false, null);
    }

    public Shipment buy(String id, Rate rate, boolean withCarbonOffset) throws EasyPostException {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("rate", rate);
        return this.buy(id, params, withCarbonOffset, null);
    }

    public Shipment buy(String id, Rate rate, String endShipperId) throws EasyPostException {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("rate", rate);
        return this.buy(id, params, false, endShipperId);
    }

    public Shipment buy(String id, Map<String, Object> params, String endShipperId) throws EasyPostException {
        return this.buy(id, params, false, endShipperId);
    }

    public Shipment buy(String id, Map<String, Object> params, boolean withCarbonOffset) throws EasyPostException {
        return this.buy(id, params, withCarbonOffset, null);
    }

    public Shipment buy(String id, Map<String, Object> params, boolean withCarbonOffset, String endShipperId) throws EasyPostException {
        params.put("carbon_offset", withCarbonOffset);
        if (endShipperId != null && !endShipperId.isEmpty()) {
            params.put("end_shipper_id", endShipperId);
        }
        String endpoint = "shipments/" + id + "/buy";
        return Requestor.request(Requestor.RequestMethod.POST, endpoint, params, Shipment.class, this.client);
    }

    public Shipment refund(String id) throws EasyPostException {
        return this.refund(id, null);
    }

    public Shipment refund(String id, Map<String, Object> params) throws EasyPostException {
        String endpoint = "shipments/" + id + "/refund";
        return Requestor.request(Requestor.RequestMethod.POST, endpoint, params, Shipment.class, this.client);
    }

    public Shipment label(String id, Map<String, Object> params) throws EasyPostException {
        String endpoint = "shipments/" + id + "/label";
        return Requestor.request(Requestor.RequestMethod.GET, endpoint, params, Shipment.class, this.client);
    }

    public Shipment insure(String id, Map<String, Object> params) throws EasyPostException {
        String endpoint = "shipments/" + id + "/insure";
        return Requestor.request(Requestor.RequestMethod.POST, endpoint, params, Shipment.class, this.client);
    }

    @Deprecated
    public SmartRate lowestSmartRate(String id, int deliveryDay, String deliveryAccuracy) throws EasyPostException {
        return this.lowestSmartRate(id, deliveryDay, SmartrateAccuracy.getByKeyName(deliveryAccuracy));
    }

    public SmartRate lowestSmartRate(String id, int deliveryDay, SmartrateAccuracy deliveryAccuracy) throws EasyPostException {
        List<SmartRate> smartrates = this.smartrates(id, null);
        SmartRate lowestSmartrate = this.findLowestSmartrate(smartrates, deliveryDay, deliveryAccuracy);
        return lowestSmartrate;
    }

    @Deprecated
    public List<SmartRate> getSmartrates(String id) throws EasyPostException {
        return this.getSmartrates(id, null);
    }

    @Deprecated
    public SmartRate getLowestSmartRate(List<SmartRate> smartRates, int deliveryDay, String deliveryAccuracy) throws EasyPostException {
        return this.findLowestSmartrate(smartRates, deliveryDay, SmartrateAccuracy.getByKeyName(deliveryAccuracy));
    }

    public SmartRate findLowestSmartrate(List<SmartRate> smartRates, int deliveryDay, SmartrateAccuracy deliveryAccuracy) throws EasyPostException {
        SmartRate lowestSmartrate = null;
        for (SmartRate rate : smartRates) {
            int smartrateDeliveryDay = rate.getTimeInTransit().getBySmartrateAccuracy(deliveryAccuracy);
            if (smartrateDeliveryDay > deliveryDay || lowestSmartrate != null && !(rate.getRate().floatValue() < lowestSmartrate.getRate().floatValue())) continue;
            lowestSmartrate = rate;
        }
        if (lowestSmartrate == null) {
            throw new FilteringError(String.format("No %s found.", "rate"));
        }
        return lowestSmartrate;
    }

    public Shipment generateForm(String id, String formType) throws EasyPostException {
        return this.generateForm(id, formType, new HashMap<String, Object>());
    }

    public Shipment generateForm(String id, String formType, Map<String, Object> formOptions) throws EasyPostException {
        HashMap<String, Object> params = new HashMap<String, Object>();
        HashMap<String, Object> wrappedParams = new HashMap<String, Object>();
        params.put("type", formType);
        params.putAll(formOptions);
        wrappedParams.put("form", params);
        String endpoint = "shipments/" + id + "/forms";
        return Requestor.request(Requestor.RequestMethod.POST, endpoint, wrappedParams, Shipment.class, this.client);
    }
}

