/*
 * Decompiled with CFR 0.152.
 */
package com.easypost.model;

import com.easypost.exception.General.EndOfPaginationError;
import com.easypost.model.EasyPostResource;
import java.util.List;
import java.util.Map;
import java.util.function.Function;

public abstract class PaginatedCollection<TEntries extends EasyPostResource>
extends EasyPostResource {
    private Boolean hasMore;

    public final <TCollection extends PaginatedCollection<TEntries>> TCollection getNextPage(Function<Map<String, Object>, TCollection> apiCallFunction, List<TEntries> currentEntries) throws EndOfPaginationError {
        return this.getNextPage(apiCallFunction, currentEntries, null);
    }

    public final <TCollection extends PaginatedCollection<TEntries>> TCollection getNextPage(Function<Map<String, Object>, TCollection> apiCallFunction, List<TEntries> currentEntries, Integer pageSize) throws EndOfPaginationError {
        if (currentEntries == null || currentEntries.size() == 0) {
            throw new EndOfPaginationError();
        }
        if (!this.hasMore.booleanValue()) {
            throw new EndOfPaginationError();
        }
        Map<String, Object> parameters = this.buildNextPageParameters(currentEntries, pageSize);
        return (TCollection)((PaginatedCollection)apiCallFunction.apply(parameters));
    }

    protected abstract Map<String, Object> buildNextPageParameters(List<TEntries> var1, Integer var2) throws EndOfPaginationError;

    public Boolean getHasMore() {
        return this.hasMore;
    }
}

