/*
 * Decompiled with CFR 0.152.
 */
package com.easypost.http;

import com.easypost.Constants;
import com.easypost.EasyPost;
import com.easypost.exception.API.BadRequestError;
import com.easypost.exception.API.EncodingError;
import com.easypost.exception.API.ForbiddenError;
import com.easypost.exception.API.GatewayTimeoutError;
import com.easypost.exception.API.HttpError;
import com.easypost.exception.API.InternalServerError;
import com.easypost.exception.API.InvalidRequestError;
import com.easypost.exception.API.JsonError;
import com.easypost.exception.API.MethodNotAllowedError;
import com.easypost.exception.API.NotFoundError;
import com.easypost.exception.API.PaymentError;
import com.easypost.exception.API.RateLimitError;
import com.easypost.exception.API.RedirectError;
import com.easypost.exception.API.ServiceUnavailableError;
import com.easypost.exception.API.TimeoutError;
import com.easypost.exception.API.UnauthorizedError;
import com.easypost.exception.API.UnknownApiError;
import com.easypost.exception.General.MissingParameterError;
import com.easypost.hooks.RequestHookResponses;
import com.easypost.hooks.ResponseHookResponses;
import com.easypost.http.EasyPostResponse;
import com.easypost.model.EasyPostResource;
import com.easypost.model.Error;
import com.easypost.service.EasyPostClient;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLEncoder;
import java.net.URLStreamHandler;
import java.nio.charset.Charset;
import java.security.Security;
import java.time.Instant;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Scanner;
import java.util.UUID;
import javax.net.ssl.HttpsURLConnection;
import lombok.Generated;

public abstract class Requestor {
    private static final String DNS_CACHE_TTL_PROPERTY_NAME = "networkaddress.cache.ttl";
    private static final String CUSTOM_URL_STREAM_HANDLER_PROPERTY_NAME = "com.easypost.net.customURLStreamHandler";

    private static String urlEncodePair(String key, String value) throws UnsupportedEncodingException {
        return String.format("%s=%s", URLEncoder.encode(key, "UTF-8"), URLEncoder.encode(value, "UTF-8"));
    }

    private static Map<String, String> generateHeaders(String apiKey) throws MissingParameterError {
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Accept-Charset", "UTF-8");
        headers.put("User-Agent", String.format("EasyPost/v2 JavaClient/%s Java/%s OS/%s OSVersion/%s OSArch/%s Implementation/%s", "6.8.1", System.getProperty("java.version"), Requestor.convertSpaceToHyphen(System.getProperty("os.name")), System.getProperty("os.version"), Requestor.convertSpaceToHyphen(System.getProperty("os.arch")), Requestor.convertSpaceToHyphen(System.getProperties().getProperty("java.vm.name"))));
        headers.put("Authorization", String.format("Bearer %s", apiKey));
        return headers;
    }

    private static String convertSpaceToHyphen(String string) {
        return string.replace(' ', '-');
    }

    private static HttpsURLConnection createEasyPostConnection(String url, EasyPostClient client, String method) throws IOException, MissingParameterError {
        HttpsURLConnection conn = null;
        String customURLStreamHandlerClassName = System.getProperty(CUSTOM_URL_STREAM_HANDLER_PROPERTY_NAME, null);
        if (customURLStreamHandlerClassName != null) {
            try {
                Class<?> clazz = Class.forName(customURLStreamHandlerClassName);
                Constructor<?> constructor = clazz.getConstructor(new Class[0]);
                URLStreamHandler customHandler = (URLStreamHandler)constructor.newInstance(new Object[0]);
                URL urlObj = new URL(null, url, customHandler);
                conn = (HttpsURLConnection)urlObj.openConnection();
            }
            catch (ClassNotFoundException | IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
                throw new IOException(e);
            }
        } else if (EasyPost._vcrUrlFunction != null) {
            conn = EasyPost._vcrUrlFunction.apply(url);
        } else {
            URL urlObj = new URL(null, url);
            conn = (HttpsURLConnection)urlObj.openConnection();
        }
        conn.setConnectTimeout(client.getConnectionTimeoutMilliseconds());
        conn.setRequestMethod(method);
        conn.setReadTimeout(client.getReadTimeoutMilliseconds());
        conn.setUseCaches(false);
        for (Map.Entry<String, String> header : Requestor.generateHeaders(client.getApiKey()).entrySet()) {
            conn.setRequestProperty(header.getKey(), header.getValue());
        }
        return conn;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static HttpsURLConnection writeBody(HttpsURLConnection conn, JsonObject body) throws IOException {
        if (body != null) {
            conn.setDoOutput(true);
            conn.setRequestProperty("Content-Type", "application/json");
            try (OutputStream output = null;){
                output = conn.getOutputStream();
                String jsonString = body.toString();
                output.write(jsonString.getBytes("UTF-8"));
            }
        }
        return conn;
    }

    private static HttpsURLConnection createGetConnection(String url, String query, EasyPostClient client) throws IOException, MissingParameterError {
        String getURL = url;
        if (query != null) {
            getURL = String.format("%s?%s", url, query);
        }
        return Requestor.createEasyPostConnection(getURL, client, "GET");
    }

    private static HttpsURLConnection createPostConnection(String url, JsonObject body, EasyPostClient client) throws IOException, MissingParameterError {
        HttpsURLConnection conn = Requestor.createEasyPostConnection(url, client, "POST");
        conn = Requestor.writeBody(conn, body);
        return conn;
    }

    private static HttpsURLConnection createDeleteConnection(String url, String query, EasyPostClient client) throws IOException, MissingParameterError {
        String deleteUrl = url;
        if (query != null) {
            deleteUrl = String.format("%s?%s", url, query);
        }
        return Requestor.createEasyPostConnection(deleteUrl, client, "DELETE");
    }

    private static HttpsURLConnection createPutConnection(String url, JsonObject body, EasyPostClient client) throws IOException, MissingParameterError {
        HttpsURLConnection conn = Requestor.createEasyPostConnection(url, client, "PUT");
        conn = Requestor.writeBody(conn, body);
        return conn;
    }

    private static JsonObject createBody(Map<String, Object> params) {
        JsonElement jsonElement = Constants.Http.GSON.toJsonTree(new HashMap<String, Object>(params));
        JsonObject jsonObject = jsonElement.getAsJsonObject();
        return jsonObject;
    }

    private static String createQuery(Map<String, Object> params) throws UnsupportedEncodingException {
        Map<String, String> flatParams = Requestor.flattenParams(params);
        StringBuilder queryStringBuilder = new StringBuilder();
        for (Map.Entry<String, String> entry : flatParams.entrySet()) {
            queryStringBuilder.append("&");
            queryStringBuilder.append(Requestor.urlEncodePair(entry.getKey(), entry.getValue()));
        }
        if (queryStringBuilder.length() > 0) {
            queryStringBuilder.deleteCharAt(0);
        }
        return queryStringBuilder.toString();
    }

    private static Map<String, String> flattenParams(Map<String, Object> params) {
        if (params == null) {
            return new HashMap<String, String>();
        }
        HashMap<String, String> flatParams = new HashMap<String, String>();
        for (Map.Entry<String, Object> entry : params.entrySet()) {
            HashMap<String, Object> flatNestedMap;
            String key = entry.getKey();
            Object value = entry.getValue();
            if (value instanceof Map) {
                flatNestedMap = new HashMap<String, Object>();
                Map nestedMap = (Map)value;
                for (Map.Entry nestedEntry : nestedMap.entrySet()) {
                    flatNestedMap.put(String.format("%s[%s]", key, nestedEntry.getKey()), nestedEntry.getValue());
                }
                flatParams.putAll(Requestor.flattenParams(flatNestedMap));
                continue;
            }
            if (value instanceof List) {
                flatNestedMap = new HashMap();
                List nestedList = (List)value;
                for (int i = 0; i < nestedList.size(); ++i) {
                    flatNestedMap.put(String.format("%s[%s]", key, i), nestedList.get(i));
                    flatParams.putAll(Requestor.flattenParams(flatNestedMap));
                }
                continue;
            }
            if (value instanceof EasyPostResource) {
                flatParams.put(String.format("%s[%s]", key, "id"), value.toString());
                continue;
            }
            if (value == null) continue;
            flatParams.put(key, value.toString());
        }
        return flatParams;
    }

    private static String getResponseBody(InputStream responseStream) throws IOException {
        if (responseStream.available() == 0) {
            return "";
        }
        String rBody = new Scanner(responseStream, "UTF-8").useDelimiter("\\A").next();
        responseStream.close();
        return rBody;
    }

    private static EasyPostResponse makeURLConnectionRequest(RequestMethod method, String url, String query, JsonObject body, EasyPostClient client) throws HttpError {
        HttpURLConnection conn = null;
        try {
            switch (method) {
                case GET: {
                    conn = Requestor.createGetConnection(url, query, client);
                    break;
                }
                case POST: {
                    conn = Requestor.createPostConnection(url, body, client);
                    break;
                }
                case PUT: {
                    conn = Requestor.createPutConnection(url, body, client);
                    break;
                }
                case DELETE: {
                    conn = Requestor.createDeleteConnection(url, query, client);
                    break;
                }
                default: {
                    throw new HttpError(String.format("Unrecognized HTTP method %s. Please contact EasyPost at %s.", new Object[]{method, "support@easypost.com"}));
                }
            }
            conn.connect();
            int rCode = conn.getResponseCode();
            String rBody = null;
            rBody = rCode == 204 ? "" : (rCode >= 200 && rCode < 300 ? Requestor.getResponseBody(conn.getInputStream()) : Requestor.getResponseBody(conn.getErrorStream()));
            EasyPostResponse easyPostResponse = new EasyPostResponse(rCode, rBody);
            return easyPostResponse;
        }
        catch (MissingParameterError e) {
            throw new HttpError(String.format("Could not build EasyPost API request. If this problem persists, please contact us at %s.", "support@easypost.com"));
        }
        catch (IOException e) {
            throw new HttpError(String.format("Could not connect to EasyPost (%s). Please check your internet connection and try again. If this problem persists,please contact us at %s.", client.getApiBase(), "support@easypost.com"), e);
        }
        finally {
            if (conn != null) {
                conn.disconnect();
            }
        }
    }

    public static <T> T request(RequestMethod method, String endpoint, Map<String, Object> params, Class<T> clazz, EasyPostClient client) throws GatewayTimeoutError, RateLimitError, BadRequestError, InvalidRequestError, NotFoundError, TimeoutError, EncodingError, UnauthorizedError, MethodNotAllowedError, InternalServerError, UnknownApiError, ServiceUnavailableError, ForbiddenError, JsonError, HttpError, RedirectError, PaymentError, MissingParameterError {
        String apiVersion = client.getApiVersion();
        return Requestor.request(method, endpoint, params, clazz, client, apiVersion);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> T request(RequestMethod method, String endpoint, Map<String, Object> params, Class<T> clazz, EasyPostClient client, String apiVersion) throws EncodingError, JsonError, RedirectError, UnauthorizedError, ForbiddenError, PaymentError, NotFoundError, MethodNotAllowedError, TimeoutError, BadRequestError, InvalidRequestError, RateLimitError, InternalServerError, ServiceUnavailableError, GatewayTimeoutError, UnknownApiError, HttpError, MissingParameterError {
        String originalDNSCacheTTL = null;
        boolean allowedToSetTTL = true;
        String url = client.getApiBase() + "/" + apiVersion + "/" + endpoint;
        try {
            originalDNSCacheTTL = Security.getProperty(DNS_CACHE_TTL_PROPERTY_NAME);
            Security.setProperty(DNS_CACHE_TTL_PROPERTY_NAME, "0");
        }
        catch (SecurityException se) {
            allowedToSetTTL = false;
        }
        try {
            T t = Requestor.httpRequest(method, url, params, clazz, client);
            return t;
        }
        finally {
            if (allowedToSetTTL) {
                if (originalDNSCacheTTL == null) {
                    Security.setProperty(DNS_CACHE_TTL_PROPERTY_NAME, "-1");
                } else {
                    Security.setProperty(DNS_CACHE_TTL_PROPERTY_NAME, originalDNSCacheTTL);
                }
            }
        }
    }

    private static <T> T httpRequest(RequestMethod method, String url, Map<String, Object> params, Class<T> clazz, EasyPostClient client) throws EncodingError, JsonError, RedirectError, UnauthorizedError, ForbiddenError, PaymentError, NotFoundError, MethodNotAllowedError, TimeoutError, BadRequestError, InvalidRequestError, RateLimitError, InternalServerError, ServiceUnavailableError, GatewayTimeoutError, UnknownApiError, HttpError, MissingParameterError {
        EasyPostResponse response;
        String query = null;
        JsonObject body = null;
        if (params != null) {
            switch (method) {
                case GET: 
                case DELETE: {
                    try {
                        query = Requestor.createQuery(params);
                        break;
                    }
                    catch (UnsupportedEncodingException e) {
                        throw new EncodingError(String.format("Unable to encode parameters to %s. Please email %s for assistance.", "UTF-8", "support@easypost.com"), e);
                    }
                }
                case POST: 
                case PUT: {
                    try {
                        body = Requestor.createBody(params);
                        break;
                    }
                    catch (Exception e) {
                        throw new JsonError(String.format("Unable to create JSON body from parameters. Please email %s for assistance.", "support@easypost.com"), e);
                    }
                }
            }
        }
        Instant requestTimestamp = Instant.now();
        UUID requestUuid = UUID.randomUUID();
        Map<String, String> headers = Requestor.generateHeaders(client.getApiKey());
        RequestHookResponses requestResponse = new RequestHookResponses(headers, method.toString(), url, body, requestTimestamp.toString(), requestUuid.toString());
        client.getRequestHooks().executeEventHandler(requestResponse);
        try {
            response = Requestor.makeURLConnectionRequest(method, url, query, body, client);
        }
        catch (ClassCastException ce) {
            String appEngineEnv = System.getProperty("com.google.appengine.runtime.environment", null);
            if (appEngineEnv != null) {
                response = Requestor.makeAppEngineRequest(method, url, query, body, client);
            }
            throw ce;
        }
        int rCode = response.getResponseCode();
        String rBody = response.getResponseBody();
        if (rCode < 200 || rCode >= 300) {
            Requestor.handleAPIError(rBody, rCode);
        }
        ResponseHookResponses responseHookResponses = new ResponseHookResponses(rCode, headers, method.toString(), url, rBody, Instant.now().toString(), requestTimestamp.toString(), requestUuid.toString());
        client.getResponseHooks().executeEventHandler(responseHookResponses);
        return (T)Constants.Http.GSON.fromJson(rBody, clazz);
    }

    protected static void handleAPIError(String rBody, int rCode) throws RedirectError, UnauthorizedError, ForbiddenError, PaymentError, NotFoundError, MethodNotAllowedError, TimeoutError, BadRequestError, InvalidRequestError, RateLimitError, InternalServerError, ServiceUnavailableError, GatewayTimeoutError, UnknownApiError {
        if (rBody == null || rBody.length() == 0) {
            rBody = "{}";
        }
        Error error = (Error)Constants.Http.GSON.fromJson(rBody, Error.class);
        String errorMessage = error.getMessage();
        String errorCode = error.getCode();
        List<Error> errors = error.getErrors();
        if (rCode >= 300 && rCode <= 308) {
            throw new RedirectError(errorMessage, errorCode, rCode, errors);
        }
        switch (rCode) {
            case 401: {
                throw new UnauthorizedError(errorMessage, errorCode, rCode, errors);
            }
            case 403: {
                throw new ForbiddenError(errorMessage, errorCode, rCode, errors);
            }
            case 402: {
                throw new PaymentError(errorMessage, errorCode, rCode, errors);
            }
            case 404: {
                throw new NotFoundError(errorMessage, errorCode, rCode, errors);
            }
            case 405: {
                throw new MethodNotAllowedError(errorMessage, errorCode, rCode, errors);
            }
            case 408: {
                throw new TimeoutError(errorMessage, errorCode, rCode, errors);
            }
            case 400: {
                throw new BadRequestError(errorMessage, errorCode, rCode, errors);
            }
            case 422: {
                throw new InvalidRequestError(errorMessage, errorCode, rCode, errors);
            }
            case 429: {
                throw new RateLimitError(errorMessage, errorCode, rCode, errors);
            }
            case 500: {
                throw new InternalServerError(errorMessage, errorCode, rCode, errors);
            }
            case 503: {
                throw new ServiceUnavailableError(errorMessage, errorCode, rCode, errors);
            }
            case 504: {
                throw new GatewayTimeoutError(errorMessage, errorCode, rCode, errors);
            }
        }
        throw new UnknownApiError(errorMessage, errorCode, rCode, errors);
    }

    @Generated
    private static EasyPostResponse makeAppEngineRequest(RequestMethod method, String url, String query, JsonObject body, EasyPostClient client) throws HttpError {
        String unknownErrorMessage = String.format("Sorry, an unknown error occurred while trying to use the Google App Engine runtime.Please email %s for assistance.", "support@easypost.com");
        try {
            if ((method == RequestMethod.GET || method == RequestMethod.DELETE) && query != null) {
                url = String.format("%s?%s", url, query);
            }
            URL fetchURL = new URL(url);
            Class<?> requestMethodClass = Class.forName("com.google.appengine.api.urlfetch.HTTPMethod");
            Object httpMethod = requestMethodClass.getDeclaredField(method.name()).get(null);
            Class<?> fetchOptionsBuilderClass = Class.forName("com.google.appengine.api.urlfetch.FetchOptions$Builder");
            Object fetchOptions = null;
            try {
                fetchOptions = fetchOptionsBuilderClass.getDeclaredMethod("validateCertificate", new Class[0]).invoke(null, new Object[0]);
            }
            catch (NoSuchMethodException e) {
                System.err.printf("Warning: this App Engine SDK version does not allow verification of SSL certificates;this exposes you to a MITM attack. Please upgrade your App Engine SDK to >=1.5.0. If you have questions, email %s.%n", "support@easypost.com");
                fetchOptions = fetchOptionsBuilderClass.getDeclaredMethod("withDefaults", new Class[0]).invoke(null, new Object[0]);
            }
            Class<?> fetchOptionsClass = Class.forName("com.google.appengine.api.urlfetch.FetchOptions");
            fetchOptionsClass.getDeclaredMethod("setDeadline", Double.class).invoke(fetchOptions, client.getConnectionTimeoutMilliseconds());
            Class<?> requestClass = Class.forName("com.google.appengine.api.urlfetch.HTTPRequest");
            Object request = requestClass.getDeclaredConstructor(URL.class, requestMethodClass, fetchOptionsClass).newInstance(fetchURL, httpMethod, fetchOptions);
            if ((method == RequestMethod.POST || method == RequestMethod.PUT) && body != null) {
                String bodyString = body.toString();
                requestClass.getDeclaredMethod("setPayload", byte[].class).invoke(request, new Object[]{bodyString.getBytes(Charset.defaultCharset())});
            }
            for (Map.Entry entry : Requestor.generateHeaders(client.getApiKey()).entrySet()) {
                Class<?> httpHeaderClass = Class.forName("com.google.appengine.api.urlfetch.HTTPHeader");
                Object reqHeader = httpHeaderClass.getDeclaredConstructor(String.class, String.class).newInstance(entry.getKey(), entry.getValue());
                requestClass.getDeclaredMethod("setHeader", httpHeaderClass).invoke(request, reqHeader);
            }
            Class<?> urlFetchFactoryClass = Class.forName("com.google.appengine.api.urlfetch.URLFetchServiceFactory");
            Object object = urlFetchFactoryClass.getDeclaredMethod("getURLFetchService", new Class[0]).invoke(null, new Object[0]);
            Method fetchMethod = object.getClass().getDeclaredMethod("fetch", requestClass);
            fetchMethod.setAccessible(true);
            Object response = fetchMethod.invoke(object, request);
            int responseCode = (Integer)response.getClass().getDeclaredMethod("getResponseCode", new Class[0]).invoke(response, new Object[0]);
            String responseBody = new String((byte[])response.getClass().getDeclaredMethod("getContent", new Class[0]).invoke(response, new Object[0]), "UTF-8");
            return new EasyPostResponse(responseCode, responseBody);
        }
        catch (MissingParameterError | UnsupportedEncodingException | ClassNotFoundException | IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchFieldException | NoSuchMethodException | SecurityException | InvocationTargetException | MalformedURLException e) {
            throw new HttpError(unknownErrorMessage, e);
        }
    }

    public static enum RequestMethod {
        GET,
        POST,
        DELETE,
        PUT;

    }
}

