/*
 * Decompiled with CFR 0.152.
 */
package com.easypost.service;

import com.easypost.exception.General.MissingParameterError;
import com.easypost.hooks.RequestHook;
import com.easypost.hooks.RequestHookResponses;
import com.easypost.hooks.ResponseHook;
import com.easypost.hooks.ResponseHookResponses;
import com.easypost.service.AddressService;
import com.easypost.service.ApiKeyService;
import com.easypost.service.BatchService;
import com.easypost.service.BetaCarrierMetadataService;
import com.easypost.service.BetaRateService;
import com.easypost.service.BetaReferralCustomerService;
import com.easypost.service.BillingService;
import com.easypost.service.CarrierAccountService;
import com.easypost.service.CarrierMetadataService;
import com.easypost.service.CarrierTypeService;
import com.easypost.service.CustomsInfoService;
import com.easypost.service.CustomsItemService;
import com.easypost.service.EndShipperService;
import com.easypost.service.EventService;
import com.easypost.service.InsuranceService;
import com.easypost.service.OrderService;
import com.easypost.service.ParcelService;
import com.easypost.service.PaymentMethodService;
import com.easypost.service.PickupService;
import com.easypost.service.RateService;
import com.easypost.service.ReferralCustomerService;
import com.easypost.service.RefundService;
import com.easypost.service.ReportService;
import com.easypost.service.ScanformService;
import com.easypost.service.ShipmentService;
import com.easypost.service.TrackerService;
import com.easypost.service.UserService;
import com.easypost.service.WebhookService;
import java.util.function.Function;

public class EasyPostClient {
    private final int connectTimeoutMilliseconds;
    private final int readTimeoutMilliseconds;
    private final String clientApiKey;
    private final String apiVersion = "v2";
    private final String apiBase;
    public final AddressService address;
    public final ApiKeyService apiKey;
    public final BatchService batch;
    public final BetaCarrierMetadataService betaCarrierMetadata;
    public final BetaReferralCustomerService betaReferralCustomer;
    public final BetaRateService betaRate;
    public final BillingService billing;
    public final CarrierAccountService carrierAccount;
    public final CarrierMetadataService carrierMetadata;
    public final CarrierTypeService carrierType;
    public final CustomsInfoService customsInfo;
    public final CustomsItemService customsItem;
    public final EndShipperService endShipper;
    public final EventService event;
    public final InsuranceService insurance;
    public final OrderService order;
    public final ParcelService parcel;
    public final PaymentMethodService paymentMethod;
    public final PickupService pickup;
    public final RateService rate;
    public final ReferralCustomerService referralCustomer;
    public final RefundService refund;
    public final ReportService report;
    public final ScanformService scanForm;
    public final ShipmentService shipment;
    public final TrackerService tracker;
    public final UserService user;
    public final WebhookService webhook;
    private RequestHook requestHooks = new RequestHook();
    private ResponseHook responseHooks = new ResponseHook();

    public EasyPostClient(String apiKey) throws MissingParameterError {
        this(apiKey, 30000);
    }

    public EasyPostClient(String apiKey, String apiBase) throws MissingParameterError {
        this(apiKey, 30000, 60000, apiBase);
    }

    public EasyPostClient(String apiKey, int connectTimeoutMilliseconds) throws MissingParameterError {
        this(apiKey, connectTimeoutMilliseconds, "https://api.easypost.com");
    }

    public EasyPostClient(String apiKey, int connectTimeoutMilliseconds, String apiBase) throws MissingParameterError {
        this(apiKey, connectTimeoutMilliseconds, 60000, apiBase);
    }

    public EasyPostClient(String apiKey, int connectTimeoutMilliseconds, int readTimeoutMilliseconds) throws MissingParameterError {
        this(apiKey, connectTimeoutMilliseconds, readTimeoutMilliseconds, "https://api.easypost.com");
    }

    public EasyPostClient(String apiKey, int connectTimeoutMilliseconds, int readTimeoutMilliseconds, String apiBase) throws MissingParameterError {
        if (apiKey == null || apiKey.isEmpty()) {
            throw new MissingParameterError("apiKey");
        }
        this.apiBase = apiBase;
        this.clientApiKey = apiKey;
        this.connectTimeoutMilliseconds = connectTimeoutMilliseconds;
        this.readTimeoutMilliseconds = readTimeoutMilliseconds;
        this.address = new AddressService(this);
        this.apiKey = new ApiKeyService(this);
        this.batch = new BatchService(this);
        this.betaCarrierMetadata = new BetaCarrierMetadataService(this);
        this.betaReferralCustomer = new BetaReferralCustomerService(this);
        this.betaRate = new BetaRateService(this);
        this.billing = new BillingService(this);
        this.carrierAccount = new CarrierAccountService(this);
        this.carrierMetadata = new CarrierMetadataService(this);
        this.carrierType = new CarrierTypeService(this);
        this.customsInfo = new CustomsInfoService(this);
        this.customsItem = new CustomsItemService(this);
        this.endShipper = new EndShipperService(this);
        this.event = new EventService(this);
        this.insurance = new InsuranceService(this);
        this.order = new OrderService(this);
        this.parcel = new ParcelService(this);
        this.paymentMethod = new PaymentMethodService(this);
        this.pickup = new PickupService(this);
        this.rate = new RateService(this);
        this.referralCustomer = new ReferralCustomerService(this);
        this.refund = new RefundService(this);
        this.report = new ReportService(this);
        this.scanForm = new ScanformService(this);
        this.shipment = new ShipmentService(this);
        this.tracker = new TrackerService(this);
        this.user = new UserService(this);
        this.webhook = new WebhookService(this);
    }

    public void subscribeToRequestHook(Function<RequestHookResponses, Object> function) {
        this.requestHooks.addEventHandler(function);
    }

    public void unsubscribeFromRequestHook(Function<RequestHookResponses, Object> function) {
        this.requestHooks.removeEventHandler(function);
    }

    public void subscribeToResponseHook(Function<ResponseHookResponses, Object> function) {
        this.responseHooks.addEventHandler(function);
    }

    public void unsubscribeFromResponseHook(Function<ResponseHookResponses, Object> function) {
        this.responseHooks.removeEventHandler(function);
    }

    public int getConnectionTimeoutMilliseconds() {
        return this.connectTimeoutMilliseconds;
    }

    public int getReadTimeoutMilliseconds() {
        return this.readTimeoutMilliseconds;
    }

    public String getApiKey() {
        return this.clientApiKey;
    }

    public String getApiVersion() {
        return "v2";
    }

    public String getApiBase() {
        return this.apiBase;
    }

    public RequestHook getRequestHooks() {
        return this.requestHooks;
    }

    public ResponseHook getResponseHooks() {
        return this.responseHooks;
    }
}

