/*
 * Decompiled with CFR 0.152.
 */
package com.easypost.service;

import com.easypost.exception.API.EncodingError;
import com.easypost.exception.EasyPostException;
import com.easypost.exception.General.EndOfPaginationError;
import com.easypost.exception.General.MissingParameterError;
import com.easypost.http.Requestor;
import com.easypost.model.Report;
import com.easypost.model.ReportCollection;
import com.easypost.service.EasyPostClient;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;

public class ReportService {
    private final EasyPostClient client;

    ReportService(EasyPostClient client) {
        this.client = client;
    }

    public Report create(Map<String, Object> params) throws EasyPostException {
        if (params.containsKey("type")) {
            String type = (String)params.get("type");
            HashMap<String, Object> paramsWithoutType = new HashMap<String, Object>(params);
            paramsWithoutType.remove("type");
            String endpoint = this.reportURL(type);
            return Requestor.request(Requestor.RequestMethod.POST, endpoint, paramsWithoutType, Report.class, this.client);
        }
        throw new MissingParameterError("type");
    }

    protected String reportURL(String type) throws EasyPostException {
        try {
            String urlType = URLEncoder.encode(type, "UTF-8").toLowerCase();
            return "reports/" + urlType;
        }
        catch (UnsupportedEncodingException e) {
            throw new EncodingError(String.format("Encode error for %s", "report type"), e);
        }
    }

    public Report retrieve(String id) throws EasyPostException {
        String endpoint = "reports/" + id;
        return Requestor.request(Requestor.RequestMethod.GET, endpoint, null, Report.class, this.client);
    }

    public ReportCollection all(Map<String, Object> params) throws EasyPostException {
        String type = (String)params.get("type");
        params.remove(type);
        String endpoint = this.reportURL(type);
        ReportCollection collection = Requestor.request(Requestor.RequestMethod.GET, endpoint, params, ReportCollection.class, this.client);
        collection.setType(type);
        return collection;
    }

    public ReportCollection getNextPage(ReportCollection collection) throws EndOfPaginationError {
        return this.getNextPage(collection, null);
    }

    public ReportCollection getNextPage(ReportCollection collection, Integer pageSize) throws EndOfPaginationError {
        return collection.getNextPage(new Function<Map<String, Object>, ReportCollection>(){

            @Override
            public ReportCollection apply(Map<String, Object> parameters) {
                return ReportService.this.all(parameters);
            }
        }, collection.getReports(), pageSize);
    }
}

