/*
 * Decompiled with CFR 0.152.
 */
package com.easypost.model;

import com.easypost.model.Error;
import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonPrimitive;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Map;

public final class ErrorDeserializer
implements JsonDeserializer<Error> {
    private void traverseJsonElement(JsonElement element, ArrayList<String> messagesList) {
        block3: {
            block4: {
                block2: {
                    if (!element.isJsonPrimitive()) break block2;
                    messagesList.add(element.getAsString());
                    break block3;
                }
                if (!element.isJsonArray()) break block4;
                JsonArray array = element.getAsJsonArray();
                for (JsonElement arrayElement : array) {
                    this.traverseJsonElement(arrayElement, messagesList);
                }
                break block3;
            }
            if (!element.isJsonObject()) break block3;
            JsonObject object = element.getAsJsonObject();
            for (Map.Entry entry : object.entrySet()) {
                this.traverseJsonElement((JsonElement)entry.getValue(), messagesList);
            }
        }
    }

    public Error deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
        JsonObject jo = json.getAsJsonObject();
        JsonElement results = jo.get("error");
        Gson gson = new Gson();
        if (results == null) {
            Error error = new Error();
            error.setMessage("API did not return error details.");
            error.setCode("NO RESPONSE CODE");
            return error;
        }
        try {
            ArrayList<String> messages = new ArrayList<String>();
            JsonElement errorMessageJson = results.getAsJsonObject().get("message");
            this.traverseJsonElement(errorMessageJson, messages);
            JsonPrimitive value = new JsonPrimitive(String.join((CharSequence)", ", messages));
            results.getAsJsonObject().add("message", (JsonElement)value);
        }
        catch (Exception e) {
            Error error = new Error();
            error.setMessage("Error deserializing JSON response");
            error.setCode("ERROR_DESERIALIZATION_ERROR");
            return error;
        }
        return (Error)gson.fromJson(results, Error.class);
    }
}

