/*
 * Decompiled with CFR 0.152.
 */
package com.easypost.service;

import com.easypost.exception.EasyPostException;
import com.easypost.exception.General.EndOfPaginationError;
import com.easypost.http.Requestor;
import com.easypost.model.ScanForm;
import com.easypost.model.ScanFormCollection;
import com.easypost.service.EasyPostClient;
import java.util.Map;
import java.util.function.Function;

public class ScanformService {
    private final EasyPostClient client;

    ScanformService(EasyPostClient client) {
        this.client = client;
    }

    public ScanForm create(Map<String, Object> params) throws EasyPostException {
        String endpoint = "scan_forms";
        return Requestor.request(Requestor.RequestMethod.POST, endpoint, params, ScanForm.class, this.client);
    }

    public ScanForm retrieve(String id) throws EasyPostException {
        String endpoint = "scan_forms/" + id;
        return Requestor.request(Requestor.RequestMethod.GET, endpoint, null, ScanForm.class, this.client);
    }

    public ScanFormCollection all(Map<String, Object> params) throws EasyPostException {
        String endpoint = "scan_forms";
        return Requestor.request(Requestor.RequestMethod.GET, endpoint, params, ScanFormCollection.class, this.client);
    }

    public ScanFormCollection getNextPage(ScanFormCollection collection) throws EndOfPaginationError {
        return this.getNextPage(collection, null);
    }

    public ScanFormCollection getNextPage(ScanFormCollection collection, Integer pageSize) throws EndOfPaginationError {
        return collection.getNextPage(new Function<Map<String, Object>, ScanFormCollection>(){

            @Override
            public ScanFormCollection apply(Map<String, Object> parameters) {
                return ScanformService.this.all(parameters);
            }
        }, collection.getScanForms(), pageSize);
    }
}

