/*
 * Decompiled with CFR 0.152.
 */
package com.easypost.service;

import com.easypost.exception.EasyPostException;
import com.easypost.exception.General.EndOfPaginationError;
import com.easypost.http.Requestor;
import com.easypost.model.Tracker;
import com.easypost.model.TrackerCollection;
import com.easypost.service.EasyPostClient;
import com.easypost.utils.InternalUtilities;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;

public class TrackerService {
    private final EasyPostClient client;

    TrackerService(EasyPostClient client) {
        this.client = client;
    }

    public Tracker create(Map<String, Object> params) throws EasyPostException {
        HashMap<String, Object> wrappedParams = new HashMap<String, Object>();
        wrappedParams.put("tracker", params);
        String endpoint = "trackers";
        return Requestor.request(Requestor.RequestMethod.POST, endpoint, wrappedParams, Tracker.class, this.client);
    }

    public Tracker retrieve(String id) throws EasyPostException {
        String endpoint = "trackers/" + id;
        return Requestor.request(Requestor.RequestMethod.GET, endpoint, null, Tracker.class, this.client);
    }

    public TrackerCollection all(Map<String, Object> params) throws EasyPostException {
        String endpoint = "trackers";
        TrackerCollection trackerCollection = Requestor.request(Requestor.RequestMethod.GET, endpoint, params, TrackerCollection.class, this.client);
        trackerCollection.setTrackingCode(InternalUtilities.getOrDefault(params, "tracking_code", null));
        trackerCollection.setCarrier(InternalUtilities.getOrDefault(params, "carrier", null));
        return trackerCollection;
    }

    public TrackerCollection getNextPage(TrackerCollection collection) throws EndOfPaginationError {
        return this.getNextPage(collection, null);
    }

    public TrackerCollection getNextPage(TrackerCollection collection, Integer pageSize) throws EndOfPaginationError {
        return collection.getNextPage(new Function<Map<String, Object>, TrackerCollection>(){

            @Override
            public TrackerCollection apply(Map<String, Object> parameters) {
                return TrackerService.this.all(parameters);
            }
        }, collection.getTrackers(), pageSize);
    }

    public void createList(Map<String, Object> params) throws EasyPostException {
        HashMap<String, Object> newParams = new HashMap<String, Object>();
        newParams.put("trackers", params);
        String endpoint = "trackers/create_list";
        Requestor.request(Requestor.RequestMethod.POST, endpoint, newParams, Object.class, this.client);
    }
}

