/*
 * Decompiled with CFR 0.152.
 */
package com.easypost.model;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import java.lang.reflect.Type;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.TimeZone;

public class DateDeserializer
implements JsonDeserializer<Date> {
    private static final String[] DATE_FORMATS = new String[]{"yyyy-MM-dd", "yyyy-MM-dd'T'HH:mm:ss", "yyyy-MM-dd'T'HH:mm:ss'Z'", "yyyy-MM-dd'T'HH:mm:ss.SSS", "yyyy-MM-dd'T'HH:mm:ss.SSS'Z'", "yyyy-MM-dd'T'HH:mm:ssZ", "yyyy-MM-dd'T'HH:mm:ssXXX", "yyyy-MM-dd HH:mm:ss", "yyyy-MM-dd HH:mm:ss.SSS", "yyyy-MM-dd", "MM/dd/yyyy", "MM-dd-yyyy", "yyyy-'W'ww", "yyyy-'W'ww-u", "EEE, d MMM yyyy HH:mm:ss Z", "EEE, d MMM yyyy HH:mm:ss z", "EEEE, MMMM d, yyyy h:mm:ss a", "M/d/yy", "M-d-yy", "M.d.yy", "MM/dd/yyyy", "MM-dd-yyyy"};

    public Date deserialize(JsonElement json, Type type, JsonDeserializationContext context) throws JsonParseException {
        int n = 0;
        String[] stringArray = DATE_FORMATS;
        int n2 = stringArray.length;
        if (n < n2) {
            String format = stringArray[n];
            try {
                SimpleDateFormat sdf = new SimpleDateFormat(format);
                sdf.setTimeZone(TimeZone.getTimeZone("UTC"));
                return sdf.parse(json.getAsString());
            }
            catch (ParseException e) {
                throw new JsonParseException("Unable to parse this date format");
            }
        }
        throw new JsonParseException("Unparseable date: \"" + json.getAsString() + "\"");
    }
}

