/*
 * Decompiled with CFR 0.152.
 */
package com.easypost.service;

import com.easypost.exception.EasyPostException;
import com.easypost.exception.General.EndOfPaginationError;
import com.easypost.http.Requestor;
import com.easypost.model.Claim;
import com.easypost.model.ClaimCollection;
import com.easypost.service.EasyPostClient;
import java.util.Map;
import java.util.function.Function;

public class ClaimService {
    private final EasyPostClient client;

    ClaimService(EasyPostClient client) {
        this.client = client;
    }

    public Claim create(Map<String, Object> params) throws EasyPostException {
        String endpoint = "claims";
        return Requestor.request(Requestor.RequestMethod.POST, endpoint, params, Claim.class, this.client);
    }

    public Claim retrieve(String id) throws EasyPostException {
        String endpoint = "claims/" + id;
        return Requestor.request(Requestor.RequestMethod.GET, endpoint, null, Claim.class, this.client);
    }

    public ClaimCollection all(Map<String, Object> params) throws EasyPostException {
        String type = (String)params.get("type");
        String status = (String)params.get("status");
        params.remove(type);
        params.remove(status);
        String endpoint = "claims";
        ClaimCollection claimCollection = Requestor.request(Requestor.RequestMethod.GET, endpoint, params, ClaimCollection.class, this.client);
        claimCollection.setType(type);
        claimCollection.setType(status);
        return claimCollection;
    }

    public Claim cancel(String id) throws EasyPostException {
        String endpoint = String.format("claims/%s/cancel", id);
        return Requestor.request(Requestor.RequestMethod.POST, endpoint, null, Claim.class, this.client);
    }

    public ClaimCollection getNextPage(ClaimCollection collection) throws EndOfPaginationError {
        return this.getNextPage(collection, null);
    }

    public ClaimCollection getNextPage(ClaimCollection collection, Integer pageSize) throws EndOfPaginationError {
        return collection.getNextPage(new Function<Map<String, Object>, ClaimCollection>(){

            @Override
            public ClaimCollection apply(Map<String, Object> parameters) {
                return ClaimService.this.all(parameters);
            }
        }, collection.getClaims(), pageSize);
    }
}

