/*
 * Decompiled with CFR 0.152.
 */
package com.easypost.service;

import com.easypost.exception.EasyPostException;
import com.easypost.http.Requestor;
import com.easypost.model.Batch;
import com.easypost.model.BatchCollection;
import com.easypost.model.Shipment;
import com.easypost.service.EasyPostClient;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class BatchService {
    private final EasyPostClient client;

    BatchService(EasyPostClient client) {
        this.client = client;
    }

    public Batch create() throws EasyPostException {
        return this.create(null);
    }

    public Batch create(Map<String, Object> params) throws EasyPostException {
        HashMap<String, Object> wrappedParams = new HashMap<String, Object>();
        wrappedParams.put("batch", params);
        String endpoint = "batches";
        return Requestor.request(Requestor.RequestMethod.POST, endpoint, wrappedParams, Batch.class, this.client);
    }

    public Batch retrieve(String id) throws EasyPostException {
        String endpoint = "batches/" + id;
        return Requestor.request(Requestor.RequestMethod.GET, endpoint, null, Batch.class, this.client);
    }

    public BatchCollection all(Map<String, Object> params) throws EasyPostException {
        String endpoint = "batches";
        return Requestor.request(Requestor.RequestMethod.GET, endpoint, params, BatchCollection.class, this.client);
    }

    public Batch label(String id, Map<String, Object> params) throws EasyPostException {
        String endpoint = "batches/" + id + "/label";
        return Requestor.request(Requestor.RequestMethod.POST, endpoint, params, Batch.class, this.client);
    }

    public Batch addShipments(String id, Map<String, Object> params) throws EasyPostException {
        String endpoint = "batches/" + id + "/add_shipments";
        return Requestor.request(Requestor.RequestMethod.POST, endpoint, params, Batch.class, this.client);
    }

    public Batch addShipments(String id, List<Shipment> shipments) throws EasyPostException {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("shipments", shipments);
        return this.addShipments(id, params);
    }

    public Batch removeShipments(String id, Map<String, Object> params) throws EasyPostException {
        String endpoint = "batches/" + id + "/remove_shipments";
        return Requestor.request(Requestor.RequestMethod.POST, endpoint, params, Batch.class, this.client);
    }

    public Batch removeShipments(String id, List<Shipment> shipments) throws EasyPostException {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("shipments", shipments);
        return this.removeShipments(id, params);
    }

    public Batch buy(String id) throws EasyPostException {
        return this.buy(id, null);
    }

    public Batch buy(String id, Map<String, Object> params) throws EasyPostException {
        String endpoint = "batches/" + id + "/buy";
        return Requestor.request(Requestor.RequestMethod.POST, endpoint, params, Batch.class, this.client);
    }

    public Batch createScanForm(String id) throws EasyPostException {
        return this.createScanForm(id, null);
    }

    public Batch createScanForm(String id, Map<String, Object> params) throws EasyPostException {
        String endpoint = "batches/" + id + "/scan_form";
        return Requestor.request(Requestor.RequestMethod.POST, endpoint, params, Batch.class, this.client);
    }
}

