/*
 * Decompiled with CFR 0.152.
 */
package com.easypost.model;

import com.easypost.exception.General.EndOfPaginationError;
import com.easypost.model.PaginatedCollection;
import com.easypost.model.Shipment;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ShipmentCollection
extends PaginatedCollection<Shipment> {
    private List<Shipment> shipments;
    private Boolean purchased;
    private Boolean includeChildren;

    @Override
    protected final Map<String, Object> buildNextPageParameters(List<Shipment> shipments, Integer pageSize) throws EndOfPaginationError {
        String lastId = shipments.get(shipments.size() - 1).getId();
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("before_id", lastId);
        if (pageSize != null) {
            parameters.put("page_size", pageSize);
        }
        if (this.purchased != null) {
            parameters.put("purchased", this.purchased);
        }
        if (this.includeChildren != null) {
            parameters.put("include_children", this.includeChildren);
        }
        return parameters;
    }

    public List<Shipment> getShipments() {
        return this.shipments;
    }

    public Boolean getPurchased() {
        return this.purchased;
    }

    public Boolean getIncludeChildren() {
        return this.includeChildren;
    }

    public void setPurchased(Boolean purchased) {
        this.purchased = purchased;
    }

    public void setIncludeChildren(Boolean includeChildren) {
        this.includeChildren = includeChildren;
    }
}

