/*
 * Decompiled with CFR 0.152.
 */
package com.easypost.model;

import com.easypost.exception.APIException;
import com.easypost.model.FieldError;
import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Map;

public final class ErrorDeserializer
implements JsonDeserializer<APIException> {
    private void traverseJsonElement(JsonElement element, ArrayList<String> messagesList) {
        block3: {
            block4: {
                block2: {
                    if (!element.isJsonPrimitive()) break block2;
                    messagesList.add(element.getAsString());
                    break block3;
                }
                if (!element.isJsonArray()) break block4;
                JsonArray array = element.getAsJsonArray();
                for (JsonElement arrayElement : array) {
                    this.traverseJsonElement(arrayElement, messagesList);
                }
                break block3;
            }
            if (!element.isJsonObject()) break block3;
            JsonObject object = element.getAsJsonObject();
            for (Map.Entry entry : object.entrySet()) {
                this.traverseJsonElement((JsonElement)entry.getValue(), messagesList);
            }
        }
    }

    public APIException deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
        JsonElement errorsAsJson;
        JsonElement messageElement;
        JsonObject jo = json.getAsJsonObject();
        String message = null;
        String code = null;
        ArrayList<Object> errors = new ArrayList<Object>();
        JsonElement errorResponse = jo.get("error");
        if (errorResponse == null) {
            message = "API did not return error details.";
            code = "NO RESPONSE CODE";
            return new APIException(message, code, null);
        }
        JsonObject errorData = errorResponse.getAsJsonObject();
        JsonElement codeElement = errorData.get("code");
        if (codeElement != null) {
            code = codeElement.getAsString();
        }
        if ((messageElement = errorData.get("message")) != null) {
            if (messageElement.isJsonPrimitive()) {
                message = messageElement.getAsString();
            } else if (messageElement.isJsonObject() || messageElement.isJsonArray()) {
                ArrayList<String> messagesList = new ArrayList<String>();
                this.traverseJsonElement(messageElement, messagesList);
                message = String.join((CharSequence)", ", messagesList);
            } else {
                throw new JsonParseException("Invalid message format");
            }
        }
        if ((errorsAsJson = errorData.get("errors")) != null) {
            JsonArray errorsAsArray = errorsAsJson.getAsJsonArray();
            for (JsonElement errorAsJson : errorsAsArray) {
                if (errorAsJson.isJsonObject()) {
                    JsonElement suggestion;
                    JsonElement fieldMessage;
                    JsonObject errorAsJsonObject = errorAsJson.getAsJsonObject();
                    FieldError fieldError = new FieldError();
                    JsonElement field = errorAsJsonObject.get("field");
                    if (field != null) {
                        fieldError.setField(field.getAsString());
                    }
                    if ((fieldMessage = errorAsJsonObject.get("message")) != null) {
                        fieldError.setMessage(fieldMessage.getAsString());
                    }
                    if ((suggestion = errorAsJsonObject.get("suggestion")) != null && !suggestion.isJsonNull()) {
                        fieldError.setSuggestion(suggestion.getAsString());
                    }
                    errors.add(fieldError);
                    continue;
                }
                errors.add(errorAsJson.getAsString());
            }
        }
        return new APIException(message, code, errors);
    }
}

