/*
 * Decompiled with CFR 0.152.
 */
package com.easypost.service;

import com.easypost.exception.EasyPostException;
import com.easypost.exception.General.FilteringError;
import com.easypost.http.Requestor;
import com.easypost.model.ApiKey;
import com.easypost.model.ApiKeys;
import com.easypost.service.EasyPostClient;
import java.util.List;
import java.util.Objects;

public class ApiKeyService {
    private final EasyPostClient client;

    ApiKeyService(EasyPostClient client) {
        this.client = client;
    }

    public ApiKeys all() throws EasyPostException {
        String endpoint = "api_keys";
        return Requestor.request(Requestor.RequestMethod.GET, endpoint, null, ApiKeys.class, this.client);
    }

    public List<ApiKey> retrieveApiKeysForUser(String id) throws EasyPostException {
        ApiKeys parentKeys = this.all();
        if (Objects.equals(id, parentKeys.getId())) {
            return parentKeys.getKeys();
        }
        for (int i = 0; i < parentKeys.getChildren().size(); ++i) {
            if (!id.equals(parentKeys.getChildren().get(i).getId())) continue;
            return parentKeys.getChildren().get(i).getKeys();
        }
        throw new FilteringError(String.format("No %s found.", "API keys"));
    }
}

