/*
 * Decompiled with CFR 0.152.
 */
package com.easypost.service;

import com.easypost.Constants;
import com.easypost.exception.EasyPostException;
import com.easypost.exception.General.MissingParameterError;
import com.easypost.http.Requestor;
import com.easypost.model.CarrierAccount;
import com.easypost.service.EasyPostClient;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class CarrierAccountService {
    private final EasyPostClient client;

    CarrierAccountService(EasyPostClient client) {
        this.client = client;
    }

    public CarrierAccount create(Map<String, Object> params) throws EasyPostException {
        String type = (String)params.get("type");
        HashMap<String, Object> wrappedParams = new HashMap<String, Object>();
        wrappedParams.put(CarrierAccountService.selectTopLayerKey(type), params);
        String endpoint = CarrierAccountService.selectCarrierAccountCreationEndpoint(type);
        return Requestor.request(Requestor.RequestMethod.POST, endpoint, wrappedParams, CarrierAccount.class, this.client);
    }

    public CarrierAccount retrieve(String id) throws EasyPostException {
        String endpoint = "carrier_accounts/" + id;
        return Requestor.request(Requestor.RequestMethod.GET, endpoint, null, CarrierAccount.class, this.client);
    }

    public List<CarrierAccount> all() throws EasyPostException {
        return this.all(null);
    }

    public List<CarrierAccount> all(Map<String, Object> params) throws EasyPostException {
        String endpoint = "carrier_accounts";
        CarrierAccount[] response = Requestor.request(Requestor.RequestMethod.GET, endpoint, params, CarrierAccount[].class, this.client);
        return Arrays.asList(response);
    }

    public CarrierAccount update(String id, Map<String, Object> params) throws EasyPostException {
        CarrierAccount carrierAccount = this.retrieve(id);
        String type = carrierAccount.getType();
        HashMap<String, Object> wrappedParams = new HashMap<String, Object>();
        wrappedParams.put(CarrierAccountService.selectTopLayerKey(type), params);
        String endpoint = (Constants.CarrierAccountTypes.UPS_OAUTH_CARRIER_ACCOUNT_TYPES.contains(type) ? "ups_oauth_registrations/" : "carrier_accounts/") + id;
        return Requestor.request(Requestor.RequestMethod.PUT, endpoint, wrappedParams, CarrierAccount.class, this.client);
    }

    public void delete(String id) throws EasyPostException {
        String endpoint = "carrier_accounts/" + id;
        Requestor.request(Requestor.RequestMethod.DELETE, endpoint, null, CarrierAccount.class, this.client);
    }

    private static String selectCarrierAccountCreationEndpoint(String carrierAccountType) {
        if (Constants.CarrierAccountTypes.CARRIER_ACCOUNT_TYPES_WITH_CUSTOM_WORKFLOW.contains(carrierAccountType)) {
            return "carrier_accounts/register";
        }
        if (Constants.CarrierAccountTypes.UPS_OAUTH_CARRIER_ACCOUNT_TYPES.contains(carrierAccountType)) {
            return "ups_oauth_registrations";
        }
        if (Constants.CarrierAccountTypes.CARRIER_ACCOUNT_TYPES_WITH_CUSTOM_OAUTH.contains(carrierAccountType)) {
            return "carrier_accounts/register_oauth";
        }
        return "carrier_accounts";
    }

    private static String selectTopLayerKey(String carrierAccountType) throws MissingParameterError {
        if (carrierAccountType == null) {
            throw new MissingParameterError(String.format("Missing required parameter: %s.", "carrier account type"));
        }
        if (Constants.CarrierAccountTypes.UPS_OAUTH_CARRIER_ACCOUNT_TYPES.contains(carrierAccountType)) {
            return "ups_oauth_registrations";
        }
        if (Constants.CarrierAccountTypes.CARRIER_ACCOUNT_TYPES_WITH_CUSTOM_OAUTH.contains(carrierAccountType)) {
            return "carrier_account_oauth_registrations";
        }
        return "carrier_account";
    }
}

