/*
 * Decompiled with CFR 0.152.
 */
package com.easypost.service;

import com.easypost.exception.EasyPostException;
import com.easypost.exception.General.EndOfPaginationError;
import com.easypost.http.Requestor;
import com.easypost.model.Insurance;
import com.easypost.model.InsuranceCollection;
import com.easypost.service.EasyPostClient;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;

public class InsuranceService {
    private final EasyPostClient client;

    InsuranceService(EasyPostClient client) {
        this.client = client;
    }

    public Insurance create(Map<String, Object> params) throws EasyPostException {
        HashMap<String, Object> wrappedParams = new HashMap<String, Object>();
        wrappedParams.put("insurance", params);
        String endpoint = "insurances";
        return Requestor.request(Requestor.RequestMethod.POST, endpoint, wrappedParams, Insurance.class, this.client);
    }

    public Insurance retrieve(String id) throws EasyPostException {
        String endpoint = "insurances/" + id;
        return Requestor.request(Requestor.RequestMethod.GET, endpoint, null, Insurance.class, this.client);
    }

    public InsuranceCollection all(Map<String, Object> params) throws EasyPostException {
        String endpoint = "insurances";
        return Requestor.request(Requestor.RequestMethod.GET, endpoint, params, InsuranceCollection.class, this.client);
    }

    public Insurance refund(String id) throws EasyPostException {
        String endpoint = String.format("insurances/%s/refund", id);
        return Requestor.request(Requestor.RequestMethod.POST, endpoint, null, Insurance.class, this.client);
    }

    public InsuranceCollection getNextPage(InsuranceCollection collection) throws EndOfPaginationError {
        return this.getNextPage(collection, null);
    }

    public InsuranceCollection getNextPage(InsuranceCollection collection, Integer pageSize) throws EndOfPaginationError {
        return collection.getNextPage(new Function<Map<String, Object>, InsuranceCollection>(){

            @Override
            public InsuranceCollection apply(Map<String, Object> parameters) {
                return InsuranceService.this.all(parameters);
            }
        }, collection.getInsurances(), pageSize);
    }
}

