/*
 * Decompiled with CFR 0.152.
 */
package com.easypost.service;

import com.easypost.exception.EasyPostException;
import com.easypost.exception.General.EndOfPaginationError;
import com.easypost.http.Requestor;
import com.easypost.model.Pickup;
import com.easypost.model.PickupCollection;
import com.easypost.model.PickupRate;
import com.easypost.service.EasyPostClient;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;

public class PickupService {
    private final EasyPostClient client;

    PickupService(EasyPostClient client) {
        this.client = client;
    }

    public PickupCollection all(Map<String, Object> params) throws EasyPostException {
        String endpoint = "pickups";
        return Requestor.request(Requestor.RequestMethod.GET, endpoint, params, PickupCollection.class, this.client);
    }

    public PickupCollection getNextPage(PickupCollection collection) throws EndOfPaginationError {
        return this.getNextPage(collection, null);
    }

    public PickupCollection getNextPage(PickupCollection collection, Integer pageSize) throws EndOfPaginationError {
        return collection.getNextPage(new Function<Map<String, Object>, PickupCollection>(){

            @Override
            public PickupCollection apply(Map<String, Object> parameters) {
                return PickupService.this.all(parameters);
            }
        }, collection.getPickups(), pageSize);
    }

    public Pickup create(Map<String, Object> params) throws EasyPostException {
        HashMap<String, Object> wrappedParams = new HashMap<String, Object>();
        wrappedParams.put("pickup", params);
        String endpoint = "pickups";
        return Requestor.request(Requestor.RequestMethod.POST, endpoint, wrappedParams, Pickup.class, this.client);
    }

    public Pickup retrieve(String id) throws EasyPostException {
        String endpoint = "pickups/" + id;
        return Requestor.request(Requestor.RequestMethod.GET, endpoint, null, Pickup.class, this.client);
    }

    public Pickup buy(String id, Map<String, Object> params) throws EasyPostException {
        String endpoint = "pickups/" + id + "/buy";
        return Requestor.request(Requestor.RequestMethod.POST, endpoint, params, Pickup.class, this.client);
    }

    public Pickup buy(String id, PickupRate pickupRate) throws EasyPostException {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("carrier", pickupRate.getCarrier());
        params.put("service", pickupRate.getService());
        return this.buy(id, params);
    }

    public Pickup cancel(String id) throws EasyPostException {
        return this.cancel(id, null);
    }

    public Pickup cancel(String id, Map<String, Object> params) throws EasyPostException {
        String endpoint = "pickups/" + id + "/cancel";
        return Requestor.request(Requestor.RequestMethod.POST, endpoint, params, Pickup.class, this.client);
    }
}

