/*
 * Decompiled with CFR 0.152.
 */
package com.easypost.service;

import com.easypost.Constants;
import com.easypost.EasyPost;
import com.easypost.exception.API.EncodingError;
import com.easypost.exception.API.ExternalApiError;
import com.easypost.exception.EasyPostException;
import com.easypost.exception.General.EndOfPaginationError;
import com.easypost.http.Requestor;
import com.easypost.model.PaymentMethod;
import com.easypost.model.PaymentMethodObject;
import com.easypost.model.ReferralCustomer;
import com.easypost.model.ReferralCustomerCollection;
import com.easypost.service.EasyPostClient;
import com.easypost.utils.InternalUtilities;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;

public class ReferralCustomerService {
    private final EasyPostClient client;

    ReferralCustomerService(EasyPostClient client) {
        this.client = client;
    }

    public ReferralCustomer create(Map<String, Object> params) throws EasyPostException {
        HashMap<String, Object> wrappedParams = new HashMap<String, Object>();
        wrappedParams.put("user", params);
        String endpoint = "referral_customers";
        return Requestor.request(Requestor.RequestMethod.POST, endpoint, wrappedParams, ReferralCustomer.class, this.client);
    }

    public void updateEmail(String email, String userId) throws EasyPostException {
        HashMap<String, Object> wrappedParams = new HashMap<String, Object>();
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("email", email);
        wrappedParams.put("user", params);
        String endpoint = "referral_customers/" + userId;
        Requestor.request(Requestor.RequestMethod.PUT, endpoint, wrappedParams, ReferralCustomer.class, this.client);
    }

    public ReferralCustomerCollection all(Map<String, Object> params) throws EasyPostException {
        String endpoint = "referral_customers";
        return Requestor.request(Requestor.RequestMethod.GET, endpoint, params, ReferralCustomerCollection.class, this.client);
    }

    public ReferralCustomerCollection getNextPage(ReferralCustomerCollection collection) throws EndOfPaginationError {
        return this.getNextPage(collection, null);
    }

    public ReferralCustomerCollection getNextPage(ReferralCustomerCollection collection, Integer pageSize) throws EndOfPaginationError {
        return collection.getNextPage(new Function<Map<String, Object>, ReferralCustomerCollection>(){

            @Override
            public ReferralCustomerCollection apply(Map<String, Object> parameters) {
                return ReferralCustomerService.this.all(parameters);
            }
        }, collection.getReferralCustomers(), pageSize);
    }

    public PaymentMethodObject addCreditCardToUser(String referralApiKey, String number, int expirationMonth, int expirationYear, String cvc) throws EasyPostException {
        return this.addCreditCardToUser(referralApiKey, number, expirationMonth, expirationYear, cvc, PaymentMethod.Priority.PRIMARY);
    }

    public PaymentMethodObject addCreditCardToUser(String referralApiKey, String number, int expirationMonth, int expirationYear, String cvc, PaymentMethod.Priority priority) throws EasyPostException {
        String stripeToken;
        String easypostStripeApiKey = this.retrieveEasypostStripeApiKey();
        try {
            stripeToken = ReferralCustomerService.createStripeToken(number, expirationMonth, expirationYear, cvc, easypostStripeApiKey);
        }
        catch (Exception e) {
            throw new ExternalApiError(String.format("Could not send card details to %s, please try again later", "Stripe"));
        }
        return this.createEasypostCreditCard(referralApiKey, stripeToken, priority.toString().toLowerCase());
    }

    public PaymentMethodObject addCreditCardFromStripe(String referralApiKey, String paymentMethodId, PaymentMethod.Priority priority) throws EasyPostException {
        HashMap<String, Object> params = new HashMap<String, Object>();
        HashMap<String, String> creditCardParams = new HashMap<String, String>();
        creditCardParams.put("payment_method_id", paymentMethodId);
        creditCardParams.put("priority", priority.toString().toLowerCase());
        params.put("credit_card", creditCardParams);
        EasyPostClient referralClient = new EasyPostClient(referralApiKey);
        String endpoint = "credit_cards";
        return Requestor.request(Requestor.RequestMethod.POST, endpoint, params, PaymentMethodObject.class, referralClient);
    }

    public PaymentMethodObject addBankAccountFromStripe(String referralApiKey, String financialConnectionsId, Map<String, Object> mandateData, PaymentMethod.Priority priority) throws EasyPostException {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("financial_connections_id", financialConnectionsId);
        params.put("mandate_data", mandateData);
        params.put("priority", priority.toString().toLowerCase());
        EasyPostClient referralClient = new EasyPostClient(referralApiKey);
        String endpoint = "bank_accounts";
        return Requestor.request(Requestor.RequestMethod.POST, endpoint, params, PaymentMethodObject.class, referralClient);
    }

    private String retrieveEasypostStripeApiKey() throws EasyPostException {
        String endpoint = "partners/stripe_public_key";
        Map response = Requestor.request(Requestor.RequestMethod.GET, endpoint, null, Map.class, this.client);
        return response.getOrDefault("public_key", "");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String createStripeToken(String number, int expirationMonth, int expirationYear, String cvc, String easypostStripeApiKey) throws EncodingError, IOException {
        StringBuilder response;
        String apiToken = String.format("%s %s", "Bearer", easypostStripeApiKey);
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("number", number);
        params.put("exp_month", String.valueOf(expirationMonth));
        params.put("exp_year", String.valueOf(expirationYear));
        params.put("cvc", cvc);
        String encodedURL = InternalUtilities.getEncodedURL(params, "card");
        URL stripeUrl = new URL("https://api.stripe.com/v1/tokens?" + encodedURL);
        HttpURLConnection conn = EasyPost._vcrUrlFunction != null ? (HttpURLConnection)EasyPost._vcrUrlFunction.apply(stripeUrl.toString()) : (HttpURLConnection)stripeUrl.openConnection();
        conn.setRequestMethod("POST");
        conn.setRequestProperty("Authorization", apiToken);
        conn.setRequestProperty("Content-Type", "application/x-www-form-urlencoded");
        conn.setDoOutput(true);
        try (BufferedReader br = new BufferedReader(new InputStreamReader(conn.getInputStream(), StandardCharsets.UTF_8));){
            String line;
            response = new StringBuilder();
            while ((line = br.readLine()) != null) {
                response.append(line);
                response.append(System.lineSeparator());
            }
            br.close();
        }
        finally {
            conn.disconnect();
        }
        String responseBody = response.toString();
        Map responseMap = (Map)Constants.Http.GSON.fromJson(responseBody, Map.class);
        return responseMap.get("id").toString();
    }

    private PaymentMethodObject createEasypostCreditCard(String referralApiKey, String stripeObjectId, String priority) throws EasyPostException {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("stripe_object_id", stripeObjectId);
        params.put("priority", priority);
        HashMap<String, Object> wrappedParams = new HashMap<String, Object>();
        wrappedParams.put("credit_card", params);
        EasyPostClient referralClient = new EasyPostClient(referralApiKey);
        String endpoint = "credit_cards";
        return Requestor.request(Requestor.RequestMethod.POST, endpoint, wrappedParams, PaymentMethodObject.class, referralClient);
    }
}

