/*
 * Decompiled with CFR 0.152.
 */
package com.easypost.service;

import com.easypost.exception.EasyPostException;
import com.easypost.exception.General.EndOfPaginationError;
import com.easypost.http.Requestor;
import com.easypost.model.Refund;
import com.easypost.model.RefundCollection;
import com.easypost.service.EasyPostClient;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;

public class RefundService {
    private final EasyPostClient client;

    RefundService(EasyPostClient client) {
        this.client = client;
    }

    public List<Refund> create(Map<String, Object> params) throws EasyPostException {
        HashMap<String, Object> wrappedParams = new HashMap<String, Object>();
        wrappedParams.put("refund", params);
        String endpoint = "refunds";
        Refund[] response = Requestor.request(Requestor.RequestMethod.POST, endpoint, wrappedParams, Refund[].class, this.client);
        return Arrays.asList(response);
    }

    public Refund retrieve(String id) throws EasyPostException {
        String endpoint = "refunds/" + id;
        return Requestor.request(Requestor.RequestMethod.GET, endpoint, null, Refund.class, this.client);
    }

    public RefundCollection all(Map<String, Object> params) throws EasyPostException {
        String endpoint = "refunds";
        return Requestor.request(Requestor.RequestMethod.GET, endpoint, params, RefundCollection.class, this.client);
    }

    public RefundCollection getNextPage(RefundCollection collection) throws EndOfPaginationError {
        return this.getNextPage(collection, null);
    }

    public RefundCollection getNextPage(RefundCollection collection, Integer pageSize) throws EndOfPaginationError {
        return collection.getNextPage(new Function<Map<String, Object>, RefundCollection>(){

            @Override
            public RefundCollection apply(Map<String, Object> parameters) {
                return RefundService.this.all(parameters);
            }
        }, collection.getRefunds(), pageSize);
    }
}

