/*
 * Decompiled with CFR 0.152.
 */
package com.easypost.model;

import com.easypost.model.AddressDetail;
import com.easypost.model.AddressVerification;
import com.easypost.model.AddressVerificationFieldError;
import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import java.lang.reflect.Type;
import java.util.ArrayList;

public final class AddressVerificationDeserializer
implements JsonDeserializer<AddressVerification> {
    public AddressVerification deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
        JsonObject jo = json.getAsJsonObject();
        AddressVerification addressVerification = new AddressVerification();
        boolean success = jo.get("success").getAsBoolean();
        addressVerification.setSuccess(success);
        AddressDetail details = (AddressDetail)context.deserialize(jo.get("details"), AddressDetail.class);
        addressVerification.setDetails(details);
        JsonElement errorsAsJson = jo.get("errors");
        if (errorsAsJson != null) {
            JsonArray errorsAsArray = errorsAsJson.getAsJsonArray();
            ArrayList<AddressVerificationFieldError> errors = new ArrayList<AddressVerificationFieldError>();
            for (JsonElement errorAsJson : errorsAsArray) {
                JsonElement suggestion;
                JsonElement field;
                JsonElement message;
                JsonObject errorAsJsonObject = errorAsJson.getAsJsonObject();
                AddressVerificationFieldError error = new AddressVerificationFieldError();
                JsonElement code = errorAsJsonObject.get("code");
                if (code != null) {
                    error.setCode(code.getAsString());
                }
                if ((message = errorAsJsonObject.get("message")) != null) {
                    error.setMessage(message.getAsString());
                }
                if ((field = errorAsJsonObject.get("field")) != null) {
                    error.setField(field.getAsString());
                }
                if ((suggestion = errorAsJsonObject.get("suggestion")) != null && !suggestion.isJsonNull()) {
                    error.setSuggestion(suggestion.getAsString());
                }
                errors.add(error);
            }
            addressVerification.setErrors(errors);
        }
        return addressVerification;
    }
}

