/*
 * Decompiled with CFR 0.152.
 */
package com.easypost.service;

import com.easypost.exception.EasyPostException;
import com.easypost.http.Requestor;
import com.easypost.model.BetaPaymentRefund;
import com.easypost.model.ClientSecret;
import com.easypost.model.PaymentMethod;
import com.easypost.model.PaymentMethodObject;
import com.easypost.service.EasyPostClient;
import java.util.HashMap;

public class BetaReferralCustomerService {
    private final EasyPostClient client;

    BetaReferralCustomerService(EasyPostClient client) {
        this.client = client;
    }

    public PaymentMethodObject addPaymentMethod(String stripeCustomerId, String paymentMethodReference) throws EasyPostException {
        return this.addPaymentMethod(stripeCustomerId, paymentMethodReference, PaymentMethod.Priority.PRIMARY);
    }

    public PaymentMethodObject addPaymentMethod(String stripeCustomerId, String paymentMethodReference, PaymentMethod.Priority primaryOrSecondary) throws EasyPostException {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("stripe_customer_id", stripeCustomerId);
        params.put("payment_method_reference", paymentMethodReference);
        params.put("priority", (Object)primaryOrSecondary);
        HashMap<String, Object> wrappedParams = new HashMap<String, Object>();
        wrappedParams.put("payment_method", params);
        String endpoint = "referral_customers/payment_method";
        return Requestor.request(Requestor.RequestMethod.POST, endpoint, wrappedParams, PaymentMethodObject.class, this.client, "beta");
    }

    public BetaPaymentRefund refundByAmount(int refundAmount) throws EasyPostException {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("refund_amount", refundAmount);
        String endpoint = "referral_customers/refunds";
        return Requestor.request(Requestor.RequestMethod.POST, endpoint, params, BetaPaymentRefund.class, this.client, "beta");
    }

    public BetaPaymentRefund refundByPaymentLog(String paymentLogId) throws EasyPostException {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("payment_log_id", paymentLogId);
        String endpoint = "referral_customers/refunds";
        return Requestor.request(Requestor.RequestMethod.POST, endpoint, params, BetaPaymentRefund.class, this.client, "beta");
    }

    public ClientSecret createCreditCardClientSecret() throws EasyPostException {
        String endpoint = "setup_intents";
        return Requestor.request(Requestor.RequestMethod.POST, endpoint, null, ClientSecret.class, this.client, "beta");
    }

    public ClientSecret createBankAccountClientSecret() throws EasyPostException {
        return this.createBankAccountClientSecret(null);
    }

    public ClientSecret createBankAccountClientSecret(String returnUrl) throws EasyPostException {
        HashMap<String, Object> params = new HashMap<String, Object>();
        if (returnUrl != null) {
            params.put("return_url", returnUrl);
        }
        String endpoint = "financial_connections_sessions";
        return Requestor.request(Requestor.RequestMethod.POST, endpoint, params, ClientSecret.class, this.client, "beta");
    }
}

