/*
 * Decompiled with CFR 0.152.
 */
package com.easypost.service;

import com.easypost.exception.EasyPostException;
import com.easypost.exception.General.EndOfPaginationError;
import com.easypost.http.Requestor;
import com.easypost.model.Brand;
import com.easypost.model.ChildUserCollection;
import com.easypost.model.User;
import com.easypost.service.EasyPostClient;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;

public class UserService {
    private final EasyPostClient client;

    UserService(EasyPostClient client) {
        this.client = client;
    }

    public User retrieve(String id) throws EasyPostException {
        String endpoint = "users/" + id;
        return Requestor.request(Requestor.RequestMethod.GET, endpoint, null, User.class, this.client);
    }

    public User retrieveMe() throws EasyPostException {
        String endpoint = "users";
        return Requestor.request(Requestor.RequestMethod.GET, endpoint, null, User.class, this.client);
    }

    public User create(Map<String, Object> params) throws EasyPostException {
        HashMap<String, Object> wrappedParams = new HashMap<String, Object>();
        wrappedParams.put("user", params);
        String endpoint = "users";
        return Requestor.request(Requestor.RequestMethod.POST, endpoint, wrappedParams, User.class, this.client);
    }

    public User update(String id, Map<String, Object> params) throws EasyPostException {
        HashMap<String, Object> wrappedParams = new HashMap<String, Object>();
        wrappedParams.put("user", params);
        String endpoint = "users/" + id;
        return Requestor.request(Requestor.RequestMethod.PUT, endpoint, wrappedParams, User.class, this.client);
    }

    public void delete(String id) throws EasyPostException {
        String endpoint = "users/" + id;
        Requestor.request(Requestor.RequestMethod.DELETE, endpoint, null, User.class, this.client);
    }

    public Brand updateBrand(String id, Map<String, Object> params) throws EasyPostException {
        HashMap<String, Object> wrappedParams = new HashMap<String, Object>();
        wrappedParams.put("brand", params);
        String endpoint = "users/" + id + "/brand";
        return Requestor.request(Requestor.RequestMethod.PUT, endpoint, wrappedParams, Brand.class, this.client);
    }

    public ChildUserCollection allChildren(Map<String, Object> params) throws EasyPostException {
        String endpoint = "users/children";
        return Requestor.request(Requestor.RequestMethod.GET, endpoint, params, ChildUserCollection.class, this.client);
    }

    public ChildUserCollection getNextPage(ChildUserCollection collection, Integer pageSize) throws EndOfPaginationError {
        return collection.getNextPage(new Function<Map<String, Object>, ChildUserCollection>(){

            @Override
            public ChildUserCollection apply(Map<String, Object> parameters) {
                return UserService.this.allChildren(parameters);
            }
        }, collection.getChildren(), pageSize);
    }
}

