/*
 * Decompiled with CFR 0.152.
 */
package com.easypost.utils;

import com.easypost.Constants;
import com.easypost.exception.EasyPostException;
import com.easypost.exception.General.FilteringError;
import com.easypost.exception.General.SignatureVerificationError;
import com.easypost.model.Event;
import com.easypost.model.Rate;
import com.easypost.model.SmartRate;
import com.easypost.model.SmartRateAccuracy;
import com.easypost.model.StatelessRate;
import com.easypost.utils.Cryptography;
import java.nio.charset.StandardCharsets;
import java.text.Normalizer;
import java.util.List;
import java.util.Map;

public abstract class Utilities {
    public static StatelessRate getLowestStatelessRate(List<StatelessRate> rates, List<String> carriers, List<String> services) throws FilteringError, NumberFormatException {
        StatelessRate lowestRate = null;
        if (carriers != null) {
            carriers.replaceAll(String::toLowerCase);
        }
        if (services != null) {
            services.replaceAll(String::toLowerCase);
        }
        for (StatelessRate rate : rates) {
            if (carriers != null && !carriers.contains(rate.getCarrier().toLowerCase()) || services != null && !services.contains(rate.getService().toLowerCase()) || lowestRate != null && !(Float.parseFloat(rate.getRate()) < Float.parseFloat(lowestRate.getRate()))) continue;
            lowestRate = rate;
        }
        if (lowestRate == null) {
            throw new FilteringError(String.format("No %s found.", "rates"));
        }
        return lowestRate;
    }

    public static Rate getLowestObjectRate(List<Rate> rates, List<String> carriers, List<String> services) throws FilteringError {
        Rate lowestRate = null;
        if (carriers != null) {
            carriers.replaceAll(String::toLowerCase);
        }
        if (services != null) {
            services.replaceAll(String::toLowerCase);
        }
        for (Rate rate : rates) {
            if (carriers != null && !carriers.contains(rate.getCarrier().toLowerCase()) || services != null && !services.contains(rate.getService().toLowerCase()) || lowestRate != null && !(rate.getRate().floatValue() < lowestRate.getRate().floatValue())) continue;
            lowestRate = rate;
        }
        if (lowestRate == null) {
            throw new FilteringError(String.format("No %s found.", "rates"));
        }
        return lowestRate;
    }

    public static Event validateWebhook(byte[] eventBody, Map<String, Object> headers, String webhookSecret) throws EasyPostException {
        String providedSignature = null;
        try {
            providedSignature = headers.get("X-Hmac-Signature").toString();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        if (providedSignature != null) {
            String calculatedDigest = Cryptography.toHMACSHA256HexDigest(eventBody, webhookSecret, Normalizer.Form.NFKD);
            String calculatedSignature = "hmac-sha256-hex=" + calculatedDigest;
            if (Cryptography.signaturesMatch(providedSignature, calculatedSignature)) {
                String json = new String(eventBody, StandardCharsets.UTF_8);
                return (Event)Constants.Http.GSON.fromJson(json, Event.class);
            }
            throw new SignatureVerificationError("Webhook received did not originate from EasyPost or had a webhook secret mismatch.");
        }
        throw new SignatureVerificationError("Webhook does not contain a valid HMAC signature.");
    }

    public static SmartRate findLowestSmartRate(List<SmartRate> smartRates, int deliveryDay, SmartRateAccuracy deliveryAccuracy) throws EasyPostException {
        SmartRate lowestSmartRate = null;
        for (SmartRate rate : smartRates) {
            int smartrateDeliveryDay = rate.getTimeInTransit().getSmartRateAccuracy(deliveryAccuracy);
            if (smartrateDeliveryDay > deliveryDay || lowestSmartRate != null && !(rate.getRate().floatValue() < lowestSmartRate.getRate().floatValue())) continue;
            lowestSmartRate = rate;
        }
        if (lowestSmartRate == null) {
            throw new FilteringError(String.format("No %s found.", "rate"));
        }
        return lowestSmartRate;
    }
}

