/*
 * Decompiled with CFR 0.152.
 */
package com.easypost.easyvcr;

import com.easypost.easyvcr.MatchRules;
import com.easypost.easyvcr.VCRException;
import com.easypost.easyvcr.internal.Files;
import com.easypost.easyvcr.internal.Utilities;
import com.easypost.easyvcr.internal.json.Serialization;
import com.easypost.easyvcr.requestelements.HttpInteraction;
import com.google.gson.JsonElement;
import com.google.gson.JsonParser;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public final class Cassette {
    public final String name;
    private final String filePath;
    private boolean locked;

    public Cassette(String folderPath, String cassetteName) {
        this.name = cassetteName;
        this.filePath = Utilities.getFilePath(folderPath, cassetteName + ".json");
    }

    public int numInteractions() {
        try {
            return this.read().size();
        }
        catch (VCRException ex) {
            return 0;
        }
    }

    private File getFile() {
        return Utilities.getFile(this.filePath);
    }

    public void erase() {
        this.getFile().delete();
    }

    public void lock() {
        this.locked = true;
    }

    public void unlock() {
        this.locked = false;
    }

    public List<HttpInteraction> read() throws VCRException {
        this.checkIfLocked();
        if (!this.fileExists()) {
            return new ArrayList<HttpInteraction>();
        }
        ArrayList<HttpInteraction> interactions = new ArrayList<HttpInteraction>();
        String jsonString = Files.readFile(this.filePath);
        if (jsonString == null) {
            return interactions;
        }
        JsonElement cassetteParseResult = JsonParser.parseString((String)jsonString);
        for (JsonElement interaction : cassetteParseResult.getAsJsonArray()) {
            interactions.add(Serialization.convertJsonToObject(interaction, HttpInteraction.class));
        }
        return interactions;
    }

    public void updateInteraction(HttpInteraction httpInteraction, MatchRules matchRules, boolean bypassSearch) throws VCRException {
        List<HttpInteraction> existingInteractions = this.read();
        int matchingIndex = -1;
        if (!bypassSearch) {
            for (int i = 0; i < existingInteractions.size(); ++i) {
                if (!matchRules.requestsMatch(existingInteractions.get(i).getRequest(), httpInteraction.getRequest())) continue;
                matchingIndex = i;
                break;
            }
        }
        if (matchingIndex < 0) {
            existingInteractions.add(httpInteraction);
        } else {
            existingInteractions.set(matchingIndex, httpInteraction);
        }
        try {
            this.write(existingInteractions);
        }
        catch (IOException ex) {
            throw new VCRException("Could not write to to cassette file");
        }
    }

    private void checkIfLocked() throws VCRException {
        if (this.locked) {
            throw new VCRException("Cassette is locked.");
        }
    }

    private boolean fileExists() {
        return this.getFile().exists();
    }

    private void write(List<HttpInteraction> httpInteractions) throws VCRException, IOException {
        this.checkIfLocked();
        String cassetteString = Serialization.convertObjectToJson(httpInteractions);
        Files.writeFile(this.filePath, cassetteString);
    }
}

