/*
 * Decompiled with CFR 0.152.
 */
package com.easypost.easyvcr;

import com.easypost.easyvcr.CensorElement;
import com.easypost.easyvcr.RegexCensorElement;
import com.easypost.easyvcr.Statics;
import com.easypost.easyvcr.internal.ApachePatch;
import com.easypost.easyvcr.internal.Utilities;
import com.easypost.easyvcr.internal.json.Serialization;
import com.google.gson.JsonParseException;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public final class Censors {
    private final List<CensorElement> bodyElementsToCensor;
    private final String censorText;
    private final List<CensorElement> headersToCensor;
    private final List<CensorElement> queryParamsToCensor = new ArrayList<CensorElement>();
    private final List<RegexCensorElement> pathElementsToCensor;

    public Censors() {
        this("*****");
    }

    public Censors(String censorString) {
        this.bodyElementsToCensor = new ArrayList<CensorElement>();
        this.headersToCensor = new ArrayList<CensorElement>();
        this.pathElementsToCensor = new ArrayList<RegexCensorElement>();
        this.censorText = censorString;
    }

    public static Censors regular() {
        return new Censors();
    }

    public static Censors strict() {
        Censors censors = new Censors();
        censors.censorHeadersByKeys(Statics.DEFAULT_CREDENTIAL_HEADERS_TO_HIDE);
        censors.censorBodyElementsByKeys(Statics.DEFAULT_CREDENTIAL_PARAMETERS_TO_HIDE);
        censors.censorQueryParametersByKeys(Statics.DEFAULT_CREDENTIAL_PARAMETERS_TO_HIDE);
        return censors;
    }

    private static List<Object> applyJsonCensors(List<Object> list, String censorText, List<CensorElement> elementsToCensor) {
        if (list == null || list.size() == 0) {
            return list;
        }
        ArrayList<Object> censoredList = new ArrayList<Object>();
        for (Map<String, Object> map : list) {
            Map<String, Object> value = map;
            if (Utilities.isDictionary(value)) {
                try {
                    value = Censors.applyJsonCensors(value, censorText, elementsToCensor);
                }
                catch (ClassCastException classCastException) {}
            } else if (Utilities.isList(value)) {
                try {
                    value = Censors.applyJsonCensors((List)((Object)value), censorText, elementsToCensor);
                }
                catch (ClassCastException classCastException) {
                    // empty catch block
                }
            }
            censoredList.add(value);
        }
        return censoredList;
    }

    private static Map<String, Object> applyJsonCensors(Map<String, Object> dictionary, String censorText, List<CensorElement> elementsToCensor) {
        if (dictionary == null || dictionary.size() == 0) {
            return dictionary;
        }
        HashMap<String, Object> censoredBodyDictionary = new HashMap<String, Object>();
        for (Map.Entry<String, Object> entry : dictionary.entrySet()) {
            String key = entry.getKey();
            Object value = entry.getValue();
            if (Censors.elementShouldBeCensored(key, elementsToCensor)) {
                if (value == null) continue;
                if (Utilities.isDictionary(value)) {
                    censoredBodyDictionary.put(key, new HashMap());
                    continue;
                }
                if (Utilities.isList(value)) {
                    censoredBodyDictionary.put(key, new ArrayList());
                    continue;
                }
                censoredBodyDictionary.put(key, censorText);
                continue;
            }
            if (Utilities.isDictionary(value)) {
                try {
                    value = Censors.applyJsonCensors((Map)value, censorText, elementsToCensor);
                }
                catch (ClassCastException classCastException) {}
            } else if (Utilities.isList(value)) {
                try {
                    value = Censors.applyJsonCensors((List)value, censorText, elementsToCensor);
                }
                catch (ClassCastException classCastException) {
                    // empty catch block
                }
            }
            censoredBodyDictionary.put(key, value);
        }
        return censoredBodyDictionary;
    }

    public static String censorJsonData(String data, String censorText, List<CensorElement> elementsToCensor) {
        try {
            Map bodyDictionary = Serialization.convertJsonToObject(data, Map.class);
            Map<String, Object> censoredBodyDictionary = Censors.applyJsonCensors(bodyDictionary, censorText, elementsToCensor);
            return censoredBodyDictionary == null ? data : Serialization.convertObjectToJson(censoredBodyDictionary);
        }
        catch (Exception ignored) {
            try {
                List bodyList = Serialization.convertJsonToObject(data, List.class);
                List<Object> censoredBodyList = Censors.applyJsonCensors(bodyList, censorText, elementsToCensor);
                return censoredBodyList == null ? data : Serialization.convertObjectToJson(censoredBodyList);
            }
            catch (Exception notJsonData) {
                throw new JsonParseException("Body is not a JSON dictionary or list");
            }
        }
    }

    private static boolean elementShouldBeCensored(String foundKey, List<CensorElement> elementsToCensor) {
        return elementsToCensor.stream().anyMatch(queryElement -> queryElement.matches(foundKey));
    }

    public static String applyBodyParameterCensors(String body, String censorText, List<CensorElement> bodyElementsToCensor) {
        if (body == null || body.length() == 0) {
            return body;
        }
        if (bodyElementsToCensor.size() == 0) {
            return body;
        }
        return Censors.censorJsonData(body, censorText, bodyElementsToCensor);
    }

    public static Map<String, List<String>> applyHeaderCensors(Map<String, List<String>> headers, String censorText, List<CensorElement> headersToCensor) {
        if (headers == null || headers.size() == 0) {
            return headers;
        }
        if (headersToCensor.size() == 0) {
            return headers;
        }
        HashMap<String, List<String>> headersCopy = new HashMap<String, List<String>>(headers);
        ArrayList headerKeys = new ArrayList(headersCopy.keySet());
        for (String headerKey : headerKeys) {
            if (headerKey == null || !Censors.elementShouldBeCensored(headerKey, headersToCensor)) continue;
            headersCopy.put(headerKey, Collections.singletonList(censorText));
        }
        return headersCopy;
    }

    public static String applyUrlCensors(String url, String censorText, List<CensorElement> queryParamsToCensor, List<RegexCensorElement> pathElementsToCensor) {
        String censoredQueryString;
        String censoredPath;
        if (url == null || url.length() == 0) {
            return url;
        }
        if (queryParamsToCensor.size() == 0 && pathElementsToCensor.size() == 0) {
            return url;
        }
        URI uri = URI.create(url);
        String path = Utilities.extractPathFromUri(uri);
        Map<String, String> queryParameters = Utilities.queryParametersToMap(uri);
        if (pathElementsToCensor.size() == 0) {
            censoredPath = path;
        } else {
            String tempPath = path;
            for (RegexCensorElement regexCensorElement : pathElementsToCensor) {
                tempPath = regexCensorElement.matchAndReplaceAsNeeded(tempPath, censorText);
            }
            censoredPath = tempPath;
        }
        if (queryParameters.size() == 0) {
            censoredQueryString = null;
        } else if (queryParamsToCensor.size() == 0) {
            censoredQueryString = uri.getQuery();
        } else {
            ArrayList<String> queryKeys = new ArrayList<String>(queryParameters.keySet());
            for (String queryKey : queryKeys) {
                if (!Censors.elementShouldBeCensored(queryKey, queryParamsToCensor)) continue;
                queryParameters.put(queryKey, censorText);
            }
            List<ApachePatch.NameValuePair> censoredQueryParametersList = Utilities.mapToQueryParameters(queryParameters);
            censoredQueryString = ApachePatch.URLEncodedUtils.format(censoredQueryParametersList, StandardCharsets.UTF_8);
        }
        String censoredUrl = censoredPath;
        if (censoredQueryString != null) {
            censoredUrl = censoredUrl + "?" + censoredQueryString;
        }
        return uri.getScheme() + "://" + censoredUrl;
    }

    public Censors censorBodyElements(List<CensorElement> elements) {
        this.bodyElementsToCensor.addAll(elements);
        return this;
    }

    public Censors censorBodyElementsByKeys(List<String> elementKeys, boolean caseSensitive) {
        for (String elementKey : elementKeys) {
            this.bodyElementsToCensor.add(new CensorElement(elementKey, caseSensitive));
        }
        return this;
    }

    public Censors censorBodyElementsByKeys(List<String> elementKeys) {
        return this.censorBodyElementsByKeys(elementKeys, false);
    }

    public Censors censorHeaders(List<CensorElement> headers) {
        this.headersToCensor.addAll(headers);
        return this;
    }

    public Censors censorHeadersByKeys(List<String> headerKeys, boolean caseSensitive) {
        for (String headerKey : headerKeys) {
            this.headersToCensor.add(new CensorElement(headerKey, caseSensitive));
        }
        return this;
    }

    public Censors censorHeadersByKeys(List<String> headerKeys) {
        return this.censorHeadersByKeys(headerKeys, false);
    }

    public Censors censorQueryParameters(List<CensorElement> elements) {
        this.queryParamsToCensor.addAll(elements);
        return this;
    }

    public Censors censorQueryParametersByKeys(List<String> parameterKeys, boolean caseSensitive) {
        for (String parameterKey : parameterKeys) {
            this.queryParamsToCensor.add(new CensorElement(parameterKey, caseSensitive));
        }
        return this;
    }

    public Censors censorQueryParametersByKeys(List<String> parameterKeys) {
        return this.censorQueryParametersByKeys(parameterKeys, false);
    }

    public Censors censorPathElements(List<RegexCensorElement> elements) {
        this.pathElementsToCensor.addAll(elements);
        return this;
    }

    public Censors censorPathElementsByPattern(List<String> patterns, boolean caseSensitive) {
        for (String pattern : patterns) {
            this.pathElementsToCensor.add(new RegexCensorElement(pattern, caseSensitive));
        }
        return this;
    }

    public Censors censorPathElementsByPattern(List<String> patterns) {
        return this.censorPathElementsByPattern(patterns, false);
    }

    public String applyBodyParameterCensors(String body) {
        return Censors.applyBodyParameterCensors(body, this.censorText, this.bodyElementsToCensor);
    }

    public Map<String, List<String>> applyHeaderCensors(Map<String, List<String>> headers) {
        return Censors.applyHeaderCensors(headers, this.censorText, this.headersToCensor);
    }

    public String applyUrlCensors(String url) {
        return Censors.applyUrlCensors(url, this.censorText, this.queryParamsToCensor, this.pathElementsToCensor);
    }
}

