/*
 * Decompiled with CFR 0.152.
 */
package com.easypost.easyvcr;

import com.easypost.easyvcr.AdvancedSettings;
import com.easypost.easyvcr.Cassette;
import com.easypost.easyvcr.HttpClientType;
import com.easypost.easyvcr.Mode;
import com.easypost.easyvcr.RecordingExpirationException;
import com.easypost.easyvcr.clients.httpurlconnection.RecordableHttpURLConnection;
import com.easypost.easyvcr.clients.httpurlconnection.RecordableHttpsURLConnection;
import com.easypost.easyvcr.clients.httpurlconnection.RecordableURL;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URISyntaxException;

public abstract class HttpClients {
    public static Object newClient(HttpClientType type, String url, Cassette cassette, Mode mode, AdvancedSettings advancedSettings) throws URISyntaxException, IOException, RecordingExpirationException {
        switch (type) {
            case HttpUrlConnection: {
                return HttpClients.newHttpURLConnection(url, cassette, mode, advancedSettings);
            }
            case HttpsUrlConnection: {
                return HttpClients.newHttpsURLConnection(url, cassette, mode, advancedSettings);
            }
        }
        throw new IllegalArgumentException("Unsupported HttpClientType: " + (Object)((Object)type));
    }

    public static Object newClient(HttpClientType type, String url, Cassette cassette, Mode mode) throws URISyntaxException, IOException, RecordingExpirationException {
        return HttpClients.newClient(type, url, cassette, mode, null);
    }

    private static RecordableURL newRecordableURL(String url, Cassette cassette, Mode mode, AdvancedSettings advancedSettings) throws MalformedURLException {
        return new RecordableURL(url, cassette, mode, advancedSettings);
    }

    public static RecordableHttpURLConnection newHttpURLConnection(String url, Cassette cassette, Mode mode, AdvancedSettings advancedSettings) throws IOException, RecordingExpirationException {
        return HttpClients.newRecordableURL(url, cassette, mode, advancedSettings).openConnection();
    }

    public static RecordableHttpURLConnection newHttpURLConnection(String url, Cassette cassette, Mode mode) throws IOException, RecordingExpirationException {
        return HttpClients.newRecordableURL(url, cassette, mode, null).openConnection();
    }

    public static RecordableHttpsURLConnection newHttpsURLConnection(String url, Cassette cassette, Mode mode, AdvancedSettings advancedSettings) throws IOException, RecordingExpirationException {
        return HttpClients.newRecordableURL(url, cassette, mode, advancedSettings).openConnectionSecure();
    }

    public static RecordableHttpsURLConnection newHttpsURLConnection(String url, Cassette cassette, Mode mode) throws IOException, RecordingExpirationException {
        return HttpClients.newRecordableURL(url, cassette, mode, null).openConnectionSecure();
    }
}

