/*
 * Decompiled with CFR 0.152.
 */
package com.easypost.easyvcr;

import com.easypost.easyvcr.CensorElement;
import com.easypost.easyvcr.internal.Utilities;
import com.easypost.easyvcr.requestelements.Request;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.function.BiFunction;

public final class MatchRules {
    private final List<BiFunction<Request, Request, Boolean>> rules = new ArrayList<BiFunction<Request, Request, Boolean>>();

    public static MatchRules regular() {
        return new MatchRules().byMethod().byFullUrl();
    }

    public static MatchRules strict() {
        return new MatchRules().byMethod().byFullUrl().byBody();
    }

    private void by(BiFunction<Request, Request, Boolean> rule) {
        this.rules.add(rule);
    }

    public MatchRules byBaseUrl() {
        this.by((received, recorded) -> {
            String receivedUri = received.getUri().getPath();
            String recordedUri = recorded.getUri().getPath();
            return receivedUri.equalsIgnoreCase(recordedUri);
        });
        return this;
    }

    public MatchRules byBody(List<CensorElement> ignoredElements) {
        this.by((received, recorded) -> {
            String receivedBody = received.getBody();
            String recordedBody = recorded.getBody();
            if (receivedBody == null && recordedBody == null) {
                return true;
            }
            if (receivedBody == null || recordedBody == null) {
                return false;
            }
            receivedBody = Utilities.removeJsonElements(receivedBody, ignoredElements);
            recordedBody = Utilities.removeJsonElements(recordedBody, ignoredElements);
            receivedBody = Utilities.toBase64String(receivedBody);
            recordedBody = Utilities.toBase64String(recordedBody);
            return receivedBody.equalsIgnoreCase(recordedBody);
        });
        return this;
    }

    public MatchRules byBody() {
        return this.byBody(null);
    }

    public MatchRules byEverything() {
        this.by((received, recorded) -> {
            String receivedRequest = received.toJson();
            String recordedRequest = recorded.toJson();
            return receivedRequest.equalsIgnoreCase(recordedRequest);
        });
        return this;
    }

    public MatchRules byFullUrl() {
        return this.byFullUrl(false);
    }

    public MatchRules byFullUrl(boolean exact) {
        if (exact) {
            this.by((received, recorded) -> {
                String receivedUri = Utilities.toBase64String(received.getUriString());
                String recordedUri = Utilities.toBase64String(recorded.getUriString());
                return receivedUri.equalsIgnoreCase(recordedUri);
            });
        } else {
            this.byBaseUrl();
            this.by((received, recorded) -> {
                Map<String, String> receivedQuery = Utilities.queryParametersToMap(received.getUri());
                Map<String, String> recordedQuery = Utilities.queryParametersToMap(recorded.getUri());
                if (receivedQuery.size() != recordedQuery.size()) {
                    return false;
                }
                for (Map.Entry<String, String> entry : receivedQuery.entrySet()) {
                    if (recordedQuery.containsKey(entry.getKey())) continue;
                    return false;
                }
                return true;
            });
        }
        return this;
    }

    public MatchRules byHeader(String name) {
        this.by((received, recorded) -> {
            Map<String, List<String>> receivedHeaders = received.getHeaders();
            Map<String, List<String>> recordedHeaders = recorded.getHeaders();
            if (!receivedHeaders.containsKey(name) || !recordedHeaders.containsKey(name)) {
                return false;
            }
            List<String> receivedHeader = receivedHeaders.get(name);
            List<String> recordedHeader = recordedHeaders.get(name);
            return receivedHeader.equals(recordedHeader);
        });
        return this;
    }

    public MatchRules byHeaders() {
        return this.byHeaders(false);
    }

    public MatchRules byHeaders(boolean exact) {
        if (exact) {
            this.by((received, recorded) -> received.getHeaders().size() == recorded.getHeaders().size());
        }
        this.by((received, recorded) -> {
            Map<String, List<String>> receivedHeaders = received.getHeaders();
            Map<String, List<String>> recordedHeaders = recorded.getHeaders();
            for (String headerName : receivedHeaders.keySet()) {
                if (!recordedHeaders.containsKey(headerName)) {
                    return false;
                }
                if (receivedHeaders.get(headerName).equals(recordedHeaders.get(headerName))) continue;
                return false;
            }
            return true;
        });
        return this;
    }

    public MatchRules byMethod() {
        this.by((received, recorded) -> received.getMethod().equalsIgnoreCase(recorded.getMethod()));
        return this;
    }

    public boolean requestsMatch(Request receivedRequest, Request recordedRequest) {
        if (this.rules.size() == 0) {
            return true;
        }
        for (BiFunction<Request, Request, Boolean> rule : this.rules) {
            if (rule.apply(receivedRequest, recordedRequest).booleanValue()) continue;
            return false;
        }
        return true;
    }
}

