/*
 * Decompiled with CFR 0.152.
 */
package com.easypost.easyvcr;

import java.time.Instant;
import java.time.temporal.ChronoUnit;

public class TimeFrame {
    private int days = 0;
    private int hours = 0;
    private int minutes = 0;
    private int seconds = 0;
    private CommonTimeFrames commonTimeFrame = null;

    public TimeFrame(int days, int hours, int minutes, int seconds) {
        this.days = days;
        this.hours = hours;
        this.minutes = minutes;
        this.seconds = seconds;
    }

    private TimeFrame(CommonTimeFrames commonTimeFrame) {
        this.commonTimeFrame = commonTimeFrame;
    }

    public boolean hasLapsed(Instant fromTime) {
        Instant startTimePlusFrame = this.timePlusFrame(fromTime);
        return startTimePlusFrame.isBefore(Instant.now());
    }

    public boolean hasLapsed(long fromTimeEpochTimestamp) {
        Instant fromTime = Instant.ofEpochSecond(fromTimeEpochTimestamp);
        return this.hasLapsed(fromTime);
    }

    private Instant timePlusFrame(Instant fromTime) {
        if (this.commonTimeFrame == null) {
            return fromTime.plus((long)this.days, ChronoUnit.DAYS).plus((long)this.hours, ChronoUnit.HOURS).plus((long)this.minutes, ChronoUnit.MINUTES).plus((long)this.seconds, ChronoUnit.SECONDS);
        }
        switch (this.commonTimeFrame) {
            case Forever: {
                return Instant.MAX;
            }
            case Never: {
                return Instant.MIN;
            }
        }
        return fromTime.plus((long)this.days, ChronoUnit.DAYS).plus((long)this.hours, ChronoUnit.HOURS).plus((long)this.minutes, ChronoUnit.MINUTES).plus((long)this.seconds, ChronoUnit.SECONDS);
    }

    public static TimeFrame forever() {
        return new TimeFrame(CommonTimeFrames.Forever);
    }

    public static TimeFrame never() {
        return new TimeFrame(CommonTimeFrames.Never);
    }

    public static TimeFrame months1() {
        return new TimeFrame(30, 0, 0, 0);
    }

    public static TimeFrame months2() {
        return new TimeFrame(61, 0, 0, 0);
    }

    public static TimeFrame months3() {
        return new TimeFrame(91, 0, 0, 0);
    }

    public static TimeFrame months6() {
        return new TimeFrame(182, 0, 0, 0);
    }

    public static TimeFrame months12() {
        return new TimeFrame(365, 0, 0, 0);
    }

    private static enum CommonTimeFrames {
        Forever,
        Never;

    }
}

