/*
 * Decompiled with CFR 0.152.
 */
package com.easypost.easyvcr;

import com.easypost.easyvcr.AdvancedSettings;
import com.easypost.easyvcr.Cassette;
import com.easypost.easyvcr.Mode;
import com.easypost.easyvcr.VCRException;
import com.easypost.easyvcr.clients.httpurlconnection.RecordableURL;
import java.net.MalformedURLException;
import java.net.URL;

public final class VCR {
    private Cassette currentCassette;
    private Mode mode;
    private AdvancedSettings advancedSettings;

    public VCR(AdvancedSettings advancedSettings) {
        this.advancedSettings = advancedSettings;
    }

    public VCR() {
        this.advancedSettings = new AdvancedSettings();
    }

    public String getCassetteName() {
        if (this.currentCassette == null) {
            return null;
        }
        return this.currentCassette.name;
    }

    public RecordableURL getHttpUrlConnection(URL url) throws MalformedURLException, VCRException {
        if (this.currentCassette == null) {
            throw new VCRException("No cassette is currently loaded.");
        }
        return new RecordableURL(url, this.currentCassette, this.mode, this.advancedSettings);
    }

    public RecordableURL getHttpUrlConnection(String url) throws MalformedURLException, VCRException {
        if (this.currentCassette == null) {
            throw new VCRException("No cassette is currently loaded.");
        }
        return new RecordableURL(url, this.currentCassette, this.mode, this.advancedSettings);
    }

    public Mode getMode() {
        if (this.mode == Mode.Bypass) {
            return Mode.Bypass;
        }
        Mode environmentMode = this.getModeFromEnvironment();
        return environmentMode != null ? environmentMode : this.mode;
    }

    private void setMode(Mode mode) {
        this.mode = mode;
    }

    public AdvancedSettings getAdvancedSettings() {
        return this.advancedSettings;
    }

    public void setAdvancedSettings(AdvancedSettings advancedSettings) {
        this.advancedSettings = advancedSettings;
    }

    public void eject() {
        this.currentCassette = null;
    }

    public void erase() {
        if (this.currentCassette != null) {
            this.currentCassette.erase();
        }
    }

    public void insert(Cassette cassette) {
        this.currentCassette = cassette;
    }

    public void pause() {
        this.setMode(Mode.Bypass);
    }

    public void record() {
        this.setMode(Mode.Record);
    }

    public void replay() {
        this.setMode(Mode.Replay);
    }

    public void recordIfNeeded() {
        this.setMode(Mode.Auto);
    }

    private Mode getModeFromEnvironment() {
        String keyName = "EASYVCR_MODE";
        try {
            String keyValue = System.getenv("EASYVCR_MODE");
            if (keyValue == null) {
                return null;
            }
            return Mode.valueOf(keyValue);
        }
        catch (Exception ignored) {
            return null;
        }
    }
}

