/*
 * Decompiled with CFR 0.152.
 */
package com.easypost.easyvcr.clients.httpurlconnection;

import com.easypost.easyvcr.AdvancedSettings;
import com.easypost.easyvcr.Cassette;
import com.easypost.easyvcr.Mode;
import com.easypost.easyvcr.RecordingExpirationException;
import com.easypost.easyvcr.VCRException;
import com.easypost.easyvcr.clients.httpurlconnection.RecordableRequestBody;
import com.easypost.easyvcr.interactionconverters.HttpUrlConnectionInteractionConverter;
import com.easypost.easyvcr.internal.ConsoleFallbackLogger;
import com.easypost.easyvcr.internal.ExpirationActionExtensions;
import com.easypost.easyvcr.internal.Utilities;
import com.easypost.easyvcr.requestelements.HttpInteraction;
import com.easypost.easyvcr.requestelements.Request;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.ProtocolException;
import java.net.Proxy;
import java.net.URL;
import java.security.Permission;
import java.security.Principal;
import java.security.cert.Certificate;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLPeerUnverifiedException;
import javax.net.ssl.SSLSocketFactory;

public final class RecordableHttpsURLConnection
extends HttpsURLConnection {
    private HttpsURLConnection connection;
    private final RecordableRequestBody requestBody;
    private final HttpUrlConnectionInteractionConverter converter;
    private final Cassette cassette;
    private final Mode mode;
    private final AdvancedSettings advancedSettings;
    private HttpInteraction cachedInteraction;
    private final ConsoleFallbackLogger logger;

    public RecordableHttpsURLConnection(URL url, Proxy proxy, Cassette cassette, Mode mode, AdvancedSettings advancedSettings) throws IOException, RecordingExpirationException {
        super(url);
        this.connection = proxy == null ? (HttpsURLConnection)url.openConnection() : (HttpsURLConnection)url.openConnection(proxy);
        this.requestBody = new RecordableRequestBody();
        this.cachedInteraction = null;
        this.cassette = cassette;
        this.mode = mode;
        this.advancedSettings = advancedSettings;
        this.converter = new HttpUrlConnectionInteractionConverter();
        this.logger = new ConsoleFallbackLogger(advancedSettings.logger, "EasyVCR");
        ExpirationActionExtensions.checkCompatibleSettings(advancedSettings.whenExpired, mode);
    }

    public RecordableHttpsURLConnection(URL url, Cassette cassette, Mode mode, AdvancedSettings advancedSettings) throws IOException, RecordingExpirationException {
        this(url, null, cassette, mode, advancedSettings);
    }

    public RecordableHttpsURLConnection(URL url, Proxy proxy, Cassette cassette, Mode mode) throws IOException, RecordingExpirationException {
        this(url, proxy, cassette, mode, new AdvancedSettings());
    }

    public RecordableHttpsURLConnection(URL url, Cassette cassette, Mode mode) throws IOException, RecordingExpirationException {
        this(url, cassette, mode, new AdvancedSettings());
    }

    private Object getObjectElementFromCache(Function<HttpInteraction, Object> getter, Object defaultValue) throws VCRException {
        if (this.cachedInteraction == null) {
            return defaultValue;
        }
        try {
            return getter.apply(this.cachedInteraction);
        }
        catch (Exception e) {
            throw new VCRException("Error getting string element from cache");
        }
    }

    private String getStringElementFromCache(Function<HttpInteraction, String> getter, String defaultValue) throws VCRException {
        if (this.cachedInteraction == null) {
            return defaultValue;
        }
        try {
            return getter.apply(this.cachedInteraction);
        }
        catch (Exception e) {
            throw new VCRException("Error getting string element from cache");
        }
    }

    private int getIntegerElementFromCache(Function<HttpInteraction, Integer> getter, int defaultValue) throws VCRException {
        if (this.cachedInteraction == null) {
            return defaultValue;
        }
        try {
            return getter.apply(this.cachedInteraction);
        }
        catch (Exception e) {
            throw new VCRException("Error getting integer element from cache");
        }
    }

    private void cacheInteraction(boolean recordToCassette) throws VCRException {
        this.cachedInteraction = this.converter.createInteraction(this.connection, this.requestBody, this.advancedSettings.censors);
        if (recordToCassette) {
            this.cassette.updateInteraction(this.cachedInteraction, this.advancedSettings.matchRules, false);
        }
    }

    private boolean loadExistingInteraction() throws VCRException, RecordingExpirationException, InterruptedException {
        Request request = this.converter.createRecordedRequest(this.connection, this.requestBody, this.advancedSettings.censors);
        if (request == null) {
            return false;
        }
        HttpInteraction matchingInteraction = this.converter.findMatchingInteraction(this.cassette, request, this.advancedSettings.matchRules);
        if (matchingInteraction == null) {
            return false;
        }
        if (this.advancedSettings.timeFrame.hasLapsed(matchingInteraction.getRecordedAt())) {
            block0 : switch (this.mode) {
                case Replay: {
                    switch (this.advancedSettings.whenExpired) {
                        case Warn: {
                            this.logger.warning("Matching interaction is expired.");
                            break block0;
                        }
                        case ThrowException: {
                            throw new RecordingExpirationException("Matching interaction is expired.");
                        }
                        case RecordAgain: {
                            throw new RecordingExpirationException("Cannot use the Record_Again expiration action in combination with Replay mode.");
                        }
                    }
                    break;
                }
                case Auto: {
                    switch (this.advancedSettings.whenExpired) {
                        case Warn: {
                            this.logger.warning("Matching interaction is expired.");
                            break block0;
                        }
                        case ThrowException: {
                            throw new RecordingExpirationException("Matching interaction is expired.");
                        }
                        case RecordAgain: {
                            return false;
                        }
                    }
                    break;
                }
            }
        }
        Utilities.simulateDelay(matchingInteraction, this.advancedSettings);
        this.cachedInteraction = matchingInteraction;
        this.cachedInteraction.getResponse().addReplayHeaders();
        return true;
    }

    private void buildCache() throws VCRException, RecordingExpirationException {
        if (this.cachedInteraction != null) {
            return;
        }
        switch (this.mode) {
            case Record: {
                this.cacheInteraction(true);
                break;
            }
            case Replay: {
                try {
                    this.loadExistingInteraction();
                    break;
                }
                catch (VCRException | InterruptedException e) {
                    throw new RuntimeException(e);
                }
            }
            case Auto: {
                try {
                    if (this.loadExistingInteraction()) break;
                    this.cacheInteraction(true);
                    break;
                }
                catch (VCRException | InterruptedException e) {
                    throw new RuntimeException(e);
                }
            }
        }
    }

    private void clearCache() {
        this.cachedInteraction = null;
    }

    @Override
    public void connect() throws IOException {
        try {
            if (this.requestBody.hasData()) {
                this.setRequestProperty("Content-Type", "application/json");
                this.connection.setDoOutput(true);
                try (OutputStream output = null;){
                    output = this.connection.getOutputStream();
                    byte[] jsonData = this.requestBody.getData();
                    output.write(jsonData);
                }
            }
            this.buildCache();
            this.connection.disconnect();
        }
        catch (RecordingExpirationException | VCRException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void disconnect() {
        this.connection.disconnect();
        this.clearCache();
    }

    @Override
    public boolean usingProxy() {
        return this.connection.usingProxy();
    }

    @Override
    public String getHeaderFieldKey(int n) {
        if (this.mode == Mode.Bypass) {
            return this.connection.getHeaderFieldKey(n);
        }
        try {
            this.buildCache();
            return this.getStringElementFromCache(interaction -> interaction.getResponse().getHeaders().keySet().toArray()[n].toString(), null);
        }
        catch (RecordingExpirationException | VCRException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void setFixedLengthStreamingMode(int contentLength) {
        if (this.cachedInteraction != null) {
            throw new IllegalStateException("Cannot set anything after interaction has been cached");
        }
        this.connection.setFixedLengthStreamingMode(contentLength);
    }

    @Override
    public void setFixedLengthStreamingMode(long contentLength) {
        if (this.cachedInteraction != null) {
            throw new IllegalStateException("Cannot set anything after interaction has been cached");
        }
        this.connection.setFixedLengthStreamingMode(contentLength);
    }

    @Override
    public void setChunkedStreamingMode(int chunklen) {
        if (this.cachedInteraction != null) {
            throw new IllegalStateException("Cannot set anything after interaction has been cached");
        }
        this.connection.setChunkedStreamingMode(chunklen);
    }

    @Override
    public String getHeaderField(int n) {
        if (this.mode == Mode.Bypass) {
            return this.connection.getHeaderField(n);
        }
        try {
            this.buildCache();
            return this.getStringElementFromCache(interaction -> interaction.getResponse().getHeaders().values().toArray()[n].toString(), null);
        }
        catch (RecordingExpirationException | VCRException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public boolean getInstanceFollowRedirects() {
        return this.connection.getInstanceFollowRedirects();
    }

    @Override
    public void setInstanceFollowRedirects(boolean followRedirects) {
        if (this.cachedInteraction != null) {
            throw new IllegalStateException("Cannot set anything after interaction has been cached");
        }
        this.connection.setInstanceFollowRedirects(followRedirects);
    }

    @Override
    public String getRequestMethod() {
        if (this.mode == Mode.Bypass) {
            return this.connection.getRequestMethod();
        }
        try {
            this.buildCache();
            return this.getStringElementFromCache(interaction -> interaction.getRequest().getMethod(), null);
        }
        catch (RecordingExpirationException | VCRException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void setRequestMethod(String method) throws ProtocolException {
        if (this.cachedInteraction != null) {
            throw new IllegalStateException("Cannot set anything after interaction has been cached");
        }
        this.connection.setRequestMethod(method);
    }

    @Override
    public int getResponseCode() throws IOException {
        if (this.mode == Mode.Bypass) {
            return this.connection.getResponseCode();
        }
        try {
            this.buildCache();
            return this.getIntegerElementFromCache(interaction -> interaction.getResponse().getStatus().getCode(), 0);
        }
        catch (RecordingExpirationException | VCRException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public String getResponseMessage() throws IOException {
        if (this.mode == Mode.Bypass) {
            return this.connection.getResponseMessage();
        }
        try {
            this.buildCache();
            return this.getStringElementFromCache(interaction -> interaction.getResponse().getStatus().getMessage(), null);
        }
        catch (RecordingExpirationException | VCRException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public Permission getPermission() throws IOException {
        return this.connection.getPermission();
    }

    @Override
    public InputStream getErrorStream() {
        if (this.mode == Mode.Bypass) {
            return this.connection.getErrorStream();
        }
        try {
            this.buildCache();
            if (this.cachedInteraction.getResponse().getStatus().getCode() >= 400) {
                return Utilities.createInputStream(this.cachedInteraction.getResponse().getBody());
            }
            return null;
        }
        catch (RecordingExpirationException | VCRException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public int getConnectTimeout() {
        return this.connection.getConnectTimeout();
    }

    @Override
    public void setConnectTimeout(int timeout) {
        if (this.cachedInteraction != null) {
            throw new IllegalStateException("Cannot set anything after interaction has been cached");
        }
        this.connection.setConnectTimeout(timeout);
    }

    @Override
    public int getReadTimeout() {
        return this.connection.getReadTimeout();
    }

    @Override
    public void setReadTimeout(int timeout) {
        if (this.cachedInteraction != null) {
            throw new IllegalStateException("Cannot set anything after interaction has been cached");
        }
        this.connection.setReadTimeout(timeout);
    }

    @Override
    public URL getURL() {
        if (this.mode == Mode.Bypass) {
            return this.connection.getURL();
        }
        try {
            this.buildCache();
            String urlString = this.getStringElementFromCache(interaction -> interaction.getResponse().getUriString(), null);
            if (urlString == null) {
                throw new IllegalStateException("Could not load URL from cache");
            }
            return new URL(urlString);
        }
        catch (RecordingExpirationException | VCRException | MalformedURLException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public String getContentType() {
        return this.getHeaderField("content-type");
    }

    @Override
    public String getContentEncoding() {
        return this.getHeaderField("content-encoding");
    }

    @Override
    public long getExpiration() {
        return this.connection.getExpiration();
    }

    @Override
    public String getHeaderField(String name) {
        if (this.mode == Mode.Bypass) {
            return this.connection.getHeaderField(name);
        }
        try {
            this.buildCache();
            return this.getStringElementFromCache(interaction -> interaction.getResponse().getHeaders().get(name).get(0), null);
        }
        catch (RecordingExpirationException | VCRException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public Map<String, List<String>> getHeaderFields() {
        if (this.mode == Mode.Bypass) {
            return this.connection.getHeaderFields();
        }
        try {
            this.buildCache();
            if (this.cachedInteraction == null) {
                return Collections.emptyMap();
            }
            return this.cachedInteraction.getResponse().getHeaders();
        }
        catch (RecordingExpirationException | VCRException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public Object getContent() throws IOException {
        if (this.mode == Mode.Bypass) {
            return this.connection.getContent();
        }
        try {
            this.buildCache();
            return this.getObjectElementFromCache(interaction -> interaction.getResponse().getBody(), null);
        }
        catch (RecordingExpirationException | VCRException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public String toString() {
        return this.connection.toString();
    }

    @Override
    public boolean getDoInput() {
        return this.connection.getDoInput();
    }

    @Override
    public void setDoInput(boolean doinput) {
        if (this.cachedInteraction != null) {
            throw new IllegalStateException("Cannot set anything after interaction has been cached");
        }
        this.connection.setDoInput(doinput);
    }

    @Override
    public boolean getDoOutput() {
        return this.connection.getDoOutput();
    }

    @Override
    public void setDoOutput(boolean dooutput) {
        if (this.cachedInteraction != null) {
            throw new IllegalStateException("Cannot set anything after interaction has been cached");
        }
        if (this.connection.getDoOutput() != dooutput) {
            this.connection.setDoOutput(dooutput);
        }
    }

    @Override
    public boolean getAllowUserInteraction() {
        return this.connection.getAllowUserInteraction();
    }

    @Override
    public void setAllowUserInteraction(boolean allowuserinteraction) {
        if (this.cachedInteraction != null) {
            throw new IllegalStateException("Cannot set anything after interaction has been cached");
        }
        this.connection.setAllowUserInteraction(allowuserinteraction);
    }

    @Override
    public boolean getUseCaches() {
        return this.connection.getUseCaches();
    }

    @Override
    public void setUseCaches(boolean usecaches) {
        if (this.cachedInteraction != null) {
            throw new IllegalStateException("Cannot set anything after interaction has been cached");
        }
        this.connection.setUseCaches(usecaches);
    }

    @Override
    public long getIfModifiedSince() {
        return this.connection.getIfModifiedSince();
    }

    @Override
    public void setIfModifiedSince(long ifmodifiedsince) {
        if (this.cachedInteraction != null) {
            throw new IllegalStateException("Cannot set anything after interaction has been cached");
        }
        this.connection.setIfModifiedSince(ifmodifiedsince);
    }

    @Override
    public boolean getDefaultUseCaches() {
        return this.connection.getDefaultUseCaches();
    }

    @Override
    public void setDefaultUseCaches(boolean defaultusecaches) {
        if (this.cachedInteraction != null) {
            throw new IllegalStateException("Cannot set anything after interaction has been cached");
        }
        this.connection.setDefaultUseCaches(defaultusecaches);
    }

    @Override
    public void setRequestProperty(String key, String value) {
        if (this.cachedInteraction != null) {
            throw new IllegalStateException("Cannot set anything after interaction has been cached");
        }
        this.connection.setRequestProperty(key, value);
    }

    @Override
    public void addRequestProperty(String key, String value) {
        this.connection.addRequestProperty(key, value);
    }

    @Override
    public String getRequestProperty(String key) {
        if (this.mode == Mode.Bypass) {
            return this.connection.getRequestProperty(key);
        }
        try {
            this.buildCache();
            return this.getStringElementFromCache(interaction -> interaction.getRequest().getHeaders().get(key).toString(), null);
        }
        catch (RecordingExpirationException | VCRException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public Map<String, List<String>> getRequestProperties() {
        return this.connection.getRequestProperties();
    }

    @Override
    public InputStream getInputStream() throws IOException {
        if (this.mode == Mode.Bypass) {
            return this.connection.getInputStream();
        }
        try {
            this.buildCache();
            return Utilities.createInputStream(this.cachedInteraction.getResponse().getBody());
        }
        catch (RecordingExpirationException | VCRException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public long getHeaderFieldDate(String name, long Default) {
        return this.connection.getHeaderFieldDate(name, Default);
    }

    @Override
    public int getContentLength() {
        return this.connection.getContentLength();
    }

    @Override
    public long getContentLengthLong() {
        return this.connection.getContentLengthLong();
    }

    @Override
    public long getDate() {
        return this.connection.getDate();
    }

    @Override
    public long getLastModified() {
        return this.connection.getLastModified();
    }

    @Override
    public int getHeaderFieldInt(String name, int Default) {
        return this.connection.getHeaderFieldInt(name, Default);
    }

    @Override
    public long getHeaderFieldLong(String name, long Default) {
        return this.connection.getHeaderFieldLong(name, Default);
    }

    public Object getContent(Class[] classes) throws IOException {
        return this.connection.getContent(classes);
    }

    @Override
    public OutputStream getOutputStream() throws IOException {
        if (!this.getDoOutput()) {
            throw new IOException("Cannot get output stream when doOutput is false");
        }
        return this.requestBody;
    }

    @Override
    public String getCipherSuite() {
        return this.connection.getCipherSuite();
    }

    @Override
    public Certificate[] getLocalCertificates() {
        return this.connection.getLocalCertificates();
    }

    @Override
    public Certificate[] getServerCertificates() throws SSLPeerUnverifiedException {
        return this.connection.getServerCertificates();
    }

    @Override
    public Principal getPeerPrincipal() throws SSLPeerUnverifiedException {
        return this.connection.getPeerPrincipal();
    }

    @Override
    public Principal getLocalPrincipal() {
        return this.connection.getLocalPrincipal();
    }

    @Override
    public HostnameVerifier getHostnameVerifier() {
        return this.connection.getHostnameVerifier();
    }

    @Override
    public void setHostnameVerifier(HostnameVerifier v) {
        if (this.cachedInteraction != null) {
            throw new IllegalStateException("Cannot set anything after interaction has been cached");
        }
        this.connection.setHostnameVerifier(v);
    }

    @Override
    public SSLSocketFactory getSSLSocketFactory() {
        return this.connection.getSSLSocketFactory();
    }

    @Override
    public void setSSLSocketFactory(SSLSocketFactory sf) {
        if (this.cachedInteraction != null) {
            throw new IllegalStateException("Cannot set anything after interaction has been cached");
        }
        this.connection.setSSLSocketFactory(sf);
    }
}

