/*
 * Decompiled with CFR 0.152.
 */
package com.easypost.easyvcr.interactionconverters;

import com.easypost.easyvcr.Censors;
import com.easypost.easyvcr.clients.httpurlconnection.RecordableRequestBody;
import com.easypost.easyvcr.interactionconverters.BaseInteractionConverter;
import com.easypost.easyvcr.internal.Utilities;
import com.easypost.easyvcr.requestelements.HttpInteraction;
import com.easypost.easyvcr.requestelements.Request;
import com.easypost.easyvcr.requestelements.Response;
import com.easypost.easyvcr.requestelements.Status;
import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.charset.StandardCharsets;
import java.time.Duration;
import java.time.Instant;
import java.util.List;
import java.util.Map;

public final class HttpUrlConnectionInteractionConverter
extends BaseInteractionConverter {
    public Request createRecordedRequest(HttpURLConnection connection, RecordableRequestBody requestBody, Censors censors) {
        try {
            String uriString = connection.getURL().toString();
            connection.disconnect();
            Map<String, List<String>> headers = connection.getRequestProperties();
            String body = new String(requestBody.getData(), StandardCharsets.UTF_8);
            String method = connection.getRequestMethod();
            uriString = censors.applyUrlCensors(uriString);
            headers = censors.applyHeaderCensors(headers);
            body = censors.applyBodyParameterCensors(body);
            Request request = new Request();
            request.setMethod(method);
            request.setUri(new URI(uriString));
            request.setHeaders(headers);
            request.setBody(body);
            return request;
        }
        catch (Exception ignored) {
            return null;
        }
    }

    public BaseInteractionConverter.ResponseAndTime createRecordedResponse(HttpURLConnection connection, Censors censors) {
        try {
            Instant start = Instant.now();
            int responseCode = connection.getResponseCode();
            Instant end = Instant.now();
            long milliseconds = Duration.between(start, end).toMillis();
            String message = connection.getResponseMessage();
            String uriString = connection.getURL().toString();
            Map<String, List<String>> headers = connection.getHeaderFields();
            String body = null;
            try {
                body = Utilities.readFromInputStream(connection.getInputStream());
            }
            catch (IOException | NullPointerException ignored) {
                body = Utilities.readFromInputStream(connection.getErrorStream());
            }
            uriString = censors.applyUrlCensors(uriString);
            headers = censors.applyHeaderCensors(headers);
            Response response = new Response();
            response.setStatus(new Status(responseCode, message));
            response.setUri(new URI(uriString));
            response.setHeaders(headers);
            if (body != null) {
                body = censors.applyBodyParameterCensors(body);
                response.setBody(body);
            }
            return new BaseInteractionConverter.ResponseAndTime(response, milliseconds);
        }
        catch (IOException | URISyntaxException ignored) {
            return null;
        }
    }

    public HttpInteraction createInteraction(HttpURLConnection connection, RecordableRequestBody requestBody, Censors censors) {
        Request request = this.createRecordedRequest(connection, requestBody, censors);
        BaseInteractionConverter.ResponseAndTime responseAndTime = this.createRecordedResponse(connection, censors);
        connection.disconnect();
        return this.createInteraction(request, responseAndTime.response, responseAndTime.time);
    }
}

