/*
 * Decompiled with CFR 0.152.
 */
package com.easypost.easyvcr.internal;

import java.net.URI;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public abstract class ApachePatch {

    public static class URLEncodedUtils {
        private static final BitSet URLENCODER = new BitSet(256);

        public static List<NameValuePair> parse(@NotNull URI uri, Charset charset) {
            String query = uri.getRawQuery();
            return query != null && !query.isEmpty() ? URLEncodedUtils.parse(query, charset) : URLEncodedUtils.createEmptyList();
        }

        public static List<NameValuePair> parse(String s, Charset charset) {
            if (s == null) {
                return URLEncodedUtils.createEmptyList();
            }
            return URLEncodedUtils.parse(s, charset, '&', ';');
        }

        private static NameValuePair buildNameValuePair(String name, String value, Charset charset) {
            return new NameValuePair(URLEncodedUtils.decodeFormFields(name, charset), URLEncodedUtils.decodeFormFields(value, charset));
        }

        public static List<NameValuePair> parse(@NotNull String s, Charset charset, char ... separators) {
            ArrayList<Character> delimiters = new ArrayList<Character>();
            for (char separator : separators) {
                delimiters.add(Character.valueOf(separator));
            }
            ArrayList<NameValuePair> list = new ArrayList<NameValuePair>();
            StringBuilder nameBuilder = new StringBuilder();
            boolean trackingName = true;
            StringBuilder valueBuilder = new StringBuilder();
            for (char c : s.toCharArray()) {
                if (delimiters.contains(Character.valueOf(c))) {
                    String name = nameBuilder.toString();
                    String value = valueBuilder.toString();
                    list.add(URLEncodedUtils.buildNameValuePair(name, value, charset));
                    nameBuilder = new StringBuilder();
                    valueBuilder = new StringBuilder();
                    trackingName = true;
                    continue;
                }
                if (c == '=') {
                    trackingName = false;
                    continue;
                }
                if (trackingName) {
                    nameBuilder.append(c);
                    continue;
                }
                valueBuilder.append(c);
            }
            String name = nameBuilder.toString();
            String value = valueBuilder.toString();
            list.add(URLEncodedUtils.buildNameValuePair(name, value, charset));
            return list;
        }

        public static String format(Iterable<? extends NameValuePair> parameters, Charset charset) {
            return URLEncodedUtils.format(parameters, '&', charset);
        }

        public static String format(@NotNull Iterable<? extends NameValuePair> parameters, char parameterSeparator, Charset charset) {
            StringBuilder result = new StringBuilder();
            for (NameValuePair nameValuePair : parameters) {
                String encodedName = URLEncodedUtils.encodeFormFields(nameValuePair.getName(), charset);
                String encodedValue = URLEncodedUtils.encodeFormFields(nameValuePair.getValue(), charset);
                if (result.length() > 0) {
                    result.append(parameterSeparator);
                }
                result.append(encodedName);
                if (encodedValue == null) continue;
                result.append("=");
                result.append(encodedValue);
            }
            return result.toString();
        }

        private static List<NameValuePair> createEmptyList() {
            return new ArrayList<NameValuePair>(0);
        }

        private static String urlEncode(String content, Charset charset, BitSet safechars, boolean blankAsPlus) {
            if (content == null) {
                return null;
            }
            StringBuilder buf = new StringBuilder();
            ByteBuffer bb = charset.encode(content);
            while (bb.hasRemaining()) {
                int b = bb.get() & 0xFF;
                if (safechars.get(b)) {
                    buf.append((char)b);
                    continue;
                }
                if (blankAsPlus && b == 32) {
                    buf.append('+');
                    continue;
                }
                buf.append("%");
                char hex1 = Character.toUpperCase(Character.forDigit(b >> 4 & 0xF, 16));
                char hex2 = Character.toUpperCase(Character.forDigit(b & 0xF, 16));
                buf.append(hex1);
                buf.append(hex2);
            }
            return buf.toString();
        }

        private static String urlDecode(String content, Charset charset, boolean plusAsBlank) {
            if (content == null) {
                return null;
            }
            ByteBuffer bb = ByteBuffer.allocate(content.length());
            CharBuffer cb = CharBuffer.wrap(content);
            while (cb.hasRemaining()) {
                char c = cb.get();
                if (c == '%' && cb.remaining() >= 2) {
                    char uc = cb.get();
                    char lc = cb.get();
                    int u = Character.digit(uc, 16);
                    int l = Character.digit(lc, 16);
                    if (u != -1 && l != -1) {
                        bb.put((byte)((u << 4) + l));
                        continue;
                    }
                    bb.put((byte)37);
                    bb.put((byte)uc);
                    bb.put((byte)lc);
                    continue;
                }
                if (plusAsBlank && c == '+') {
                    bb.put((byte)32);
                    continue;
                }
                bb.put((byte)c);
            }
            bb.flip();
            return charset.decode(bb).toString();
        }

        private static String decodeFormFields(String content, Charset charset) {
            return content == null ? null : URLEncodedUtils.urlDecode(content, charset != null ? charset : StandardCharsets.UTF_8, true);
        }

        private static String encodeFormFields(String content, Charset charset) {
            return content == null ? null : URLEncodedUtils.urlEncode(content, charset != null ? charset : StandardCharsets.UTF_8, URLENCODER, true);
        }
    }

    public static class NameValuePair {
        private final String name;
        private final Object value;

        NameValuePair(String name, Object value) {
            this.name = name;
            this.value = value;
        }

        public final String getName() {
            return this.name;
        }

        public final String getValue() {
            return this.value.toString();
        }
    }
}

