/*
 * Decompiled with CFR 0.152.
 */
package com.easypost.easyvcr.internal;

import java.util.logging.Level;
import java.util.logging.Logger;

public final class ConsoleFallbackLogger {
    private final Logger logger;
    private final String name;

    public ConsoleFallbackLogger(Logger logger, String name) {
        this.logger = logger;
        this.name = name;
    }

    public void error(String message) {
        if (this.logger != null) {
            this.logger.log(Level.INFO, this.makeMessage(message));
        } else {
            System.err.println(this.makeMessage(message));
        }
    }

    public void warning(String message) {
        if (this.logger != null) {
            this.logger.log(Level.WARNING, this.makeMessage(message));
        } else {
            System.out.println(this.makeMessage(message));
        }
    }

    private String makeMessage(String message) {
        return this.name + ": " + message;
    }
}

