/*
 * Decompiled with CFR 0.152.
 */
package com.easypost.easyvcr.internal;

import com.easypost.easyvcr.AdvancedSettings;
import com.easypost.easyvcr.CensorElement;
import com.easypost.easyvcr.Censors;
import com.easypost.easyvcr.internal.ApachePatch;
import com.easypost.easyvcr.requestelements.HttpInteraction;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Collections;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;

public abstract class Utilities {
    public static File getFile(String filePath) {
        if (filePath == null) {
            return null;
        }
        return Paths.get(filePath, new String[0]).toFile();
    }

    public static String getFilePath(String folderPath, String fileName) {
        return Paths.get(folderPath, fileName).toString();
    }

    public static String toBase64String(String input) {
        return Base64.getEncoder().encodeToString(input.getBytes());
    }

    public static InputStream createInputStream(String string) {
        if (string == null) {
            return new ByteArrayInputStream(new byte[0]);
        }
        return new ByteArrayInputStream(string.getBytes());
    }

    public static OutputStream createOutputStream(String string) throws IOException {
        if (string == null) {
            return new ByteArrayOutputStream();
        }
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        outputStream.write(string.getBytes());
        return outputStream;
    }

    public static InputStream copyInputStream(InputStream stream) {
        if (stream == null) {
            return null;
        }
        try {
            stream.reset();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        try {
            int len;
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            byte[] buffer = new byte[1024];
            while ((len = stream.read(buffer)) > -1) {
                baos.write(buffer, 0, len);
            }
            baos.flush();
            return new ByteArrayInputStream(baos.toByteArray());
        }
        catch (IOException ignored) {
            return new ByteArrayInputStream(new byte[0]);
        }
    }

    public static String readFromInputStream(InputStream stream) {
        if (stream == null) {
            return null;
        }
        InputStream copy = Utilities.copyInputStream(stream);
        String str = null;
        try {
            String inputLine;
            BufferedReader in = new BufferedReader(new InputStreamReader(copy));
            StringBuilder content = new StringBuilder();
            while ((inputLine = in.readLine()) != null) {
                content.append(inputLine);
            }
            in.close();
            str = content.toString();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return str;
    }

    public static List<ApachePatch.NameValuePair> mapToQueryParameters(Map<String, String> map) {
        if (map == null || map.size() == 0) {
            return Collections.emptyList();
        }
        ArrayList<ApachePatch.NameValuePair> nvpList = new ArrayList<ApachePatch.NameValuePair>(map.size());
        for (Map.Entry<String, String> entry : map.entrySet()) {
            nvpList.add(new ApachePatch.NameValuePair(entry.getKey(), entry.getValue()));
        }
        return nvpList;
    }

    public static Map<String, String> queryParametersToMap(URI uri) {
        List<ApachePatch.NameValuePair> receivedQueryDict = ApachePatch.URLEncodedUtils.parse(uri, StandardCharsets.UTF_8);
        if (receivedQueryDict == null || receivedQueryDict.size() == 0) {
            return Collections.emptyMap();
        }
        Hashtable<String, String> queryDict = new Hashtable<String, String>();
        for (ApachePatch.NameValuePair pair : receivedQueryDict) {
            queryDict.put(pair.getName(), pair.getValue());
        }
        return queryDict;
    }

    public static void simulateDelay(HttpInteraction interaction, AdvancedSettings advancedSettings) throws InterruptedException {
        if (advancedSettings.simulateDelay) {
            Thread.sleep(interaction.getDuration());
        } else {
            Thread.sleep(advancedSettings.manualDelay);
        }
    }

    public static boolean isDictionary(Object obj) {
        return obj instanceof Map;
    }

    public static boolean isList(Object obj) {
        return obj instanceof List;
    }

    public static String removeJsonElements(String json, List<CensorElement> elements) {
        if (json == null || elements == null) {
            return json;
        }
        return Censors.censorJsonData(json, "FILTERED", elements);
    }

    public static String extractPathFromUri(URI uri) {
        String uriString = uri.toString();
        try {
            String query = uri.getQuery();
            if (query != null) {
                uriString = uriString.replace(query, "");
            }
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        if (uriString.endsWith("?")) {
            uriString = uriString.substring(0, uriString.length() - 1);
        }
        uriString = uriString.replace(uri.getScheme() + "://", "");
        return uriString;
    }
}

