/*
 * Decompiled with CFR 0.152.
 */
package com.eatthepath.json;

import java.text.ParseException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class JsonParser {
    private transient String jsonString;
    private transient int position;
    private final transient StringBuilder stringBuilder = new StringBuilder();

    public Map<String, Object> parseJsonObject(String jsonString) throws ParseException {
        this.jsonString = jsonString;
        this.position = JsonParser.findNextToken(jsonString, 0);
        if (jsonString.charAt(this.position) != '{') {
            throw new ParseException("JSON string does not represent a JSON object.", this.position);
        }
        return this.parseObject();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    Object parseNextValue() throws ParseException {
        Object value;
        this.position = JsonParser.findNextToken(this.jsonString, this.position);
        char c = this.jsonString.charAt(this.position);
        if (c == '\"') {
            return this.parseString();
        }
        if (c == '-' || c >= '0' && c <= '9') {
            int numberStart = this.position;
            try {
                return this.parseNumber();
            }
            catch (NumberFormatException e) {
                throw new ParseException("Could not parse number", numberStart);
            }
        }
        if (c == '{') {
            return this.parseObject();
        }
        if (c == '[') {
            return this.parseList();
        }
        if (c == 't') {
            if (!this.jsonString.regionMatches(this.position, "true", 0, 4)) throw new ParseException("Unexpected literal", this.position);
            value = true;
            this.position += 4;
            return value;
        } else if (c == 'f') {
            if (!this.jsonString.regionMatches(this.position, "false", 0, 5)) throw new ParseException("Unexpected literal", this.position);
            value = false;
            this.position += 5;
            return value;
        } else {
            if (c != 'n') throw new ParseException("Unexpected token", this.position);
            if (!this.jsonString.regionMatches(this.position, "null", 0, 4)) throw new ParseException("Unexpected literal", this.position);
            value = null;
            this.position += 4;
        }
        return value;
    }

    String parseString() throws ParseException {
        this.stringBuilder.setLength(0);
        ++this.position;
        int start = this.position;
        while (this.position < this.jsonString.length()) {
            char c = this.jsonString.charAt(this.position);
            if (c == '\\') {
                char escapedChar;
                int charsConsumed;
                if (this.position + 1 >= this.jsonString.length()) {
                    throw new ParseException("Expected escaped character, but reached end of input", this.position);
                }
                switch (this.jsonString.charAt(this.position + 1)) {
                    case '\"': {
                        charsConsumed = 1;
                        escapedChar = '\"';
                        break;
                    }
                    case '\\': {
                        charsConsumed = 1;
                        escapedChar = '\\';
                        break;
                    }
                    case '/': {
                        charsConsumed = 1;
                        escapedChar = '/';
                        break;
                    }
                    case 'b': {
                        charsConsumed = 1;
                        escapedChar = '\b';
                        break;
                    }
                    case 'f': {
                        charsConsumed = 1;
                        escapedChar = '\f';
                        break;
                    }
                    case 'n': {
                        charsConsumed = 1;
                        escapedChar = '\n';
                        break;
                    }
                    case 'r': {
                        charsConsumed = 1;
                        escapedChar = '\r';
                        break;
                    }
                    case 't': {
                        charsConsumed = 1;
                        escapedChar = '\t';
                        break;
                    }
                    case 'u': {
                        if (this.position + 5 >= this.jsonString.length()) {
                            throw new ParseException("Expected escaped unicode sequence, but reached end of input", this.position);
                        }
                        charsConsumed = 5;
                        escapedChar = (char)Integer.parseInt(this.jsonString.substring(this.position + 2, this.position + 6), 16);
                        break;
                    }
                    default: {
                        throw new ParseException("Illegal escaped character: " + this.jsonString.charAt(this.position + 1), this.position);
                    }
                }
                this.stringBuilder.append(this.jsonString, start, this.position);
                this.stringBuilder.append(escapedChar);
                this.position += charsConsumed;
                start = this.position + 1;
            } else if (c == '\"') {
                String unescapedString;
                if (this.stringBuilder.length() == 0) {
                    unescapedString = this.jsonString.substring(start, this.position);
                } else {
                    this.stringBuilder.append(this.jsonString, start, this.jsonString.length() - 1);
                    unescapedString = this.stringBuilder.toString();
                }
                ++this.position;
                return unescapedString;
            }
            ++this.position;
        }
        throw new ParseException("Expected \", but reached end of input.", this.position);
    }

    Number parseNumber() {
        int endExclusive;
        boolean negate = this.jsonString.charAt(this.position) == '-';
        boolean parseAsDouble = false;
        int startInclusive = this.position;
        long parsedLong = 0L;
        int n = endExclusive = negate ? this.position + 1 : this.position;
        while (endExclusive < this.jsonString.length()) {
            char c = this.jsonString.charAt(endExclusive);
            if (c >= '0' && c <= '9') {
                parsedLong *= 10L;
                parsedLong += (long)(c - 48);
            } else {
                if (c != '.' && c != 'e' && c != 'E' && c != '+' && c != '-') break;
                parseAsDouble = true;
            }
            ++endExclusive;
        }
        this.position = endExclusive;
        if (parseAsDouble) {
            return Double.parseDouble(this.jsonString.substring(startInclusive, endExclusive));
        }
        return negate ? -parsedLong : parsedLong;
    }

    Map<String, Object> parseObject() throws ParseException {
        this.position = JsonParser.findNextToken(this.jsonString, this.position + 1);
        HashMap<String, Object> map = new HashMap<String, Object>();
        while (this.jsonString.charAt(this.position) != '}') {
            if (this.jsonString.charAt(this.position) != '\"') {
                throw new ParseException("Expected a string", this.position);
            }
            String key = this.parseString();
            this.position = JsonParser.findNextToken(this.jsonString, this.position);
            if (this.jsonString.charAt(this.position) != ':') {
                throw new ParseException("Expected ':'", this.position);
            }
            ++this.position;
            map.put(key, this.parseNextValue());
            this.position = JsonParser.findNextToken(this.jsonString, this.position);
            if (this.jsonString.charAt(this.position) != ',') continue;
            this.position = JsonParser.findNextToken(this.jsonString, this.position + 1);
        }
        ++this.position;
        return map;
    }

    List<Object> parseList() throws ParseException {
        this.position = JsonParser.findNextToken(this.jsonString, this.position + 1);
        ArrayList<Object> list = new ArrayList<Object>();
        while (this.jsonString.charAt(this.position) != ']') {
            list.add(this.parseNextValue());
            this.position = JsonParser.findNextToken(this.jsonString, this.position);
            if (this.jsonString.charAt(this.position) != ',') continue;
            this.position = JsonParser.findNextToken(this.jsonString, this.position + 1);
        }
        ++this.position;
        return list;
    }

    void setJsonString(String jsonString) {
        this.jsonString = jsonString;
        this.position = 0;
    }

    static int findNextToken(String string, int start) throws ParseException {
        for (int i = start; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (c == ' ' || c == '\t' || c == '\r' || c == '\n') continue;
            return i;
        }
        throw new ParseException("Expected token, but reached end of input", start);
    }
}

