/*
 * Decompiled with CFR 0.152.
 */
package com.eatthepath.pushy.apns;

import com.eatthepath.json.JsonParser;
import com.eatthepath.pushy.apns.ApnsChannelFactory;
import com.eatthepath.pushy.apns.ApnsPushNotification;
import com.eatthepath.pushy.apns.ErrorResponse;
import com.eatthepath.pushy.apns.SimplePushNotificationResponse;
import com.eatthepath.pushy.apns.util.concurrent.PushNotificationFuture;
import com.eatthepath.uuid.FastUUID;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelPromise;
import io.netty.handler.codec.http.HttpMethod;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http.HttpScheme;
import io.netty.handler.codec.http2.AbstractHttp2ConnectionHandlerBuilder;
import io.netty.handler.codec.http2.DefaultHttp2Headers;
import io.netty.handler.codec.http2.Http2Connection;
import io.netty.handler.codec.http2.Http2ConnectionDecoder;
import io.netty.handler.codec.http2.Http2ConnectionEncoder;
import io.netty.handler.codec.http2.Http2ConnectionHandler;
import io.netty.handler.codec.http2.Http2Error;
import io.netty.handler.codec.http2.Http2Exception;
import io.netty.handler.codec.http2.Http2Flags;
import io.netty.handler.codec.http2.Http2FrameListener;
import io.netty.handler.codec.http2.Http2FrameLogger;
import io.netty.handler.codec.http2.Http2Headers;
import io.netty.handler.codec.http2.Http2Settings;
import io.netty.handler.codec.http2.Http2Stream;
import io.netty.handler.timeout.IdleStateEvent;
import io.netty.util.AsciiString;
import io.netty.util.collection.IntObjectHashMap;
import io.netty.util.concurrent.Future;
import io.netty.util.concurrent.Promise;
import io.netty.util.concurrent.PromiseCombiner;
import io.netty.util.concurrent.ScheduledFuture;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.text.ParseException;
import java.time.Duration;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class ApnsClientHandler
extends Http2ConnectionHandler
implements Http2FrameListener,
Http2Connection.Listener {
    private final Map<Integer, PushNotificationFuture<?, ?>> unattachedResponsePromisesByStreamId = new IntObjectHashMap();
    private final Http2Connection.PropertyKey responseHeadersPropertyKey;
    private final Http2Connection.PropertyKey responsePromisePropertyKey;
    private final Http2Connection.PropertyKey streamErrorCausePropertyKey;
    private final String authority;
    private final Duration pingTimeout;
    private ScheduledFuture<?> pingTimeoutFuture;
    private Throwable connectionErrorCause;
    private static final AsciiString APNS_PATH_PREFIX = new AsciiString((CharSequence)"/3/device/");
    private static final AsciiString APNS_EXPIRATION_HEADER = new AsciiString((CharSequence)"apns-expiration");
    private static final AsciiString APNS_TOPIC_HEADER = new AsciiString((CharSequence)"apns-topic");
    private static final AsciiString APNS_PRIORITY_HEADER = new AsciiString((CharSequence)"apns-priority");
    private static final AsciiString APNS_COLLAPSE_ID_HEADER = new AsciiString((CharSequence)"apns-collapse-id");
    private static final AsciiString APNS_ID_HEADER = new AsciiString((CharSequence)"apns-id");
    private static final AsciiString APNS_PUSH_TYPE_HEADER = new AsciiString((CharSequence)"apns-push-type");
    private static final IOException STREAMS_EXHAUSTED_EXCEPTION = new IOException("HTTP/2 streams exhausted; closing connection.");
    private static final IOException STREAM_CLOSED_BEFORE_REPLY_EXCEPTION = new IOException("Stream closed before a reply was received");
    private final JsonParser jsonParser = new JsonParser();
    private static final Logger log = LoggerFactory.getLogger(ApnsClientHandler.class);

    ApnsClientHandler(Http2ConnectionDecoder decoder, Http2ConnectionEncoder encoder, Http2Settings initialSettings, String authority, Duration idlePingInterval) {
        super(decoder, encoder, initialSettings);
        this.authority = authority;
        this.responseHeadersPropertyKey = this.connection().newKey();
        this.responsePromisePropertyKey = this.connection().newKey();
        this.streamErrorCausePropertyKey = this.connection().newKey();
        this.connection().addListener((Http2Connection.Listener)this);
        this.pingTimeout = idlePingInterval.dividedBy(2L);
    }

    public void write(ChannelHandlerContext context, Object message, ChannelPromise writePromise) {
        if (message instanceof PushNotificationFuture) {
            PushNotificationFuture pushNotificationFuture = (PushNotificationFuture)message;
            writePromise.addListener(future -> {
                if (!future.isSuccess()) {
                    log.trace("Failed to write push notification.", future.cause());
                    pushNotificationFuture.completeExceptionally(future.cause());
                }
            });
            this.writePushNotification(context, pushNotificationFuture, writePromise);
        } else {
            log.error("Unexpected object in pipeline: {}", message);
            context.write(message, writePromise);
        }
    }

    private void retryPushNotificationFromStream(ChannelHandlerContext context, int streamId) {
        Http2Stream stream = this.connection().stream(streamId);
        PushNotificationFuture responseFuture = (PushNotificationFuture)stream.removeProperty(this.responsePromisePropertyKey);
        ChannelPromise writePromise = context.channel().newPromise();
        this.writePushNotification(context, responseFuture, writePromise);
    }

    private void writePushNotification(ChannelHandlerContext context, PushNotificationFuture<?, ?> responsePromise, ChannelPromise writePromise) {
        if (context.channel().isActive()) {
            int streamId = this.connection().local().incrementAndGetNextStreamId();
            if (streamId > 0) {
                this.unattachedResponsePromisesByStreamId.put(streamId, responsePromise);
                Object pushNotification = responsePromise.getPushNotification();
                Http2Headers headers = this.getHeadersForPushNotification((ApnsPushNotification)pushNotification, context, streamId);
                ChannelPromise headersPromise = context.newPromise();
                this.encoder().writeHeaders(context, streamId, headers, 0, false, headersPromise);
                log.trace("Wrote headers on stream {}: {}", (Object)streamId, (Object)headers);
                ByteBuf payloadBuffer = Unpooled.wrappedBuffer((byte[])pushNotification.getPayload().getBytes(StandardCharsets.UTF_8));
                ChannelPromise dataPromise = context.newPromise();
                this.encoder().writeData(context, streamId, payloadBuffer, 0, true, dataPromise);
                log.trace("Wrote payload on stream {}: {}", (Object)streamId, (Object)pushNotification.getPayload());
                PromiseCombiner promiseCombiner = new PromiseCombiner(context.executor());
                promiseCombiner.addAll(new Future[]{headersPromise, dataPromise});
                promiseCombiner.finish((Promise)writePromise);
            } else {
                writePromise.tryFailure((Throwable)STREAMS_EXHAUSTED_EXCEPTION);
                context.channel().close();
            }
        } else {
            writePromise.tryFailure((Throwable)STREAM_CLOSED_BEFORE_REPLY_EXCEPTION);
        }
    }

    protected Http2Headers getHeadersForPushNotification(ApnsPushNotification pushNotification, ChannelHandlerContext context, int streamId) {
        Http2Headers headers = (Http2Headers)new DefaultHttp2Headers().method((CharSequence)HttpMethod.POST.asciiName()).authority((CharSequence)this.authority).path((CharSequence)APNS_PATH_PREFIX.concat((CharSequence)pushNotification.getToken())).scheme((CharSequence)HttpScheme.HTTPS.name()).addInt((Object)APNS_EXPIRATION_HEADER, pushNotification.getExpiration() == null ? 0 : (int)pushNotification.getExpiration().getEpochSecond());
        if (pushNotification.getCollapseId() != null) {
            headers.add((Object)APNS_COLLAPSE_ID_HEADER, (Object)pushNotification.getCollapseId());
        }
        if (pushNotification.getPriority() != null) {
            headers.addInt((Object)APNS_PRIORITY_HEADER, pushNotification.getPriority().getCode());
        }
        if (pushNotification.getPushType() != null) {
            headers.add((Object)APNS_PUSH_TYPE_HEADER, (Object)pushNotification.getPushType().getHeaderValue());
        }
        if (pushNotification.getTopic() != null) {
            headers.add((Object)APNS_TOPIC_HEADER, (Object)pushNotification.getTopic());
        }
        if (pushNotification.getApnsId() != null) {
            headers.add((Object)APNS_ID_HEADER, (Object)FastUUID.toString((UUID)pushNotification.getApnsId()));
        }
        return headers;
    }

    public void userEventTriggered(ChannelHandlerContext context, Object event) throws Exception {
        if (event instanceof IdleStateEvent) {
            log.trace("Sending ping due to inactivity.");
            this.encoder().writePing(context, false, System.currentTimeMillis(), context.newPromise()).addListener(future -> {
                if (!future.isSuccess()) {
                    log.debug("Failed to write PING frame.", future.cause());
                    future.channel().close();
                }
            });
            this.pingTimeoutFuture = context.channel().eventLoop().schedule(() -> {
                log.debug("Closing channel due to ping timeout.");
                context.channel().close();
            }, this.pingTimeout.toMillis(), TimeUnit.MILLISECONDS);
            this.flush(context);
        }
        super.userEventTriggered(context, event);
    }

    public int onDataRead(ChannelHandlerContext context, int streamId, ByteBuf data, int padding, boolean endOfStream) {
        int bytesProcessed = data.readableBytes() + padding;
        if (endOfStream) {
            Http2Stream stream = this.connection().stream(streamId);
            this.handleEndOfStream(context, stream, (Http2Headers)stream.getProperty(this.responseHeadersPropertyKey), data);
        } else {
            log.error("Gateway sent a DATA frame that was not the end of a stream.");
        }
        return bytesProcessed;
    }

    public void onHeadersRead(ChannelHandlerContext context, int streamId, Http2Headers headers, int streamDependency, short weight, boolean exclusive, int padding, boolean endOfStream) {
        this.onHeadersRead(context, streamId, headers, padding, endOfStream);
    }

    public void onHeadersRead(ChannelHandlerContext context, int streamId, Http2Headers headers, int padding, boolean endOfStream) {
        Http2Stream stream = this.connection().stream(streamId);
        if (endOfStream) {
            this.handleEndOfStream(context, stream, headers, null);
        } else {
            stream.setProperty(this.responseHeadersPropertyKey, (Object)headers);
        }
    }

    private void handleEndOfStream(ChannelHandlerContext context, Http2Stream stream, Http2Headers headers, ByteBuf data) {
        PushNotificationFuture responseFuture = (PushNotificationFuture)stream.getProperty(this.responsePromisePropertyKey);
        Object pushNotification = responseFuture.getPushNotification();
        HttpResponseStatus status = HttpResponseStatus.parseLine((CharSequence)headers.status());
        if (HttpResponseStatus.OK.equals((Object)status)) {
            responseFuture.complete(new SimplePushNotificationResponse(responseFuture.getPushNotification(), true, ApnsClientHandler.getApnsIdFromHeaders(headers), status.code(), null, null));
        } else if (data != null) {
            ErrorResponse errorResponse;
            try {
                errorResponse = ErrorResponse.fromMap(this.jsonParser.parseJsonObject(data.toString(StandardCharsets.UTF_8)));
            }
            catch (ParseException e) {
                log.error("Failed to parse error response: {}", (Object)data.toString(StandardCharsets.UTF_8));
                errorResponse = new ErrorResponse(null, null);
            }
            this.handleErrorResponse(context, stream.id(), headers, (ApnsPushNotification)pushNotification, errorResponse);
        } else {
            log.warn("Gateway sent an end-of-stream HEADERS frame for an unsuccessful notification.");
        }
    }

    protected void handleErrorResponse(ChannelHandlerContext context, int streamId, Http2Headers headers, ApnsPushNotification pushNotification, ErrorResponse errorResponse) {
        PushNotificationFuture responseFuture = (PushNotificationFuture)this.connection().stream(streamId).getProperty(this.responsePromisePropertyKey);
        HttpResponseStatus status = HttpResponseStatus.parseLine((CharSequence)headers.status());
        responseFuture.complete(new SimplePushNotificationResponse(responseFuture.getPushNotification(), HttpResponseStatus.OK.equals((Object)status), ApnsClientHandler.getApnsIdFromHeaders(headers), status.code(), errorResponse.getReason(), errorResponse.getTimestamp()));
    }

    private static UUID getApnsIdFromHeaders(Http2Headers headers) {
        CharSequence apnsIdSequence = (CharSequence)headers.get((Object)APNS_ID_HEADER);
        try {
            return apnsIdSequence != null ? FastUUID.parseUUID((CharSequence)apnsIdSequence) : null;
        }
        catch (IllegalArgumentException e) {
            log.error("Failed to parse `apns-id` header: {}", (Object)apnsIdSequence, (Object)e);
            return null;
        }
    }

    public void onPriorityRead(ChannelHandlerContext ctx, int streamId, int streamDependency, short weight, boolean exclusive) {
    }

    public void onRstStreamRead(ChannelHandlerContext context, int streamId, long errorCode) {
        if (errorCode == Http2Error.REFUSED_STREAM.code()) {
            this.retryPushNotificationFromStream(context, streamId);
        }
    }

    public void onSettingsAckRead(ChannelHandlerContext ctx) {
    }

    public void onSettingsRead(ChannelHandlerContext context, Http2Settings settings) {
        log.debug("Received settings from APNs gateway: {}", (Object)settings);
        this.getChannelReadyPromise(context.channel()).trySuccess((Object)context.channel());
    }

    public void onPingRead(ChannelHandlerContext ctx, long pingData) {
    }

    public void onPingAckRead(ChannelHandlerContext context, long pingData) {
        if (this.pingTimeoutFuture != null) {
            this.pingTimeoutFuture.cancel(false);
        } else {
            log.error("Received PING ACK, but no corresponding outbound PING found.");
        }
    }

    public void onPushPromiseRead(ChannelHandlerContext ctx, int streamId, int promisedStreamId, Http2Headers headers, int padding) {
    }

    public void onGoAwayRead(ChannelHandlerContext context, int lastStreamId, long errorCode, ByteBuf debugData) {
        log.info("Received GOAWAY from APNs server: {}", (Object)debugData.toString(StandardCharsets.UTF_8));
        context.close();
    }

    public void onWindowUpdateRead(ChannelHandlerContext ctx, int streamId, int windowSizeIncrement) {
    }

    public void onUnknownFrame(ChannelHandlerContext ctx, byte frameType, int streamId, Http2Flags flags, ByteBuf payload) {
    }

    public void onStreamAdded(Http2Stream stream) {
        stream.setProperty(this.responsePromisePropertyKey, this.unattachedResponsePromisesByStreamId.remove(stream.id()));
    }

    public void onStreamActive(Http2Stream stream) {
    }

    public void onStreamHalfClosed(Http2Stream stream) {
    }

    public void onStreamClosed(Http2Stream stream) {
        CompletableFuture responsePromise = (CompletableFuture)stream.getProperty(this.responsePromisePropertyKey);
        if (responsePromise != null) {
            Throwable cause = stream.getProperty(this.streamErrorCausePropertyKey) != null ? (Throwable)stream.getProperty(this.streamErrorCausePropertyKey) : (this.connectionErrorCause != null ? this.connectionErrorCause : STREAM_CLOSED_BEFORE_REPLY_EXCEPTION);
            responsePromise.completeExceptionally(cause);
        }
    }

    public void onStreamRemoved(Http2Stream stream) {
        stream.removeProperty(this.responseHeadersPropertyKey);
        stream.removeProperty(this.responsePromisePropertyKey);
    }

    public void onGoAwaySent(int lastStreamId, long errorCode, ByteBuf debugData) {
    }

    public void onGoAwayReceived(int lastStreamId, long errorCode, ByteBuf debugData) {
    }

    protected void onStreamError(ChannelHandlerContext context, boolean isOutbound, Throwable cause, Http2Exception.StreamException streamException) {
        Http2Stream stream = this.connection().stream(streamException.streamId());
        if (stream != null) {
            stream.setProperty(this.streamErrorCausePropertyKey, (Object)streamException);
        }
        super.onStreamError(context, isOutbound, cause, streamException);
    }

    protected void onConnectionError(ChannelHandlerContext context, boolean isOutbound, Throwable cause, Http2Exception http2Exception) {
        this.connectionErrorCause = http2Exception != null ? http2Exception : cause;
        super.onConnectionError(context, isOutbound, cause, http2Exception);
    }

    public void channelInactive(ChannelHandlerContext context) throws Exception {
        if (this.pingTimeoutFuture != null) {
            this.pingTimeoutFuture.cancel(false);
        }
        for (PushNotificationFuture<?, ?> future : this.unattachedResponsePromisesByStreamId.values()) {
            future.completeExceptionally(STREAM_CLOSED_BEFORE_REPLY_EXCEPTION);
        }
        this.unattachedResponsePromisesByStreamId.clear();
        if (this.getChannelReadyPromise(context.channel()).tryFailure((Throwable)STREAM_CLOSED_BEFORE_REPLY_EXCEPTION)) {
            log.debug("Channel became inactive before SETTINGS frame received");
        }
        super.channelInactive(context);
    }

    public void exceptionCaught(ChannelHandlerContext context, Throwable cause) {
        this.getChannelReadyPromise(context.channel()).tryFailure(cause);
    }

    private Promise<Channel> getChannelReadyPromise(Channel channel) {
        return (Promise)channel.attr(ApnsChannelFactory.CHANNEL_READY_PROMISE_ATTRIBUTE_KEY).get();
    }

    public static class ApnsClientHandlerBuilder
    extends AbstractHttp2ConnectionHandlerBuilder<ApnsClientHandler, ApnsClientHandlerBuilder> {
        private String authority;
        private Duration idlePingInterval;

        ApnsClientHandlerBuilder authority(String authority) {
            this.authority = authority;
            return this;
        }

        String authority() {
            return this.authority;
        }

        Duration idlePingInterval() {
            return this.idlePingInterval;
        }

        ApnsClientHandlerBuilder idlePingInterval(Duration idlePingIntervalMillis) {
            this.idlePingInterval = idlePingIntervalMillis;
            return this;
        }

        public ApnsClientHandlerBuilder frameLogger(Http2FrameLogger frameLogger) {
            return (ApnsClientHandlerBuilder)super.frameLogger(frameLogger);
        }

        public Http2FrameLogger frameLogger() {
            return super.frameLogger();
        }

        protected final boolean isServer() {
            return false;
        }

        protected boolean encoderEnforceMaxConcurrentStreams() {
            return true;
        }

        public ApnsClientHandler build(Http2ConnectionDecoder decoder, Http2ConnectionEncoder encoder, Http2Settings initialSettings) {
            Objects.requireNonNull(this.authority(), "Authority must be set before building an ApnsClientHandler.");
            ApnsClientHandler handler = new ApnsClientHandler(decoder, encoder, initialSettings, this.authority(), this.idlePingInterval());
            this.frameListener(handler);
            return handler;
        }

        public ApnsClientHandler build() {
            return (ApnsClientHandler)super.build();
        }
    }
}

