/*
 * Decompiled with CFR 0.152.
 */
package com.eatthepath.pushy.apns;

import com.eatthepath.pushy.apns.ApnsClientMetricsListener;
import com.eatthepath.pushy.apns.auth.ApnsSigningKey;
import com.eatthepath.pushy.apns.proxy.ProxyHandlerFactory;
import io.netty.handler.codec.http2.Http2FrameLogger;
import io.netty.handler.ssl.SslContext;
import java.net.InetSocketAddress;
import java.time.Duration;
import java.util.Objects;
import java.util.Optional;

class ApnsClientConfiguration {
    private static final Duration DEFAULT_TOKEN_EXPIRATION = Duration.ofMinutes(50L);
    private final InetSocketAddress apnsServerAddress;
    private final SslContext sslContext;
    private final boolean hostnameVerificationEnabled;
    private final ApnsSigningKey signingKey;
    private final Duration tokenExpiration;
    private final ProxyHandlerFactory proxyHandlerFactory;
    private final Duration connectionTimeout;
    private final Duration idlePingInterval;
    private final Duration gracefulShutdownTimeout;
    private final int concurrentConnections;
    private final ApnsClientMetricsListener metricsListener;
    private final Http2FrameLogger frameLogger;

    public ApnsClientConfiguration(InetSocketAddress apnsServerAddress, SslContext sslContext, boolean hostnameVerificationEnabled, ApnsSigningKey signingKey, Duration tokenExpiration, ProxyHandlerFactory proxyHandlerFactory, Duration connectionTimeout, Duration idlePingInterval, Duration gracefulShutdownTimeout, int concurrentConnections, ApnsClientMetricsListener metricsListener, Http2FrameLogger frameLogger) {
        this.apnsServerAddress = Objects.requireNonNull(apnsServerAddress);
        this.sslContext = Objects.requireNonNull(sslContext);
        this.hostnameVerificationEnabled = hostnameVerificationEnabled;
        this.signingKey = signingKey;
        this.tokenExpiration = tokenExpiration != null ? tokenExpiration : DEFAULT_TOKEN_EXPIRATION;
        this.proxyHandlerFactory = proxyHandlerFactory;
        this.connectionTimeout = connectionTimeout;
        this.idlePingInterval = idlePingInterval;
        this.gracefulShutdownTimeout = gracefulShutdownTimeout;
        this.concurrentConnections = concurrentConnections;
        this.metricsListener = metricsListener;
        this.frameLogger = frameLogger;
    }

    public InetSocketAddress getApnsServerAddress() {
        return this.apnsServerAddress;
    }

    public SslContext getSslContext() {
        return this.sslContext;
    }

    public boolean isHostnameVerificationEnabled() {
        return this.hostnameVerificationEnabled;
    }

    public Optional<ApnsSigningKey> getSigningKey() {
        return Optional.ofNullable(this.signingKey);
    }

    public Duration getTokenExpiration() {
        return this.tokenExpiration;
    }

    public Optional<ProxyHandlerFactory> getProxyHandlerFactory() {
        return Optional.ofNullable(this.proxyHandlerFactory);
    }

    public Optional<Duration> getConnectionTimeout() {
        return Optional.ofNullable(this.connectionTimeout);
    }

    public Duration getIdlePingInterval() {
        return this.idlePingInterval;
    }

    public Optional<Duration> getGracefulShutdownTimeout() {
        return Optional.ofNullable(this.gracefulShutdownTimeout);
    }

    public int getConcurrentConnections() {
        return this.concurrentConnections;
    }

    public Optional<ApnsClientMetricsListener> getMetricsListener() {
        return Optional.ofNullable(this.metricsListener);
    }

    public Optional<Http2FrameLogger> getFrameLogger() {
        return Optional.ofNullable(this.frameLogger);
    }
}

