/*
 * Decompiled with CFR 0.152.
 */
package com.eatthepath.pushy.apns.proxy;

import com.eatthepath.pushy.apns.proxy.ProxyHandlerFactory;
import io.netty.handler.proxy.HttpProxyHandler;
import io.netty.handler.proxy.ProxyHandler;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.net.ProxySelector;
import java.net.SocketAddress;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpProxyHandlerFactory
implements ProxyHandlerFactory {
    private static final Logger log = LoggerFactory.getLogger(HttpProxyHandlerFactory.class);
    private final SocketAddress proxyAddress;
    private final String username;
    private final String password;
    private static final String PROXY_USERNAME_PROPERTY_KEY = "http.proxyUser";
    private static final String PROXY_PASSWORD_PROPERTY_KEY = "http.proxyPassword";

    public static HttpProxyHandlerFactory fromSystemProxies(String apnsHost) throws URISyntaxException {
        SocketAddress proxyAddress = HttpProxyHandlerFactory.getProxyAddressForUri(new URI("https", apnsHost, null, null));
        return proxyAddress != null ? new HttpProxyHandlerFactory(proxyAddress, System.getProperty(PROXY_USERNAME_PROPERTY_KEY), System.getProperty(PROXY_PASSWORD_PROPERTY_KEY)) : null;
    }

    private static SocketAddress getProxyAddressForUri(URI uri) {
        ProxySelector defaultProxySelector = ProxySelector.getDefault();
        List<Proxy> proxiesForUri = defaultProxySelector.select(uri);
        log.debug("Proxies for \"{}\": {}", (Object)uri, proxiesForUri);
        for (Proxy proxy : proxiesForUri) {
            if (proxy.type() != Proxy.Type.HTTP) continue;
            InetSocketAddress proxyAddress = (InetSocketAddress)proxy.address();
            if (proxyAddress.isUnresolved()) {
                proxyAddress = new InetSocketAddress(proxyAddress.getHostString(), proxyAddress.getPort());
            }
            return proxyAddress;
        }
        return null;
    }

    public HttpProxyHandlerFactory(SocketAddress proxyAddress) {
        this(proxyAddress, null, null);
    }

    public HttpProxyHandlerFactory(SocketAddress proxyAddress, String username, String password) {
        this.proxyAddress = proxyAddress;
        this.username = username;
        this.password = password;
    }

    @Override
    public ProxyHandler createProxyHandler() {
        HttpProxyHandler handler = this.username != null && this.password != null ? new HttpProxyHandler(this.proxyAddress, this.username, this.password) : new HttpProxyHandler(this.proxyAddress);
        return handler;
    }

    String getUsername() {
        return this.username;
    }

    String getPassword() {
        return this.password;
    }

    public String toString() {
        return "HttpProxyHandlerFactory {proxyAddress=" + this.proxyAddress + ", username=" + this.username + ", password=*****}";
    }
}

