/*
 * Decompiled with CFR 0.152.
 */
package com.eatthepath.pushy.apns.server;

import com.eatthepath.pushy.apns.server.BaseHttp2Server;
import io.netty.channel.EventLoopGroup;
import io.netty.handler.codec.http2.Http2SecurityUtil;
import io.netty.handler.ssl.ApplicationProtocolConfig;
import io.netty.handler.ssl.CipherSuiteFilter;
import io.netty.handler.ssl.ClientAuth;
import io.netty.handler.ssl.OpenSsl;
import io.netty.handler.ssl.SslContext;
import io.netty.handler.ssl.SslContextBuilder;
import io.netty.handler.ssl.SslProvider;
import io.netty.handler.ssl.SupportedCipherSuiteFilter;
import io.netty.util.ReferenceCounted;
import java.io.File;
import java.io.InputStream;
import java.security.PrivateKey;
import java.security.cert.X509Certificate;
import javax.net.ssl.SSLException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

abstract class BaseHttp2ServerBuilder<T extends BaseHttp2Server> {
    protected X509Certificate[] certificateChain;
    protected PrivateKey privateKey;
    protected File certificateChainPemFile;
    protected File privateKeyPkcs8File;
    protected InputStream certificateChainInputStream;
    protected InputStream privateKeyPkcs8InputStream;
    protected String privateKeyPassword;
    protected File trustedClientCertificatePemFile;
    protected InputStream trustedClientCertificateInputStream;
    protected X509Certificate[] trustedClientCertificates;
    protected EventLoopGroup eventLoopGroup;
    protected int maxConcurrentStreams = 1500;
    protected boolean useAlpn;
    public static final int DEFAULT_MAX_CONCURRENT_STREAMS = 1500;
    private static final Logger log = LoggerFactory.getLogger(BaseHttp2ServerBuilder.class);

    BaseHttp2ServerBuilder() {
    }

    public BaseHttp2ServerBuilder<T> setServerCredentials(File certificatePemFile, File privateKeyPkcs8File, String privateKeyPassword) {
        this.certificateChain = null;
        this.privateKey = null;
        this.certificateChainPemFile = certificatePemFile;
        this.privateKeyPkcs8File = privateKeyPkcs8File;
        this.certificateChainInputStream = null;
        this.privateKeyPkcs8InputStream = null;
        this.privateKeyPassword = privateKeyPassword;
        return this;
    }

    public BaseHttp2ServerBuilder<T> setServerCredentials(InputStream certificatePemInputStream, InputStream privateKeyPkcs8InputStream, String privateKeyPassword) {
        this.certificateChain = null;
        this.privateKey = null;
        this.certificateChainPemFile = null;
        this.privateKeyPkcs8File = null;
        this.certificateChainInputStream = certificatePemInputStream;
        this.privateKeyPkcs8InputStream = privateKeyPkcs8InputStream;
        this.privateKeyPassword = privateKeyPassword;
        return this;
    }

    public BaseHttp2ServerBuilder<T> setServerCredentials(X509Certificate[] certificates, PrivateKey privateKey, String privateKeyPassword) {
        this.certificateChain = certificates;
        this.privateKey = privateKey;
        this.certificateChainPemFile = null;
        this.privateKeyPkcs8File = null;
        this.certificateChainInputStream = null;
        this.privateKeyPkcs8InputStream = null;
        this.privateKeyPassword = privateKeyPassword;
        return this;
    }

    public BaseHttp2ServerBuilder<T> setTrustedClientCertificateChain(File certificatePemFile) {
        this.trustedClientCertificatePemFile = certificatePemFile;
        this.trustedClientCertificateInputStream = null;
        this.trustedClientCertificates = null;
        return this;
    }

    public BaseHttp2ServerBuilder<T> setTrustedClientCertificateChain(InputStream certificateInputStream) {
        this.trustedClientCertificatePemFile = null;
        this.trustedClientCertificateInputStream = certificateInputStream;
        this.trustedClientCertificates = null;
        return this;
    }

    public BaseHttp2ServerBuilder<T> setTrustedServerCertificateChain(X509Certificate ... certificates) {
        this.trustedClientCertificatePemFile = null;
        this.trustedClientCertificateInputStream = null;
        this.trustedClientCertificates = certificates;
        return this;
    }

    public BaseHttp2ServerBuilder<T> setEventLoopGroup(EventLoopGroup eventLoopGroup) {
        this.eventLoopGroup = eventLoopGroup;
        return this;
    }

    public BaseHttp2ServerBuilder<T> setMaxConcurrentStreams(int maxConcurrentStreams) {
        if (maxConcurrentStreams <= 0) {
            throw new IllegalArgumentException("Maximum number of concurrent streams must be positive.");
        }
        this.maxConcurrentStreams = maxConcurrentStreams;
        return this;
    }

    public BaseHttp2ServerBuilder<T> setUseAlpn(boolean useAlpn) {
        this.useAlpn = useAlpn;
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public T build() throws SSLException {
        SslContextBuilder sslContextBuilder;
        SslProvider sslProvider;
        if (OpenSsl.isAvailable()) {
            log.info("Native SSL provider is available; will use native provider.");
            sslProvider = SslProvider.OPENSSL;
        } else {
            log.info("Native SSL provider not available; will use JDK SSL provider.");
            sslProvider = SslProvider.JDK;
        }
        if (this.certificateChain != null && this.privateKey != null) {
            sslContextBuilder = SslContextBuilder.forServer((PrivateKey)this.privateKey, (String)this.privateKeyPassword, (X509Certificate[])this.certificateChain);
        } else if (this.certificateChainPemFile != null && this.privateKeyPkcs8File != null) {
            sslContextBuilder = SslContextBuilder.forServer((File)this.certificateChainPemFile, (File)this.privateKeyPkcs8File, (String)this.privateKeyPassword);
        } else if (this.certificateChainInputStream != null && this.privateKeyPkcs8InputStream != null) {
            sslContextBuilder = SslContextBuilder.forServer((InputStream)this.certificateChainInputStream, (InputStream)this.privateKeyPkcs8InputStream, (String)this.privateKeyPassword);
        } else {
            throw new IllegalStateException("Must specify server credentials before building a mock server.");
        }
        sslContextBuilder.sslProvider(sslProvider).ciphers((Iterable)Http2SecurityUtil.CIPHERS, (CipherSuiteFilter)SupportedCipherSuiteFilter.INSTANCE).clientAuth(ClientAuth.OPTIONAL);
        if (this.trustedClientCertificatePemFile != null) {
            sslContextBuilder.trustManager(this.trustedClientCertificatePemFile);
        } else if (this.trustedClientCertificateInputStream != null) {
            sslContextBuilder.trustManager(this.trustedClientCertificateInputStream);
        } else if (this.trustedClientCertificates != null) {
            sslContextBuilder.trustManager(this.trustedClientCertificates);
        }
        if (this.useAlpn) {
            sslContextBuilder.applicationProtocolConfig(new ApplicationProtocolConfig(ApplicationProtocolConfig.Protocol.ALPN, ApplicationProtocolConfig.SelectorFailureBehavior.NO_ADVERTISE, ApplicationProtocolConfig.SelectedListenerFailureBehavior.ACCEPT, new String[]{"h2"}));
        }
        SslContext sslContext = sslContextBuilder.build();
        try {
            T t = this.constructServer(sslContext);
            return t;
        }
        finally {
            if (sslContext instanceof ReferenceCounted) {
                ((ReferenceCounted)sslContext).release();
            }
        }
    }

    protected abstract T constructServer(SslContext var1);
}

