/*
 * Decompiled with CFR 0.152.
 */
package com.ebay.lightning.client;

import com.ebay.lightning.client.ServiceHostResolver;
import com.ebay.lightning.client.caller.LightningResponseCallback;
import com.ebay.lightning.client.caller.ServiceCaller;
import com.ebay.lightning.client.config.LightningClientConfig;
import com.ebay.lightning.core.beans.LightningRequest;
import com.ebay.lightning.core.beans.LightningResponse;
import com.ebay.lightning.core.beans.ReservationReceipt;
import com.ebay.lightning.core.beans.SystemStatus;
import com.ebay.lightning.core.beans.Task;
import com.ebay.lightning.core.config.RequestConfig;
import com.ebay.lightning.core.config.SystemConfig;
import com.ebay.lightning.core.store.LightningRequestReport;
import java.util.AbstractMap;
import java.util.List;
import java.util.UUID;

public interface LightningClient {
    public LightningRequest submit(List<Task> var1);

    public LightningRequest submit(List<Task> var1, RequestConfig var2);

    public void submitWithCallback(List<Task> var1, LightningResponseCallback var2, long var3);

    public void submitWithCallback(List<Task> var1, RequestConfig var2, LightningResponseCallback var3, long var4);

    public LightningResponse pollResponse(LightningRequest var1, boolean var2);

    public LightningRequestReport getAuditReport(LightningRequest var1);

    public LightningRequestReport getAuditReport(String var1, String var2);

    public LightningRequestReport getAuditJsonReport(String var1, String var2);

    public List<LightningRequestReport> getAuditSummary(String var1, String var2);

    public SystemConfig updateSystemConfig(String var1, SystemConfig var2);

    public SystemConfig getSystemConfig(String var1);

    public SystemStatus getLightningStats(String var1);

    public LightningClientConfig getConfig();

    public static class LightningClientImpl
    implements LightningClient {
        private final ServiceCaller caller;
        private final ServiceHostResolver resolver;
        private final LightningClientConfig config;

        public LightningClientImpl(LightningClientConfig config, ServiceHostResolver resolver, ServiceCaller caller) {
            this.caller = caller;
            this.resolver = resolver;
            this.config = config;
        }

        @Override
        public LightningRequest submit(List<Task> tasks) {
            return this.submit(tasks, null);
        }

        @Override
        public LightningRequest submit(List<Task> tasks, RequestConfig requestconfig) {
            AbstractMap.SimpleEntry<ReservationReceipt, String> resvIdEndpointPair = this.resolver.getNextEndPoint(tasks.size());
            ReservationReceipt reservationReciept = resvIdEndpointPair.getKey();
            String endPoint = resvIdEndpointPair.getValue();
            LightningRequest req = new LightningRequest(UUID.randomUUID().toString(), tasks, reservationReciept);
            req.setServingHostIp(endPoint);
            req.setRequestconfig(requestconfig);
            this.caller.submit(req, endPoint);
            return req;
        }

        @Override
        public LightningResponse pollResponse(LightningRequest req, boolean pollDeltaOnly) {
            return this.caller.pollResults(req.getSessionId(), req.getServingHostIp(), pollDeltaOnly);
        }

        @Override
        public void submitWithCallback(List<Task> tasks, LightningResponseCallback callback, long timeoutInMillis) {
            this.submitWithCallback(tasks, null, callback, timeoutInMillis);
        }

        @Override
        public void submitWithCallback(List<Task> tasks, RequestConfig requestconfig, LightningResponseCallback callback, long timeoutInMillis) {
            LightningRequest request = this.submit(tasks, requestconfig);
            this.addResponseCallback(request, callback, timeoutInMillis);
        }

        protected void addResponseCallback(final LightningRequest request, final LightningResponseCallback callback, final long timeoutInMillis) {
            new Thread(){

                @Override
                public void run() {
                    boolean notTimedOut = true;
                    long startTime = System.currentTimeMillis();
                    while (notTimedOut) {
                        boolean bl = notTimedOut = System.currentTimeMillis() - startTime < timeoutInMillis;
                        LightningResponse pollResults = LightningClientImpl.this.caller.pollResults(request.getSessionId(), request.getServingHostIp(), false);
                        if (!pollResults.isCompleted()) continue;
                        callback.onComplete(LightningClientImpl.this.caller.pollResults(request.getSessionId(), request.getServingHostIp(), false));
                        return;
                    }
                    callback.onTimeout(LightningClientImpl.this.caller.pollResults(request.getSessionId(), request.getServingHostIp(), false));
                }
            }.start();
        }

        @Override
        public LightningRequestReport getAuditReport(LightningRequest req) {
            return this.caller.getAuditReport(req.getSessionId(), req.getServingHostIp());
        }

        @Override
        public LightningRequestReport getAuditReport(String sessionId, String servingHostIp) {
            return this.caller.getAuditReport(sessionId, servingHostIp);
        }

        @Override
        public LightningRequestReport getAuditJsonReport(String sessionId, String servingHostIp) {
            return this.caller.getAuditJsonReport(sessionId, servingHostIp);
        }

        @Override
        public List<LightningRequestReport> getAuditSummary(String servingHostIp, String sessionId) {
            return this.caller.getAuditSummary(servingHostIp, sessionId);
        }

        @Override
        public SystemConfig updateSystemConfig(String servingHostIp, SystemConfig config) {
            return this.caller.updateSystemConfig(servingHostIp, config);
        }

        @Override
        public SystemConfig getSystemConfig(String servingHostIp) {
            return this.caller.getSystemConfig(servingHostIp);
        }

        @Override
        public SystemStatus getLightningStats(String servingHostIp) {
            return this.caller.getLightningStats(servingHostIp);
        }

        @Override
        public LightningClientConfig getConfig() {
            return this.config;
        }
    }
}

