/*
 * Decompiled with CFR 0.152.
 */
package com.ebay.lightning.client;

import com.ebay.lightning.client.LightningClient;
import com.ebay.lightning.client.ServiceHostResolver;
import com.ebay.lightning.client.caller.EmbeddedAPICaller;
import com.ebay.lightning.client.caller.RestAPICaller;
import com.ebay.lightning.client.caller.ServiceCaller;
import com.ebay.lightning.client.config.LightningClientConfig;
import com.ebay.lightning.core.config.SystemConfig;
import com.ebay.lightning.core.manager.TaskExecutionManager;
import com.ebay.lightning.core.services.TaskExecutionService;
import com.ebay.lightning.core.services.TaskExecutionServiceImpl;
import com.ebay.lightning.core.store.ExecutionDataStore;
import com.ebay.lightning.core.utils.InetSocketAddressCache;
import com.ebay.lightning.core.utils.UrlUtils;
import java.util.ArrayList;
import java.util.List;

public class LightningClientBuilder {
    private UrlUtils urlUtils = new UrlUtils();
    private List<String> seeds;
    private List<String> crossRegionSeeds;
    private String pollApiUrl = "http://{host}:port/l/poll";
    private String reserveApiUrl = "http://{host}:port/l/reserve";
    private String submitApiUrl = "http://{host}:port/l/submit";
    private String auditApiUrl = "http://{host}:port/l/audit";
    private String auditJsonApiUrl = "http://{host}:port/l/audit/json";
    private String auditSummaryUrl = "http://{host}:port/l/auditSummary";
    private String lightningStatsUrl = "http://{host}:port/l/lightningStats";
    private String systemConfigUrl = "http://{host}:port/l/getSystemConfig";
    private String systemConfigUpdateUrl = "http://{host}:port/l/updateSystemConfig";
    private boolean embeddedMode = false;
    private boolean allowCrossRegionInteraction = true;
    private int corePort;

    public LightningClient build() {
        LightningClientConfig config = new LightningClientConfig();
        config.setEmbeddedMode(this.embeddedMode);
        ServiceCaller apiCaller = null;
        if (this.embeddedMode) {
            SystemConfig systemConfig = new SystemConfig();
            ExecutionDataStore dataStore = new ExecutionDataStore(systemConfig);
            InetSocketAddressCache inetCache = new InetSocketAddressCache(systemConfig);
            TaskExecutionManager taskExecutionManager = new TaskExecutionManager(systemConfig, dataStore, inetCache);
            taskExecutionManager.start();
            TaskExecutionServiceImpl service = new TaskExecutionServiceImpl(taskExecutionManager);
            apiCaller = new EmbeddedAPICaller((TaskExecutionService)service);
            ArrayList<String> seedList = new ArrayList<String>();
            seedList.add("embeddedCoreService");
            config.setSeeds(seedList);
        } else {
            config.setPollApiUrl(this.pollApiUrl.replace(":port", ":" + this.corePort));
            config.setReserveApiUrl(this.reserveApiUrl.replace(":port", ":" + this.corePort));
            config.setSeeds(this.seeds);
            config.setSubmitApiUrl(this.submitApiUrl.replace(":port", ":" + this.corePort));
            config.setAuditApiUrl(this.auditApiUrl.replace(":port", ":" + this.corePort));
            config.setAuditJsonApiUrl(this.auditJsonApiUrl.replace(":port", ":" + this.corePort));
            config.setAuditSummaryUrl(this.auditSummaryUrl.replace(":port", ":" + this.corePort));
            config.setLightningStatsUrl(this.lightningStatsUrl.replace(":port", ":" + this.corePort));
            config.setSystemConfigUrl(this.systemConfigUrl.replace(":port", ":" + this.corePort));
            config.setSystemConfigUpdateUrl(this.systemConfigUpdateUrl.replace(":port", ":" + this.corePort));
            config.setCrossRegionSeeds(this.crossRegionSeeds);
            config.setAllowCrossRegionInteraction(this.allowCrossRegionInteraction);
            apiCaller = new RestAPICaller(config, this.urlUtils);
        }
        ServiceHostResolver resolver = new ServiceHostResolver(config, apiCaller);
        return new LightningClient.LightningClientImpl(config, resolver, apiCaller);
    }

    public LightningClientBuilder setUrlUtils(UrlUtils urlUtils) {
        this.urlUtils = urlUtils;
        return this;
    }

    public LightningClientBuilder setPollApiUrlTemplate(String pollApiUrl) {
        this.pollApiUrl = pollApiUrl;
        return this;
    }

    public LightningClientBuilder setReserveApiUrlTemplate(String reserveApiUrl) {
        this.reserveApiUrl = reserveApiUrl;
        return this;
    }

    public LightningClientBuilder setSeeds(List<String> seeds) {
        this.seeds = seeds;
        return this;
    }

    public LightningClientBuilder addSeed(String seed) {
        if (this.seeds == null) {
            this.seeds = new ArrayList<String>();
        }
        this.seeds.add(seed);
        return this;
    }

    public LightningClientBuilder setCrossRegionSeeds(List<String> crossRegionSeeds) {
        this.crossRegionSeeds = crossRegionSeeds;
        return this;
    }

    public LightningClientBuilder setSubmitApiUrlTemplate(String submitApiUrl) {
        this.submitApiUrl = submitApiUrl;
        return this;
    }

    public LightningClientBuilder setAuditApiUrlTemplate(String auditApiUrl) {
        this.auditApiUrl = auditApiUrl;
        return this;
    }

    public LightningClientBuilder setAuditJsonApiUrlTemplate(String auditJsonApiUrl) {
        this.auditJsonApiUrl = auditJsonApiUrl;
        return this;
    }

    public LightningClientBuilder setLightningStatsUrlTemplate(String lightningStatsUrl) {
        this.lightningStatsUrl = lightningStatsUrl;
        return this;
    }

    public LightningClientBuilder setAuditSummaryUrlTemplate(String auditSummaryUrl) {
        this.auditSummaryUrl = auditSummaryUrl;
        return this;
    }

    public LightningClientBuilder setSystemConfigUrlTemplate(String systemConfigUrl) {
        this.systemConfigUrl = systemConfigUrl;
        return this;
    }

    public LightningClientBuilder setSystemConfigUpdateUrlTemplate(String systemConfigUpdateUrl) {
        this.systemConfigUpdateUrl = systemConfigUpdateUrl;
        return this;
    }

    public LightningClientBuilder setEmbeddedMode(boolean mode) {
        this.embeddedMode = mode;
        return this;
    }

    public LightningClientBuilder setAllowCrossRegionInteraction(boolean allowCrossRegionInteraction) {
        this.allowCrossRegionInteraction = allowCrossRegionInteraction;
        return this;
    }

    public LightningClientBuilder setCorePort(int corePort) {
        this.corePort = corePort;
        return this;
    }
}

