/*
 * Decompiled with CFR 0.152.
 */
package com.ebay.lightning.client;

import com.ebay.lightning.client.caller.ServiceCaller;
import com.ebay.lightning.client.config.LightningClientConfig;
import com.ebay.lightning.core.beans.ReservationReceipt;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import java.util.AbstractMap;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.apache.log4j.Logger;

public class ServiceHostResolver {
    private static final Logger log = Logger.getLogger(ServiceHostResolver.class);
    private ServiceCaller apiCaller;
    private LightningClientConfig config;
    private ExecutorService executor;
    private int minimumSize = 1;

    public ServiceHostResolver(LightningClientConfig config, ServiceCaller apiCaller) {
        this.config = config;
        this.apiCaller = apiCaller;
        int seedSize = config.getSeeds() != null ? config.getSeeds().size() : 0;
        int threadPoolSize = seedSize > this.minimumSize ? seedSize : this.minimumSize;
        this.executor = Executors.newFixedThreadPool(threadPoolSize, new ThreadFactoryBuilder().setNameFormat("ServiceHostResolver-%d").build());
    }

    public AbstractMap.SimpleEntry<ReservationReceipt, String> getNextEndPoint(int forLoad) {
        List<String> seeds = this.getAllSeed(true);
        String errMsg = null;
        AbstractMap.SimpleEntry<ReservationReceipt, String> nextEndPoint = null;
        try {
            nextEndPoint = this.getNextEndPoint(forLoad, seeds);
        }
        catch (Exception e) {
            errMsg = "Error getting Endpoint in my region: " + e.getMessage();
        }
        if (nextEndPoint == null && this.config.isAllowCrossRegionInteraction() && this.config.getCrossRegionSeeds() != null) {
            try {
                seeds = this.config.getCrossRegionSeeds();
                log.info((Object)(errMsg + ", Now trying cross region seeds " + seeds));
                nextEndPoint = this.getNextEndPoint(forLoad, seeds);
            }
            catch (Exception e) {
                errMsg = errMsg + ", Error getting Endpoint in cross-region: " + e.getMessage();
            }
        }
        if (nextEndPoint == null && errMsg != null) {
            throw new RuntimeException(errMsg);
        }
        return nextEndPoint;
    }

    private AbstractMap.SimpleEntry<ReservationReceipt, String> getNextEndPoint(int forLoad, List<String> seeds) {
        int retryAttempt = 0;
        if (seeds != null && !seeds.isEmpty()) {
            while (retryAttempt++ < this.config.getMaxRetryAttempt()) {
                for (int i = 0; i < seeds.size(); ++i) {
                    try {
                        String seedToCall = seeds.get(i);
                        ReservationReceipt reservationRcptTemp = this.getReservationRcpt(forLoad, seedToCall);
                        boolean denied = ReservationReceipt.State.DENIED.equals((Object)reservationRcptTemp.getState());
                        if (denied) continue;
                        return new AbstractMap.SimpleEntry<ReservationReceipt, String>(reservationRcptTemp, seedToCall);
                    }
                    catch (Exception e) {
                        log.error((Object)("Unable to get reservation on" + seeds.get(i)), (Throwable)e);
                    }
                }
                log.info((Object)String.format("None of the seeds [%s] have accepted my reservation for load [%d], retrying attmept: %d", seeds, forLoad, retryAttempt));
                this.sleepFor(2000);
            }
            throw new RuntimeException(String.format("None of the seeds [%s] accepted  reservation for load [%d] even after %d retries", seeds, forLoad, this.config.getMaxRetryAttempt()));
        }
        throw new RuntimeException("No Seeds found ");
    }

    private ReservationReceipt getReservationRcpt(final int forLoad, final String seedToCall) throws InterruptedException, ExecutionException, TimeoutException {
        Future<ReservationReceipt> future = this.executor.submit(new Callable<ReservationReceipt>(){

            @Override
            public ReservationReceipt call() throws Exception {
                return ServiceHostResolver.this.apiCaller.reserve(forLoad, seedToCall);
            }
        });
        ReservationReceipt reservationRcptTemp = future.get(1000L, TimeUnit.MILLISECONDS);
        return reservationRcptTemp;
    }

    private void sleepFor(int sleepTime) {
        try {
            Thread.sleep(sleepTime);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    private List<String> getAllSeed(boolean shuffleSeeds) {
        List<String> result = this.config.getSeeds();
        if (shuffleSeeds) {
            Collections.shuffle(result);
        }
        return result;
    }

    protected void finalize() throws Throwable {
        super.finalize();
        this.executor.shutdownNow();
    }
}

