/*
 * Decompiled with CFR 0.152.
 */
package com.ebay.lightning.client.caller;

import com.ebay.lightning.client.caller.ServiceCaller;
import com.ebay.lightning.core.beans.LightningRequest;
import com.ebay.lightning.core.beans.LightningResponse;
import com.ebay.lightning.core.beans.ReservationReceipt;
import com.ebay.lightning.core.beans.SystemStatus;
import com.ebay.lightning.core.config.SystemConfig;
import com.ebay.lightning.core.services.TaskExecutionService;
import com.ebay.lightning.core.store.LightningRequestReport;
import java.util.List;

public class EmbeddedAPICaller
implements ServiceCaller {
    private TaskExecutionService service;

    public EmbeddedAPICaller(TaskExecutionService embeddedService) {
        this.service = embeddedService;
    }

    @Override
    public ReservationReceipt reserve(int forLoad, String serviceHostIp) {
        ReservationReceipt reservationReciept = null;
        try {
            reservationReciept = this.service.reserve(forLoad);
        }
        catch (Exception e) {
            throw new RuntimeException("Error Calling service: ", e);
        }
        return reservationReciept;
    }

    @Override
    public boolean submit(LightningRequest request, String serviceHostIp) {
        boolean success = false;
        try {
            this.service.submit(request);
            success = true;
        }
        catch (Exception e) {
            throw new RuntimeException("Error Calling service: ", e);
        }
        return success;
    }

    @Override
    public LightningResponse pollResults(String sessionId, String serviceHostIp, boolean pollDeltaOnly) {
        try {
            LightningResponse resp = this.service.pollResponse(sessionId, pollDeltaOnly);
            return resp;
        }
        catch (Exception e) {
            throw new RuntimeException("Error Calling service: ", e);
        }
    }

    @Override
    public LightningRequestReport getAuditReport(String sessionId, String serviceHostIp) {
        try {
            LightningRequestReport report = this.service.getReport(sessionId);
            return report;
        }
        catch (Exception e) {
            throw new RuntimeException("Error Calling service: ", e);
        }
    }

    @Override
    public LightningRequestReport getAuditJsonReport(String sessionId, String serviceHostIp) {
        try {
            return this.service.getReport(sessionId);
        }
        catch (Exception e) {
            throw new RuntimeException("Error Calling service: ", e);
        }
    }

    @Override
    public List<LightningRequestReport> getAuditSummary(String serviceHostIp, String sessionId) {
        try {
            return this.service.getAuditReports(sessionId);
        }
        catch (Exception e) {
            throw new RuntimeException("Error Calling service: ", e);
        }
    }

    @Override
    public SystemConfig updateSystemConfig(String serviceHostIp, SystemConfig sysConfig) {
        try {
            return this.service.updateSystemConfig(sysConfig);
        }
        catch (Exception e) {
            throw new RuntimeException("Error Calling service: ", e);
        }
    }

    @Override
    public SystemConfig getSystemConfig(String serviceHostIp) {
        try {
            return this.service.getSystemConfig();
        }
        catch (Exception e) {
            throw new RuntimeException("Error Calling service: ", e);
        }
    }

    @Override
    public SystemStatus getLightningStats(String serviceHostIp) {
        return this.service.getLightningStats();
    }
}

