/*
 * Decompiled with CFR 0.152.
 */
package com.ebay.lightning.client.caller;

import com.ebay.lightning.client.caller.ServiceCaller;
import com.ebay.lightning.client.config.LightningClientConfig;
import com.ebay.lightning.core.beans.LightningRequest;
import com.ebay.lightning.core.beans.LightningResponse;
import com.ebay.lightning.core.beans.ReservationReceipt;
import com.ebay.lightning.core.beans.SystemStatus;
import com.ebay.lightning.core.config.SystemConfig;
import com.ebay.lightning.core.store.LightningRequestReport;
import com.ebay.lightning.core.utils.UrlUtils;
import com.ebay.lightning.core.utils.ZipUtil;
import com.google.common.base.Preconditions;
import com.google.gson.Gson;
import com.google.gson.JsonParser;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

public class RestAPICaller
implements ServiceCaller {
    private static final Logger log = Logger.getLogger(RestAPICaller.class);
    private static final String HOST_VARIABLE_LITERAL = "{host}";
    private UrlUtils urlUtils;
    private LightningClientConfig config;

    public RestAPICaller(LightningClientConfig config, UrlUtils urlUtils) {
        this.urlUtils = urlUtils;
        this.config = config;
    }

    @Override
    public ReservationReceipt reserve(int forLoad, String serviceHostIp) {
        ReservationReceipt reservationReciept = null;
        String reserveApiUrl = this.config.getReserveApiUrl();
        try {
            reserveApiUrl = this.fillHostIP(this.config.getReserveApiUrl(), serviceHostIp) + "/" + forLoad;
            String response = this.urlUtils.get(reserveApiUrl);
            reservationReciept = (ReservationReceipt)new Gson().fromJson(response, ReservationReceipt.class);
        }
        catch (Exception e) {
            throw new RuntimeException("Error Calling Lightning Core @ URL: " + reserveApiUrl, e);
        }
        return reservationReciept;
    }

    private String fillHostIP(String reserveApiUrlTemplate, String serviceHostIp) {
        return reserveApiUrlTemplate.replace(HOST_VARIABLE_LITERAL, serviceHostIp);
    }

    @Override
    public boolean submit(LightningRequest request, String serviceHostIp) {
        boolean success = false;
        String url = this.fillHostIP(this.config.getSubmitApiUrl(), serviceHostIp);
        try {
            String payload = ZipUtil.zip((Object)request);
            String response = this.urlUtils.post(url, UrlUtils.ContentType.APPLICATION_JSON, null, payload);
            if ("submitted".equals(new JsonParser().parse(response).getAsJsonObject().get("status").getAsString())) {
                success = true;
            }
        }
        catch (Exception e) {
            throw new RuntimeException("Error Calling Lightning Core @URL: " + url, e);
        }
        return success;
    }

    @Override
    public LightningResponse pollResults(String sessionId, String serviceHostIp, boolean pollDeltaOnly) {
        String url = this.fillHostIP(this.config.getPollApiUrl(), serviceHostIp) + "/" + sessionId + "/" + pollDeltaOnly;
        try {
            byte[] response = this.urlUtils.getByteArray(url);
            LightningResponse resp = (LightningResponse)ZipUtil.unZipByteArray((byte[])response, LightningResponse.class);
            return resp;
        }
        catch (Exception e) {
            log.error((Object)("Error Calling URL" + url), (Throwable)e);
            return null;
        }
    }

    @Override
    public LightningRequestReport getAuditReport(String sessionId, String serviceHostIp) {
        Preconditions.checkNotNull((Object)this.config.getAuditApiUrl(), (Object)"Audit API is null. Please configure Audit API url");
        String url = this.fillHostIP(this.config.getAuditApiUrl(), serviceHostIp) + "/" + sessionId;
        try {
            byte[] response = this.urlUtils.getByteArray(url);
            LightningRequestReport report = (LightningRequestReport)ZipUtil.unZipByteArray((byte[])response, LightningRequestReport.class);
            return report;
        }
        catch (Exception e) {
            log.error((Object)("Error Calling URL: " + url), (Throwable)e);
            return null;
        }
    }

    @Override
    public LightningRequestReport getAuditJsonReport(String sessionId, String serviceHostIp) {
        String response = "";
        Preconditions.checkNotNull((Object)this.config.getAuditJsonApiUrl(), (Object)"Audit Json API is null. Please configure Audit Json API url");
        String url = this.fillHostIP(this.config.getAuditJsonApiUrl(), serviceHostIp) + "/" + sessionId;
        try {
            response = this.urlUtils.get(url);
            return (LightningRequestReport)new Gson().fromJson(response, LightningRequestReport.class);
        }
        catch (Exception e) {
            log.error((Object)("Error Calling URL: " + url), (Throwable)e);
            return null;
        }
    }

    @Override
    public List<LightningRequestReport> getAuditSummary(String serviceHostIp, String sessionId) {
        Preconditions.checkNotNull((Object)this.config.getAuditSummaryUrl(), (Object)"AuditSummary API is null. Please configure Audit Summary API url");
        String url = "";
        url = StringUtils.isNotEmpty((String)sessionId) ? this.fillHostIP(this.config.getAuditSummaryUrl(), serviceHostIp) + "?sessionId=" + sessionId : this.fillHostIP(this.config.getAuditSummaryUrl(), serviceHostIp);
        try {
            byte[] response = this.urlUtils.getByteArray(url);
            List reports = (List)ZipUtil.unZipByteArray((byte[])response);
            return reports;
        }
        catch (Exception e) {
            log.error((Object)("Error Calling URL: " + url), (Throwable)e);
            return null;
        }
    }

    @Override
    public SystemConfig updateSystemConfig(String serviceHostIp, SystemConfig sysConfig) {
        String response = "";
        Preconditions.checkNotNull((Object)serviceHostIp, (Object)"Update SystemConfig: hostname is null");
        String url = this.fillHostIP(this.config.getSystemConfigUpdateUrl(), serviceHostIp);
        try {
            response = this.urlUtils.post(url, UrlUtils.ContentType.APPLICATION_JSON, null, new Gson().toJson((Object)sysConfig));
            return (SystemConfig)new Gson().fromJson(response, SystemConfig.class);
        }
        catch (Exception e) {
            log.error((Object)("Error Calling system config update URL: " + url), (Throwable)e);
            return null;
        }
    }

    @Override
    public SystemConfig getSystemConfig(String serviceHostIp) {
        String response = "";
        Preconditions.checkNotNull((Object)serviceHostIp, (Object)"Update SystemConfig: hostname is null");
        String url = this.fillHostIP(this.config.getSystemConfigUrl(), serviceHostIp);
        try {
            response = this.urlUtils.get(url);
            return (SystemConfig)new Gson().fromJson(response, SystemConfig.class);
        }
        catch (Exception e) {
            log.error((Object)("Error Calling system config URL: " + url), (Throwable)e);
            return null;
        }
    }

    @Override
    public SystemStatus getLightningStats(String serviceHostIp) {
        Preconditions.checkNotNull((Object)this.config.getLightningStatsUrl(), (Object)"Lightning Stats API is null. Please configure Lightning Stats API url");
        String url = this.fillHostIP(this.config.getLightningStatsUrl(), serviceHostIp);
        SystemStatus stats = null;
        try {
            byte[] response = this.urlUtils.getByteArray(url);
            stats = (SystemStatus)ZipUtil.unZipByteArray((byte[])response, SystemStatus.class);
            stats.setHostName(serviceHostIp);
            stats.setSystemHealth(true);
        }
        catch (Exception e) {
            log.error((Object)("Error Calling lightning stats URL: " + url), (Throwable)e);
            stats = new SystemStatus();
            stats.setHostName(serviceHostIp);
            stats.setSystemStartTime(Long.getLong("0"));
            stats.setSystemHealth(false);
            stats.setSystemStatusErrorMsg(e.toString());
        }
        return stats;
    }
}

