/*
 * Decompiled with CFR 0.152.
 */
package bonsai;

import bonsai.Bonsai;
import bonsai.IsIn;
import bonsai.Leaf;
import bonsai.LessThan;
import bonsai.Model;
import bonsai.Model$;
import bonsai.Node;
import bonsai.Tree;
import java.io.File;
import java.io.PrintWriter;
import play.api.libs.json.JsObject;
import play.api.libs.json.JsValue;
import play.api.libs.json.Json$;
import play.api.libs.json.Reads;
import play.api.libs.json.Reads$;
import scala.App;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.GenIterable;
import scala.collection.IterableLike;
import scala.collection.LinearSeqOptimized;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ListBuffer;
import scala.collection.mutable.StringBuilder;
import scala.io.Codec$;
import scala.io.Source$;
import scala.math.Ordering;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;

public final class Bonsai$
implements App {
    public static final Bonsai$ MODULE$;
    private final String ind;
    private final long executionStart;
    private String[] scala$App$$_args;
    private final ListBuffer<Function0<BoxedUnit>> scala$App$$initCode;

    static {
        new Bonsai$();
    }

    public long executionStart() {
        return this.executionStart;
    }

    public String[] scala$App$$_args() {
        return this.scala$App$$_args;
    }

    public void scala$App$$_args_$eq(String[] x$1) {
        this.scala$App$$_args = x$1;
    }

    public ListBuffer<Function0<BoxedUnit>> scala$App$$initCode() {
        return this.scala$App$$initCode;
    }

    public void scala$App$_setter_$executionStart_$eq(long x$1) {
        this.executionStart = x$1;
    }

    public void scala$App$_setter_$scala$App$$initCode_$eq(ListBuffer x$1) {
        this.scala$App$$initCode = x$1;
    }

    public String[] args() {
        return App.class.args((App)this);
    }

    public void delayedInit(Function0<BoxedUnit> body2) {
        App.class.delayedInit((App)this, body2);
    }

    public void main(String[] args) {
        App.class.main((App)this, (String[])args);
    }

    public void processModel(String modelJsonFilename, Option<String> outCppFolder, Option<String> modelDataFilename, boolean prettyPrint) {
        Predef$.MODULE$.println((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Processing model: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{modelJsonFilename})));
        JsValue json = Json$.MODULE$.parse(this.fixAllScientificNotations(Source$.MODULE$.fromFile(modelJsonFilename, Codec$.MODULE$.fallbackSystemCodec()).mkString()));
        Model m = Model$.MODULE$.fromJSON(json);
        if (outCppFolder.isDefined()) {
            String resultFilename = new File((String)outCppFolder.get(), new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"model_", ".cpp"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{m.name()}))).getCanonicalPath();
            PrintWriter p = new PrintWriter(resultFilename);
            p.print(new StringBuilder().append((Object)this.generateCModel(m)).append((Object)"\n").toString());
            p.close();
            Predef$.MODULE$.println((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Converted to C++ file: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{resultFilename})));
        }
        if (modelDataFilename.isDefined()) {
            if (new File((String)modelDataFilename.get()).exists()) {
                Predef$.MODULE$.println((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Validating on file: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{modelDataFilename.get()})));
                Seq data = (Seq)Json$.MODULE$.parse(Source$.MODULE$.fromFile((String)modelDataFilename.get(), Codec$.MODULE$.fallbackSystemCodec()).mkString()).as(Reads$.MODULE$.traversableReads(Seq$.MODULE$.canBuildFrom(), (Reads)Reads$.MODULE$.JsObjectReads()));
                Tuple2 stat = (Tuple2)((LinearSeqOptimized)((TraversableOnce)data.map((Function1)new Serializable(m){
                    public static final long serialVersionUID = 0L;
                    private final Model m$1;

                    public final int apply(JsObject value) {
                        int n;
                        double calc = this.m$1.eval(value);
                        double orig = BoxesRunTime.unboxToDouble((Object)value.$bslash("model").as((Reads)Reads$.MODULE$.DoubleReads()));
                        double diff = orig - calc;
                        if (Math.abs(diff) > 1.0E-13) {
                            Predef$.MODULE$.println((Object)new Tuple3((Object)new StringBuilder().append((Object)"!Large Diff:").append((Object)BoxesRunTime.boxToDouble((double)diff)).toString(), (Object)new StringBuilder().append((Object)"Eval:").append((Object)BoxesRunTime.boxToDouble((double)calc)).toString(), (Object)new StringBuilder().append((Object)"Orig:").append((Object)BoxesRunTime.boxToDouble((double)orig)).toString()));
                            n = 1;
                        } else {
                            n = 0;
                        }
                        return n;
                    }
                    {
                        this.m$1 = m$1;
                    }
                }, Seq$.MODULE$.canBuildFrom())).toList().map((Function1)new Serializable(){
                    public static final long serialVersionUID = 0L;

                    public final Tuple2<Object, Object> apply(int x) {
                        return new Tuple2.mcII.sp(x, 1);
                    }
                }, List$.MODULE$.canBuildFrom())).foldLeft((Object)new Tuple2.mcII.sp(0, 0), (Function2)new Serializable(){
                    public static final long serialVersionUID = 0L;

                    public final Tuple2<Object, Object> apply(Tuple2<Object, Object> a, Tuple2<Object, Object> b) {
                        return new Tuple2.mcII.sp(a._1$mcI$sp() + b._1$mcI$sp(), a._2$mcI$sp() + b._2$mcI$sp());
                    }
                });
                if (stat._1$mcI$sp() == 0) {
                    Predef$.MODULE$.println((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Validation on ", " test cases SUCCEEDED with 0 errors."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)stat._2$mcI$sp())})));
                } else {
                    double arg$macro$1 = (double)100 * (double)stat._1$mcI$sp() / (double)stat._2$mcI$sp();
                    Integer arg$macro$2 = BoxesRunTime.boxToInteger((int)stat._1$mcI$sp());
                    Integer arg$macro$3 = BoxesRunTime.boxToInteger((int)stat._2$mcI$sp());
                    Predef$.MODULE$.println((Object)new StringOps("Validation FAILED with %2.2f%% error rate, i.e. %s of %s test cases failed.").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToDouble((double)arg$macro$1), arg$macro$2, arg$macro$3})));
                }
            } else {
                Predef$.MODULE$.println((Object)new StringBuilder().append((Object)"Validation not performed. Missing validation file: ").append(modelDataFilename.get()).toString());
            }
        }
        if (prettyPrint) {
            Predef$.MODULE$.println((Object)Json$.MODULE$.prettyPrint(json));
        }
    }

    public Option<String> processModel$default$2() {
        return None$.MODULE$;
    }

    public Option<String> processModel$default$3() {
        return None$.MODULE$;
    }

    public boolean processModel$default$4() {
        return false;
    }

    public String fixAllScientificNotations(String x) {
        return x.replaceAll("(\\d+)(e|E)\\+(\\d+)", "$1E$3");
    }

    public final String ind() {
        return "    ";
    }

    public String generateCModel(Model m) {
        return new StringBuilder().append((Object)((TraversableOnce)m.usedVariables().map((Function1)new Serializable(m){
            public static final long serialVersionUID = 0L;
            private final Model m$2;

            public final String apply(String variable) {
                return this.m$2.usedCategoricalVariables().contains((Object)variable) ? new StringBuilder().append((Object)"    uint64_t ").append((Object)variable).append((Object)"_catbit = <code to retrieve your values>;").toString() : new StringBuilder().append((Object)"    float ").append((Object)variable).append((Object)" = <code to retrieve your values>;").toString();
            }
            {
                this.m$2 = m$2;
            }
        }, Seq$.MODULE$.canBuildFrom())).mkString("\n")).append((Object)"\n\n").append((Object)"    ").append((Object)"/* Return value. */\n").append((Object)"    ").append((Object)"double net_response = 0.0;\n\n").append((Object)((TraversableOnce)((TraversableLike)m.trees().zip((GenIterable)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(1), m.trees().length()), Seq$.MODULE$.canBuildFrom())).map((Function1)new Serializable(m){
            public static final long serialVersionUID = 0L;
            private final Model m$2;

            public final String apply(Tuple2<Tree, Object> x0$1) {
                Tuple2<Tree, Object> tuple2 = x0$1;
                if (tuple2 != null) {
                    Tree tree = (Tree)tuple2._1();
                    int i = tuple2._2$mcI$sp();
                    String string = new StringBuilder().append((Object)"    /* Tree ").append((Object)BoxesRunTime.boxToInteger((int)i)).append((Object)" of ").append((Object)BoxesRunTime.boxToInteger((int)this.m$2.trees().length())).append((Object)". */\n").append((Object)Bonsai$.MODULE$.generateC(tree.top(), Bonsai$.MODULE$.generateC$default$2())).toString();
                    return string;
                }
                throw new MatchError(tuple2);
            }
            {
                this.m$2 = m$2;
            }
        }, Seq$.MODULE$.canBuildFrom())).mkString("\n")).append((Object)"\n").append((Object)"    ").append((Object)"return net_response;\n").append((Object)"}\n").toString();
    }

    public String generateC(Node node, String indent) {
        Node node2;
        block5: {
            String string;
            block3: {
                block4: {
                    block2: {
                        node2 = node;
                        if (!(node2 instanceof LessThan)) break block2;
                        LessThan lessThan = (LessThan)node2;
                        String variable = lessThan.variable();
                        double threshold = lessThan.threshold();
                        Node trueBranch = lessThan.trueBranch();
                        Node falseBranch = lessThan.falseBranch();
                        string = new StringBuilder().append((Object)indent).append((Object)"if (").append((Object)variable).append((Object)" < ").append((Object)BoxesRunTime.boxToDouble((double)threshold)).append((Object)"F) {\n").append((Object)this.generateC(trueBranch, new StringBuilder().append((Object)indent).append((Object)"    ").toString())).append((Object)indent).append((Object)"} else {\n").append((Object)this.generateC(falseBranch, new StringBuilder().append((Object)indent).append((Object)"    ").toString())).append((Object)indent).append((Object)"}\n").toString();
                        break block3;
                    }
                    if (!(node2 instanceof IsIn)) break block4;
                    IsIn isIn = (IsIn)node2;
                    String variable = isIn.variable();
                    Set<String> catSet = isIn.catSet();
                    Node trueBranch = isIn.trueBranch();
                    Node falseBranch = isIn.falseBranch();
                    List catBitMask = ((IterableLike)((SeqLike)catSet.toList().sorted((Ordering)Ordering.String$.MODULE$)).distinct()).grouped(12).map((Function1)new Serializable(){
                        public static final long serialVersionUID = 0L;

                        public final String apply(List<String> x$2) {
                            return x$2.mkString("CAT_BMASK(", ", ", ")");
                        }
                    }).toList();
                    String catBitMaskStr = catBitMask.size() > 1 ? catBitMask.mkString("(", " | ", ")") : catBitMask.mkString("");
                    string = new StringBuilder().append((Object)indent).append((Object)"if ((").append((Object)variable).append((Object)"_catbit & ").append((Object)catBitMaskStr).append((Object)") != 0) {\n").append((Object)this.generateC(trueBranch, new StringBuilder().append((Object)indent).append((Object)"    ").toString())).append((Object)indent).append((Object)"} else {\n").append((Object)this.generateC(falseBranch, new StringBuilder().append((Object)indent).append((Object)"    ").toString())).append((Object)indent).append((Object)"}\n").toString();
                    break block3;
                }
                if (!(node2 instanceof Leaf)) break block5;
                Leaf leaf = (Leaf)node2;
                double value = leaf.prediction();
                string = new StringBuilder().append((Object)indent).append((Object)"net_response += ").append((Object)BoxesRunTime.boxToDouble((double)value)).append((Object)";\n").toString();
            }
            return string;
        }
        throw new MatchError((Object)node2);
    }

    public String generateC$default$2() {
        return "    ";
    }

    /*
     * Enabled aggressive block sorting
     */
    public final void delayedEndpoint$bonsai$Bonsai$1() {
        boolean bl = false;
        .colon.colon colon2 = null;
        List list = Predef$.MODULE$.refArrayOps((Object[])this.args()).toList();
        if (list instanceof .colon.colon) {
            bl = true;
            colon2 = (.colon.colon)list;
            String string = (String)colon2.head();
            List list2 = colon2.tl$1();
            if ("-p".equals(string) && list2 instanceof .colon.colon) {
                .colon.colon colon3 = (.colon.colon)list2;
                String inputFile = (String)colon3.head();
                List list3 = colon3.tl$1();
                if (Nil$.MODULE$.equals(list3)) {
                    String x$4 = inputFile;
                    boolean x$5 = true;
                    Option<String> x$6 = this.processModel$default$2();
                    Option<String> x$7 = this.processModel$default$3();
                    this.processModel(x$4, x$6, x$7, x$5);
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    return;
                }
            }
        }
        if (bl) {
            String string = (String)colon2.head();
            List list4 = colon2.tl$1();
            if ("-e".equals(string) && list4 instanceof .colon.colon) {
                .colon.colon colon4 = (.colon.colon)list4;
                String inputFile = (String)colon4.head();
                List list5 = colon4.tl$1();
                if (list5 instanceof .colon.colon) {
                    .colon.colon colon5 = (.colon.colon)list5;
                    String dataFile = (String)colon5.head();
                    List list6 = colon5.tl$1();
                    if (Nil$.MODULE$.equals(list6)) {
                        String x$8 = inputFile;
                        Some x$9 = new Some((Object)dataFile);
                        Option<String> x$10 = this.processModel$default$2();
                        boolean x$11 = this.processModel$default$4();
                        this.processModel(x$8, x$10, (Option<String>)x$9, x$11);
                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                        return;
                    }
                }
            }
        }
        if (bl) {
            String string = (String)colon2.head();
            List modelFiles = colon2.tl$1();
            if ("-c".equals(string)) {
                modelFiles.foreach((Function1)new Serializable(){
                    public static final long serialVersionUID = 0L;

                    public final void apply(String jsonFilename) {
                        Bonsai$.MODULE$.processModel(jsonFilename, (Option<String>)new Some((Object)"."), Bonsai$.MODULE$.processModel$default$3(), Bonsai$.MODULE$.processModel$default$4());
                    }
                });
                Predef$.MODULE$.println();
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                return;
            }
        }
        if (bl) {
            String string = (String)colon2.head();
            List list7 = colon2.tl$1();
            if ("-a".equals(string) && list7 instanceof .colon.colon) {
                .colon.colon colon6 = (.colon.colon)list7;
                String modelsFolder = (String)colon6.head();
                List list8 = colon6.tl$1();
                if (Nil$.MODULE$.equals(list8)) {
                    Object object = Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])new File(modelsFolder).listFiles()).filter((Function1)new Serializable(){
                        public static final long serialVersionUID = 0L;

                        public final boolean apply(File x$1) {
                            return x$1.getName().toLowerCase().endsWith(".json");
                        }
                    })).map((Function1)new Serializable(modelsFolder){
                        public static final long serialVersionUID = 0L;
                        private final String modelsFolder$1;

                        public final void apply(File jsonFile) {
                            Bonsai$.MODULE$.processModel(jsonFile.getCanonicalPath(), (Option<String>)new Some((Object)this.modelsFolder$1), (Option<String>)new Some((Object)jsonFile.getCanonicalPath().replaceAll("\\.json$", ".tsv")), Bonsai$.MODULE$.processModel$default$4());
                            Predef$.MODULE$.println();
                        }
                        {
                            this.modelsFolder$1 = modelsFolder$1;
                        }
                    }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Unit()));
                    return;
                }
            }
        }
        System.err.println("Usage: \n to pretty-print a json moodel: Bonsai -p modelFile\n to evaluate a model over a test file: Bonsai -e modelFile dataFile\n to generate C++ code: Bonsai -c (modelFile)*\n to do all (generate *.cpp for all *.json models and evaluate them on *.tsv files): Bonsai -a folderWithFiles");
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    private Bonsai$() {
        MODULE$ = this;
        App.class.$init$((App)this);
        this.delayedInit((Function0<BoxedUnit>)new Bonsai.delayedInit.body(this));
    }
}

