/*
 * Decompiled with CFR 0.152.
 */
package com.ebiznext.comet.config;

import com.ebiznext.comet.config.Settings;
import com.ebiznext.comet.schema.handlers.StorageHandler;
import org.apache.hadoop.fs.Path;
import scala.Function1;
import scala.Predef$;
import scala.Serializable;
import scala.collection.Iterable;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

public final class DatasetArea$ {
    public static DatasetArea$ MODULE$;

    static {
        new DatasetArea$();
    }

    public Path path(String domain, String area, Settings settings) {
        return new Path(new StringBuilder(2).append(settings.comet().datasets()).append("/").append(area).append("/").append(domain).toString());
    }

    public Path path(Path domainPath, String schema) {
        return new Path(domainPath, schema);
    }

    public Path pending(String domain, Settings settings) {
        return this.path(domain, settings.comet().area().pending(), settings);
    }

    public Path unresolved(String domain, Settings settings) {
        return this.path(domain, settings.comet().area().unresolved(), settings);
    }

    public Path archive(String domain, Settings settings) {
        return this.path(domain, settings.comet().area().archive(), settings);
    }

    public Path ingesting(String domain, Settings settings) {
        return this.path(domain, settings.comet().area().ingesting(), settings);
    }

    public Path accepted(String domain, Settings settings) {
        return this.path(domain, settings.comet().area().accepted(), settings);
    }

    public Path rejected(String domain, Settings settings) {
        return this.path(domain, settings.comet().area().rejected(), settings);
    }

    public Path metrics(String domain, String schema, Settings settings) {
        String path = settings.comet().metrics().path();
        return this.substituteDomainAndSchemaInPath(domain, schema, path);
    }

    public Path assertions(String domain, String schema, Settings settings) {
        String path = settings.comet().assertions().path();
        return this.substituteDomainAndSchemaInPath(domain, schema, path);
    }

    public Path substituteDomainAndSchemaInPath(String domain, String schema, String path) {
        return new Path(path.replace("{domain}", domain).replace("{schema}", schema));
    }

    public Path discreteMetrics(String domain, String schema, Settings settings) {
        return new Path(this.metrics(domain, schema, settings), "discrete");
    }

    public Path continuousMetrics(String domain, String schema, Settings settings) {
        return new Path(this.metrics(domain, schema, settings), "continuous");
    }

    public Path frequenciesMetrics(String domain, String schema, Settings settings) {
        return new Path(this.metrics(domain, schema, settings), "frequencies");
    }

    public Path business(String domain, Settings settings) {
        return this.path(domain, settings.comet().area().business(), settings);
    }

    public Path metadata(Settings settings) {
        return new Path(String.valueOf(settings.comet().metadata()));
    }

    public Path types(Settings settings) {
        return new Path(this.metadata(settings), "types");
    }

    public Path assertions(Settings settings) {
        return new Path(this.metadata(settings), "assertions");
    }

    public Path mapping(Settings settings) {
        return new Path(this.metadata(settings), "mapping");
    }

    public Path domains(Settings settings) {
        return new Path(this.metadata(settings), "domains");
    }

    public Path jobs(Settings settings) {
        return new Path(this.metadata(settings), "jobs");
    }

    public Path views(Settings settings) {
        return new Path(this.metadata(settings), "views");
    }

    public Path views(String viewsPath, Settings settings) {
        return viewsPath.startsWith("/") ? new Path(this.views(settings), (String)new StringOps(Predef$.MODULE$.augmentString(viewsPath)).drop(1)) : new Path(this.views(settings), viewsPath);
    }

    public void initMetadata(StorageHandler storage, Settings settings) {
        new .colon.colon((Object)this.metadata(settings), (List)new .colon.colon((Object)this.types(settings), (List)new .colon.colon((Object)this.domains(settings), (List)new .colon.colon((Object)this.jobs(settings), (List)new .colon.colon((Object)this.assertions(settings), (List)new .colon.colon((Object)this.views(settings), (List)new .colon.colon((Object)this.mapping(settings), (List)Nil$.MODULE$))))))).foreach((Function1 & java.io.Serializable & Serializable)path -> BoxesRunTime.boxToBoolean((boolean)storage.mkdirs(path)));
    }

    public void initDomains(StorageHandler storage, Iterable<String> domains, Settings settings) {
        domains.foreach((Function1 & java.io.Serializable & Serializable)domain -> {
            DatasetArea$.$anonfun$initDomains$1(settings, storage, domain);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ void $anonfun$initDomains$1(Settings settings$1, StorageHandler storage$2, String domain2) {
        ((List)new .colon.colon((Function1 & java.io.Serializable & Serializable)domain -> MODULE$.pending((String)domain, settings$1), (List)new .colon.colon((Function1 & java.io.Serializable & Serializable)domain -> MODULE$.unresolved((String)domain, settings$1), (List)new .colon.colon((Function1 & java.io.Serializable & Serializable)domain -> MODULE$.archive((String)domain, settings$1), (List)new .colon.colon((Function1 & java.io.Serializable & Serializable)domain -> MODULE$.accepted((String)domain, settings$1), (List)new .colon.colon((Function1 & java.io.Serializable & Serializable)domain -> MODULE$.rejected((String)domain, settings$1), (List)new .colon.colon((Function1 & java.io.Serializable & Serializable)domain -> MODULE$.business((String)domain, settings$1), (List)Nil$.MODULE$)))))).map((Function1 & java.io.Serializable & Serializable)x$1 -> (Path)x$1.apply((Object)domain2), List$.MODULE$.canBuildFrom())).foreach((Function1 & java.io.Serializable & Serializable)path -> BoxesRunTime.boxToBoolean((boolean)storage$2.mkdirs(path)));
    }

    private DatasetArea$() {
        MODULE$ = this;
    }
}

