/*
 * Decompiled with CFR 0.152.
 */
package com.ebiznext.comet.extractor;

import better.files.File;
import com.ebiznext.comet.config.DatasetArea$;
import com.ebiznext.comet.config.Settings;
import com.ebiznext.comet.config.StorageArea;
import com.ebiznext.comet.extractor.ExtractScriptGenConfig;
import com.ebiznext.comet.extractor.ExtractScriptGenConfig$;
import com.ebiznext.comet.extractor.TemplateParams;
import com.ebiznext.comet.extractor.TemplateParams$;
import com.ebiznext.comet.extractor.config.Settings$;
import com.ebiznext.comet.job.transform.AutoTaskJob;
import com.ebiznext.comet.schema.handlers.HdfsStorageHandler;
import com.ebiznext.comet.schema.handlers.LaunchHandler;
import com.ebiznext.comet.schema.handlers.SchemaHandler;
import com.ebiznext.comet.schema.handlers.SimpleLauncher;
import com.ebiznext.comet.schema.handlers.StorageHandler;
import com.ebiznext.comet.schema.model.AutoJobDesc;
import com.ebiznext.comet.schema.model.AutoTaskDesc;
import com.ebiznext.comet.schema.model.Domain;
import com.ebiznext.comet.schema.model.Engine;
import com.ebiznext.comet.schema.model.Engine$BQ$;
import com.ebiznext.comet.schema.model.Engine$SPARK$;
import com.ebiznext.comet.schema.model.RowLevelSecurity;
import com.ebiznext.comet.schema.model.Sink;
import com.ebiznext.comet.schema.model.Views;
import com.ebiznext.comet.schema.model.WriteMode;
import com.ebiznext.comet.utils.Formatter$;
import com.ebiznext.comet.workflow.IngestionWorkflow;
import com.typesafe.scalalogging.Logger;
import com.typesafe.scalalogging.StrictLogging;
import java.io.Serializable;
import java.nio.charset.Charset;
import org.fusesource.scalate.TemplateEngine;
import org.fusesource.scalate.TemplateEngine$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.IterableLike;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u0005\u0005e\u0001B\b\u0011\u0001eA\u0001\u0002\u000b\u0001\u0003\u0002\u0003\u0006I!\u000b\u0005\tc\u0001\u0011\t\u0011)A\u0005e!AQ\u0007\u0001B\u0001B\u0003%a\u0007\u0003\u0005:\u0001\t\u0005\t\u0015a\u0003;\u0011\u0015\u0001\u0005\u0001\"\u0001B\u0011\u001dI\u0005A1A\u0005\u0002)Ca!\u0016\u0001!\u0002\u0013Y\u0005\"\u0002,\u0001\t\u00039\u0006\"\u0002:\u0001\t\u0003\u0019\bbBA\u0016\u0001\u0011\u0005\u0011Q\u0006\u0005\b\u0003\u0003\u0002A\u0011AA\"\u0011\u001d\t\t\u0005\u0001C\u0001\u0003+Bq!a\u0019\u0001\t\u0013\t)\u0007C\u0004\u0002v\u0001!I!a\u001e\u0003\u0013M\u001b'/\u001b9u\u000f\u0016t'BA\t\u0013\u0003%)\u0007\u0010\u001e:bGR|'O\u0003\u0002\u0014)\u0005)1m\\7fi*\u0011QCF\u0001\tK\nL'P\\3yi*\tq#A\u0002d_6\u001c\u0001aE\u0002\u00015\u0001\u0002\"a\u0007\u0010\u000e\u0003qQ\u0011!H\u0001\u0006g\u000e\fG.Y\u0005\u0003?q\u0011a!\u00118z%\u00164\u0007CA\u0011'\u001b\u0005\u0011#BA\u0012%\u00031\u00198-\u00197bY><w-\u001b8h\u0015\t)c#\u0001\u0005usB,7/\u00194f\u0013\t9#EA\u0007TiJL7\r\u001e'pO\u001eLgnZ\u0001\u000fgR|'/Y4f\u0011\u0006tG\r\\3s!\tQs&D\u0001,\u0015\taS&\u0001\u0005iC:$G.\u001a:t\u0015\tq##\u0001\u0004tG\",W.Y\u0005\u0003a-\u0012ab\u0015;pe\u0006<W\rS1oI2,'/A\u0007tG\",W.\u0019%b]\u0012dWM\u001d\t\u0003UMJ!\u0001N\u0016\u0003\u001bM\u001b\u0007.Z7b\u0011\u0006tG\r\\3s\u00035a\u0017-\u001e8dQ\"\u000bg\u000e\u001a7feB\u0011!fN\u0005\u0003q-\u0012Q\u0002T1v]\u000eD\u0007*\u00198eY\u0016\u0014\u0018\u0001C:fiRLgnZ:\u0011\u0005mrT\"\u0001\u001f\u000b\u0005u\u0012\u0012AB2p]\u001aLw-\u0003\u0002@y\tA1+\u001a;uS:<7/\u0001\u0004=S:LGO\u0010\u000b\u0005\u0005\u001a;\u0005\n\u0006\u0002D\u000bB\u0011A\tA\u0007\u0002!!)\u0011(\u0002a\u0002u!)\u0001&\u0002a\u0001S!)\u0011'\u0002a\u0001e!)Q'\u0002a\u0001m\u00051QM\\4j]\u0016,\u0012a\u0013\t\u0003\u0019Nk\u0011!\u0014\u0006\u0003\u001d>\u000bqa]2bY\u0006$XM\u0003\u0002Q#\u0006Qa-^:fg>,(oY3\u000b\u0003I\u000b1a\u001c:h\u0013\t!VJ\u0001\bUK6\u0004H.\u0019;f\u000b:<\u0017N\\3\u0002\u000f\u0015tw-\u001b8fA\u0005QA/Z7qY\u0006$\u0018N_3\u0015\u0007a\u001bW\u000e\u0005\u0002ZA:\u0011!L\u0018\t\u00037ri\u0011\u0001\u0018\u0006\u0003;b\ta\u0001\u0010:p_Rt\u0014BA0\u001d\u0003\u0019\u0001&/\u001a3fM&\u0011\u0011M\u0019\u0002\u0007'R\u0014\u0018N\\4\u000b\u0005}c\u0002\"\u00023\t\u0001\u0004)\u0017\u0001\u0003;f[Bd\u0017\r^3\u0011\u0005\u0019\\W\"A4\u000b\u0005!L\u0017!\u00024jY\u0016\u001c(\"\u00016\u0002\r\t,G\u000f^3s\u0013\tawM\u0001\u0003GS2,\u0007\"\u00028\t\u0001\u0004y\u0017A\u0004;f[Bd\u0017\r^3QCJ\fWn\u001d\t\u0003\tBL!!\u001d\t\u0003\u001dQ+W\u000e\u001d7bi\u0016\u0004\u0016M]1ng\u0006qq-\u001a8fe\u0006$X\rR8nC&tG\u0003\u0004;~\u0003\u0017\ty!a\u0005\u0002\u001e\u0005\u0005\u0002cA;{K:\u0011a\u000f\u001f\b\u00037^L\u0011!H\u0005\u0003sr\tq\u0001]1dW\u0006<W-\u0003\u0002|y\n!A*[:u\u0015\tIH\u0004C\u0003\u007f\u0013\u0001\u0007q0\u0001\u0004e_6\f\u0017N\u001c\t\u0005\u0003\u0003\t9!\u0004\u0002\u0002\u0004)\u0019\u0011QA\u0017\u0002\u000b5|G-\u001a7\n\t\u0005%\u00111\u0001\u0002\u0007\t>l\u0017-\u001b8\t\r\u00055\u0011\u00021\u0001f\u0003I\u00198M]5qiR+W\u000e\u001d7bi\u00164\u0015\u000e\\3\t\r\u0005E\u0011\u00021\u0001f\u0003E\u00198M]5qiN|U\u000f\u001e9viB\u000bG\u000f\u001b\u0005\b\u0003+I\u0001\u0019AA\f\u0003M\u00198M]5qi>+H\u000f];u!\u0006$H/\u001a:o!\u0011Y\u0012\u0011\u0004-\n\u0007\u0005mAD\u0001\u0004PaRLwN\u001c\u0005\b\u0003?I\u0001\u0019AA\f\u0003I!WMZ1vYR$U\r\u001c;b\u0007>dW/\u001c8\t\u000f\u0005\r\u0012\u00021\u0001\u0002&\u0005aA-\u001a7uC\u000e{G.^7ogB)\u0011,a\nY1&\u0019\u0011\u0011\u00062\u0003\u00075\u000b\u0007/A\u0006hK:,'/\u0019;f\u0015>\u0014G#C3\u00020\u0005e\u00121HA \u0011\u001d\t\tD\u0003a\u0001\u0003g\t1A[8c!\u0011\t\t!!\u000e\n\t\u0005]\u00121\u0001\u0002\f\u0003V$xNS8c\t\u0016\u001c8\r\u0003\u0004\u0002\u000e)\u0001\r!\u001a\u0005\u0007\u0003{Q\u0001\u0019A3\u0002'M\u001c'/\u001b9ug>+H\u000f];u\r>dG-\u001a:\t\u000f\u0005U!\u00021\u0001\u0002\u0018\u0005\u0019!/\u001e8\u0015\t\u0005\u0015\u00131\n\t\u00047\u0005\u001d\u0013bAA%9\t9!i\\8mK\u0006t\u0007bBA'\u0017\u0001\u0007\u0011qJ\u0001\u0005CJ<7\u000f\u0005\u0003\u001c\u0003#B\u0016bAA*9\t)\u0011I\u001d:bsR!\u0011qKA.)\u0011\t)%!\u0017\t\u000beb\u00019\u0001\u001e\t\rub\u0001\u0019AA/!\r!\u0015qL\u0005\u0004\u0003C\u0002\"AF#yiJ\f7\r^*de&\u0004HoR3o\u0007>tg-[4\u0002\u0019I,hn\u00148E_6\f\u0017N\\:\u0015\u0011\u0005\u0015\u0013qMA5\u0003WBa!P\u0007A\u0002\u0005u\u0003\"B\u0019\u000e\u0001\u0004\u0011\u0004bBA7\u001b\u0001\u0007\u0011qN\u0001\fI>l\u0017-\u001b8OC6,7\u000f\u0005\u0003v\u0003cB\u0016bAA:y\n\u00191+Z9\u0002\u0013I,hn\u00148K_\n\u001cH\u0003CA#\u0003s\nY(! \t\rur\u0001\u0019AA/\u0011\u0015\td\u00021\u00013\u0011\u001d\tyH\u0004a\u0001\u0003_\n\u0001B[8c\u001d\u0006lWm\u001d")
public class ScriptGen
implements StrictLogging {
    private final SchemaHandler schemaHandler;
    private final Settings settings;
    private final TemplateEngine engine;
    private final Logger logger;

    public Logger logger() {
        return this.logger;
    }

    public void com$typesafe$scalalogging$StrictLogging$_setter_$logger_$eq(Logger x$1) {
        this.logger = x$1;
    }

    public TemplateEngine engine() {
        return this.engine;
    }

    public String templatize(File template, TemplateParams templateParams) {
        return this.engine().layout(template.pathAsString(), templateParams.paramMap(), this.engine().layout$default$3());
    }

    public List<File> generateDomain(Domain domain, File scriptTemplateFile, File scriptsOutputPath, Option<String> scriptOutputPattern, Option<String> defaultDeltaColumn, Map<String, String> deltaColumns) {
        List<TemplateParams> templateSettings = TemplateParams$.MODULE$.fromDomain(domain, scriptsOutputPath, scriptOutputPattern, defaultDeltaColumn, deltaColumns, this.settings);
        return (List)templateSettings.map((Function1 & Serializable & scala.Serializable)ts -> {
            BoxedUnit boxedUnit;
            String scriptPayload = this.templatize(scriptTemplateFile, (TemplateParams)ts);
            boolean x$1 = ts.scriptOutputFile().createFileIfNotExists$default$1();
            Seq x$2 = ts.scriptOutputFile().createFileIfNotExists$default$2(x$1);
            Seq x$3 = ts.scriptOutputFile().createFileIfNotExists$default$3(x$1);
            File qual$1 = ts.scriptOutputFile().createFileIfNotExists(x$1, x$2, x$3);
            String x$4 = scriptPayload;
            Seq x$5 = qual$1.overwrite$default$2(x$4);
            Charset x$6 = qual$1.overwrite$default$3(x$4);
            File scriptFile = qual$1.overwrite(x$4, x$5, x$6);
            if (this.logger().underlying().isInfoEnabled()) {
                this.logger().underlying().info("Successfully generated script {}", new Object[]{scriptFile});
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            return scriptFile;
        }, List$.MODULE$.canBuildFrom());
    }

    public File generateJob(AutoJobDesc job, File scriptTemplateFile, File scriptsOutputFolder, Option<String> scriptOutputPattern) {
        BoxedUnit boxedUnit;
        IngestionWorkflow workflow = new IngestionWorkflow(this.settings.metadataStorageHandler(), this.schemaHandler, new SimpleLauncher(), this.settings);
        Seq<AutoTaskJob> actions = workflow.buildTasks(job.name(), (Map<String, String>)Predef$.MODULE$.Map().empty());
        actions.map((Function1 & Serializable & scala.Serializable)action -> {
            Tuple3<List<String>, String, List<String>> tuple3;
            Engine engine = action.engine();
            if (((Object)Engine$BQ$.MODULE$).equals(engine)) {
                tuple3 = action.buildQueryBQ();
            } else if (((Object)Engine$SPARK$.MODULE$).equals(engine)) {
                tuple3 = action.buildQuerySpark();
            } else {
                throw new Exception("not supported");
            }
            Tuple3<List<String>, String, List<String>> tuple32 = tuple3;
            if (tuple32 == null) {
                throw new MatchError(tuple32);
            }
            List preSql = (List)tuple32._1();
            String sql = (String)tuple32._2();
            List postSql = (List)tuple32._3();
            Tuple3 tuple33 = new Tuple3((Object)preSql, (Object)sql, (Object)postSql);
            Tuple3 tuple34 = tuple33;
            List preSql2 = (List)tuple34._1();
            String sql2 = (String)tuple34._2();
            List postSql2 = (List)tuple34._3();
            Some x$1 = new Some((Object)preSql2);
            Option x$2 = Option$.MODULE$.apply((Object)sql2);
            Some x$3 = new Some((Object)postSql2);
            Option<String> x$4 = action.task().copy$default$1();
            String x$5 = action.task().copy$default$3();
            String x$6 = action.task().copy$default$4();
            WriteMode x$7 = action.task().copy$default$5();
            Option<List<String>> x$8 = action.task().copy$default$6();
            Option<StorageArea> x$9 = action.task().copy$default$9();
            Option<Sink> x$10 = action.task().copy$default$10();
            Option<List<RowLevelSecurity>> x$11 = action.task().copy$default$11();
            Option<Map<String, String>> x$12 = action.task().copy$default$12();
            AutoTaskDesc x$13 = action.task().copy(x$4, (Option<String>)x$2, x$5, x$6, x$7, x$8, (Option<List<String>>)x$1, (Option<List<String>>)x$3, x$9, x$10, x$11, x$12);
            String x$14 = action.copy$default$1();
            StorageArea x$15 = action.copy$default$2();
            Option<String> x$16 = action.copy$default$3();
            boolean x$17 = action.copy$default$4();
            Option<String> x$18 = action.copy$default$5();
            Views x$19 = action.copy$default$6();
            Engine x$20 = action.copy$default$7();
            Map<String, String> x$21 = action.copy$default$9();
            Settings x$22 = $this.settings;
            HdfsStorageHandler x$23 = $this.settings.metadataStorageHandler();
            SchemaHandler x$24 = $this.schemaHandler;
            return action.copy(x$14, x$15, x$16, x$17, x$18, x$19, x$20, x$13, x$21, x$22, x$23, x$24);
        }, Seq$.MODULE$.canBuildFrom());
        String scriptPayload = this.engine().layout(scriptTemplateFile.pathAsString(), (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"job"), (Object)job), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"actions"), actions), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"env"), this.schemaHandler.activeEnv())})), this.engine().layout$default$3());
        String scriptOutputFileName = (String)scriptOutputPattern.map((Function1 & Serializable & scala.Serializable)x$2 -> Formatter$.MODULE$.RichFormatter((String)x$2).richFormat((Map<String, String>)((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"job"), (Object)job.name())}))), $this.settings)).getOrElse((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(3).append(job.name()).append(".py").toString());
        File scriptOutputFile = scriptsOutputFolder.$div(scriptOutputFileName);
        boolean x$25 = scriptOutputFile.createFileIfNotExists$default$1();
        Seq x$26 = scriptOutputFile.createFileIfNotExists$default$2(x$25);
        Seq x$27 = scriptOutputFile.createFileIfNotExists$default$3(x$25);
        File qual$1 = scriptOutputFile.createFileIfNotExists(x$25, x$26, x$27);
        String x$28 = scriptPayload;
        Seq x$29 = qual$1.overwrite$default$2(x$28);
        Charset x$30 = qual$1.overwrite$default$3(x$28);
        File scriptFile = qual$1.overwrite(x$28, x$29, x$30);
        if (this.logger().underlying().isInfoEnabled()) {
            this.logger().underlying().info("Successfully generated job script {}", new Object[]{scriptFile});
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        return scriptFile;
    }

    public boolean run(String[] args) {
        boolean bl;
        BoxedUnit boxedUnit;
        List arglist = new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])args)).toList();
        if (this.logger().underlying().isInfoEnabled()) {
            this.logger().underlying().info("Running Comet {}", new Object[]{arglist});
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        Option<ExtractScriptGenConfig> option = ExtractScriptGenConfig$.MODULE$.parse((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])args));
        if (option instanceof Some) {
            Some some = (Some)option;
            ExtractScriptGenConfig config = (ExtractScriptGenConfig)some.value();
            bl = this.run(config, this.settings);
        } else {
            BoxedUnit boxedUnit2;
            if (this.logger().underlying().isErrorEnabled()) {
                this.logger().underlying().error("Program execution or parameters are wrong, please check usage");
                boxedUnit2 = BoxedUnit.UNIT;
            } else {
                boxedUnit2 = BoxedUnit.UNIT;
            }
            bl = false;
        }
        return bl;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean run(ExtractScriptGenConfig config, Settings settings) {
        BoxedUnit boxedUnit;
        DatasetArea$.MODULE$.initMetadata(settings.metadataStorageHandler(), settings);
        SchemaHandler schemaHandler = new SchemaHandler(settings.metadataStorageHandler(), settings);
        Tuple2 tuple2 = new Tuple2(config.domain(), config.jobs());
        if (tuple2 != null) {
            Seq seq = (Seq)tuple2._1();
            Seq seq2 = (Seq)tuple2._2();
            if (Nil$.MODULE$.equals(seq) && Nil$.MODULE$.equals(seq2)) {
                BoxedUnit boxedUnit2;
                if (this.logger().underlying().isErrorEnabled()) {
                    this.logger().underlying().error("One of domain or jobs should be provided");
                    boxedUnit2 = BoxedUnit.UNIT;
                    return false;
                } else {
                    boxedUnit2 = BoxedUnit.UNIT;
                }
                return false;
            }
        }
        if (tuple2 != null) {
            Seq seq = (Seq)tuple2._1();
            Seq jobNames = (Seq)tuple2._2();
            if (Nil$.MODULE$.equals(seq)) {
                return this.runOnJobs(config, schemaHandler, (Seq<String>)jobNames);
            }
        }
        if (tuple2 != null) {
            Seq domainNames = (Seq)tuple2._1();
            Seq seq = (Seq)tuple2._2();
            if (Nil$.MODULE$.equals(seq)) {
                return this.runOnDomains(config, schemaHandler, (Seq<String>)domainNames);
            }
        }
        if (tuple2 == null) throw new MatchError((Object)tuple2);
        if (this.logger().underlying().isErrorEnabled()) {
            this.logger().underlying().error("Only one of domain or job list should be passed as an argument");
            boxedUnit = BoxedUnit.UNIT;
            return false;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        return false;
    }

    private boolean runOnDomains(ExtractScriptGenConfig config, SchemaHandler schemaHandler, Seq<String> domainNames) {
        List<Domain> domains = schemaHandler.domains();
        return ((IterableLike)domainNames.map((Function1 & Serializable & scala.Serializable)domainName -> BoxesRunTime.boxToBoolean((boolean)ScriptGen.$anonfun$runOnDomains$1(this, domains, config, domainName)), Seq$.MODULE$.canBuildFrom())).forall((Function1 & Serializable & scala.Serializable)x$4 -> BoxesRunTime.boxToBoolean((boolean)ScriptGen.$anonfun$runOnDomains$4(BoxesRunTime.unboxToBoolean((Object)x$4))));
    }

    private boolean runOnJobs(ExtractScriptGenConfig config, SchemaHandler schemaHandler, Seq<String> jobNames) {
        Map<String, AutoJobDesc> jobs2 = schemaHandler.jobs();
        return ((IterableLike)jobNames.map((Function1 & Serializable & scala.Serializable)jobName -> BoxesRunTime.boxToBoolean((boolean)ScriptGen.$anonfun$runOnJobs$1(this, jobs2, config, jobName)), Seq$.MODULE$.canBuildFrom())).forall((Function1 & Serializable & scala.Serializable)x$5 -> BoxesRunTime.boxToBoolean((boolean)ScriptGen.$anonfun$runOnJobs$2(BoxesRunTime.unboxToBoolean((Object)x$5))));
    }

    public static final /* synthetic */ boolean $anonfun$runOnDomains$2(String domainName$1, Domain x$3) {
        String string = x$3.name();
        String string2 = domainName$1;
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public static final /* synthetic */ boolean $anonfun$runOnDomains$1(ScriptGen $this, List domains$1, ExtractScriptGenConfig config$1, String domainName) {
        boolean bl;
        Option option = domains$1.find((Function1 & Serializable & scala.Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)ScriptGen.$anonfun$runOnDomains$2(domainName, x$3)));
        if (option instanceof Some) {
            Some some = (Some)option;
            Domain domain = (Domain)some.value();
            $this.generateDomain(domain, config$1.scriptTemplateFile(), config$1.scriptOutputDir(), config$1.scriptOutputPattern(), (Option<String>)config$1.deltaColumn().orElse((Function0 & Serializable & scala.Serializable)() -> Settings$.MODULE$.deltaColumns().defaultColumn()), Settings$.MODULE$.deltaColumns().deltaColumns());
            bl = true;
        } else if (None$.MODULE$.equals(option)) {
            BoxedUnit boxedUnit;
            if ($this.logger().underlying().isErrorEnabled()) {
                $this.logger().underlying().error("No domain found for domain name {}", new Object[]{config$1.domain()});
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            bl = false;
        } else {
            throw new MatchError((Object)option);
        }
        return bl;
    }

    public static final /* synthetic */ boolean $anonfun$runOnDomains$4(boolean x$4) {
        return x$4;
    }

    public static final /* synthetic */ boolean $anonfun$runOnJobs$1(ScriptGen $this, Map jobs$1, ExtractScriptGenConfig config$2, String jobName) {
        boolean bl;
        Option option = jobs$1.get((Object)jobName);
        if (option instanceof Some) {
            Some some = (Some)option;
            AutoJobDesc job = (AutoJobDesc)some.value();
            $this.generateJob(job, config$2.scriptTemplateFile(), config$2.scriptOutputDir(), config$2.scriptOutputPattern());
            bl = true;
        } else if (None$.MODULE$.equals(option)) {
            BoxedUnit boxedUnit;
            if ($this.logger().underlying().isErrorEnabled()) {
                $this.logger().underlying().error("No file found for domain name {}", new Object[]{config$2.domain()});
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            bl = false;
        } else {
            throw new MatchError((Object)option);
        }
        return bl;
    }

    public static final /* synthetic */ boolean $anonfun$runOnJobs$2(boolean x$5) {
        return x$5;
    }

    public ScriptGen(StorageHandler storageHandler, SchemaHandler schemaHandler, LaunchHandler launchHandler, Settings settings) {
        this.schemaHandler = schemaHandler;
        this.settings = settings;
        StrictLogging.$init$((StrictLogging)this);
        this.engine = new TemplateEngine(TemplateEngine$.MODULE$.$lessinit$greater$default$1(), TemplateEngine$.MODULE$.$lessinit$greater$default$2());
    }
}

